/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.CustomGraphics2Manager;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.NullCustomGraphics;
import org.cytoscape.cg.util.ImageCustomGraphicsSelector;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2Factory;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyValueEditor;

public class CyCustomGraphicsValueEditor
implements VisualPropertyValueEditor<CyCustomGraphics> {
    private boolean editCancelled;
    private JTabbedPane groupTpn;
    private JPanel bottomPnl;
    private Map<String, CustomGraphics2Panel> cg2PnlMap;
    private JButton removeBtn;
    private JButton cancelBtn;
    private JButton applyBtn;
    private CyCustomGraphics<?> oldCustomGraphics;
    private CyCustomGraphics<?> newCustomGraphics;
    private boolean initialized;
    private final CyServiceRegistrar serviceRegistrar;
    private JDialog dialog;
    private ImageCustomGraphicsSelector imageSelector;

    public CyCustomGraphicsValueEditor(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.cg2PnlMap = new HashMap<String, CustomGraphics2Panel>();
    }

    public <S extends CyCustomGraphics> CyCustomGraphics<? extends CustomGraphicLayer> showEditor(Component parent, S initialValue, VisualProperty<S> vp) {
        CustomGraphicsManager manager;
        Collection<CyCustomGraphics> allCustomGraphics;
        Object ret;
        this.oldCustomGraphics = initialValue;
        if (!this.initialized) {
            this.init(parent);
            this.initialized = true;
        }
        this.update(vp.getTargetDataType());
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
        CyCustomGraphics<?> cyCustomGraphics = ret = this.editCancelled ? this.oldCustomGraphics : this.newCustomGraphics;
        if (ret instanceof AbstractURLImageCustomGraphics && !(allCustomGraphics = (manager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class)).getAllCustomGraphics()).contains(ret)) {
            ret = NullCustomGraphics.getNullObject();
        }
        return ret;
    }

    public Class<CyCustomGraphics> getValueType() {
        return CyCustomGraphics.class;
    }

    private void init(Component parent) {
        Window owner = parent != null ? SwingUtilities.getWindowAncestor(parent) : null;
        this.dialog = new JDialog(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setMinimumSize(new Dimension(400, 600));
        this.dialog.setPreferredSize(new Dimension(600, 600));
        this.dialog.setTitle("Graphics");
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CyCustomGraphicsValueEditor.this.cancel();
            }
        });
        GroupLayout layout = new GroupLayout(this.dialog.getContentPane());
        this.dialog.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getGroupTpn(), -1, -1, Short.MAX_VALUE).addComponent(this.getBottomPnl(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getGroupTpn(), -1, -1, Short.MAX_VALUE).addComponent(this.getBottomPnl()));
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.dialog.getRootPane(), (Action)this.getApplyBtn().getAction(), (Action)this.getCancelBtn().getAction());
        this.dialog.getRootPane().setDefaultButton(this.getApplyBtn());
    }

    private void update(Class<? extends CyIdentifiable> targetType) {
        this.getGroupTpn().removeAll();
        this.imageSelector = this.createImageSelector();
        this.getGroupTpn().addTab("Images", this.imageSelector);
        JPanel newSelectedComp = this.imageSelector;
        CyCustomGraphics2 oldCg2 = this.oldCustomGraphics instanceof CyCustomGraphics2 ? (CyCustomGraphics2)this.oldCustomGraphics : null;
        CustomGraphics2Manager cg2Mgr = (CustomGraphics2Manager)this.serviceRegistrar.getService(CustomGraphics2Manager.class);
        for (String group : cg2Mgr.getGroups()) {
            CustomGraphics2Panel cg2Pnl = this.getCG2Pnl(group);
            if (cg2Pnl == null) continue;
            cg2Pnl.update(oldCg2, targetType);
            if (cg2Pnl.getEditorCount() <= 0) continue;
            String title = group;
            if (targetType == CyColumn.class && group == "Charts") {
                title = "Sparklines";
            }
            this.getGroupTpn().addTab(title, cg2Pnl);
            if (!(this.oldCustomGraphics instanceof CyCustomGraphics2) || !cg2Pnl.canEdit((CyCustomGraphics2)this.oldCustomGraphics)) continue;
            newSelectedComp = cg2Pnl;
        }
        this.getGroupTpn().setSelectedComponent(newSelectedComp);
    }

    private void remove() {
        this.editCancelled = false;
        this.newCustomGraphics = NullCustomGraphics.getNullObject();
        this.dialog.dispose();
    }

    private void cancel() {
        this.editCancelled = true;
        this.dialog.dispose();
    }

    private void apply() {
        this.editCancelled = false;
        Component c = this.getGroupTpn().getSelectedComponent();
        if (c instanceof ImageCustomGraphicsSelector) {
            this.newCustomGraphics = ((ImageCustomGraphicsSelector)c).getSelectedImage();
        } else if (c instanceof CustomGraphics2Panel) {
            this.newCustomGraphics = ((CustomGraphics2Panel)c).getCustomGraphics2();
        }
        if (this.newCustomGraphics == null) {
            this.newCustomGraphics = NullCustomGraphics.getNullObject();
        }
        this.dialog.dispose();
    }

    private JTabbedPane getGroupTpn() {
        if (this.groupTpn == null) {
            this.groupTpn = new JTabbedPane();
        }
        return this.groupTpn;
    }

    private JPanel getBottomPnl() {
        if (this.bottomPnl == null) {
            this.bottomPnl = LookAndFeelUtil.createOkCancelPanel((JButton)this.getApplyBtn(), (JButton)this.getCancelBtn(), (JComponent[])new JComponent[]{this.getRemoveBtn()});
        }
        return this.bottomPnl;
    }

    private ImageCustomGraphicsSelector createImageSelector() {
        ImageCustomGraphicsSelector comp = new ImageCustomGraphicsSelector(this.oldCustomGraphics, this.serviceRegistrar);
        if (LookAndFeelUtil.isAquaLAF()) {
            comp.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
        }
        comp.addActionListener(evt -> this.apply());
        return comp;
    }

    private CustomGraphics2Panel getCG2Pnl(String group) {
        CustomGraphics2Panel cg2Pnl = this.cg2PnlMap.get(group);
        if (cg2Pnl == null) {
            cg2Pnl = new CustomGraphics2Panel(group);
            cg2Pnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.cg2PnlMap.put(group, cg2Pnl);
        }
        return cg2Pnl;
    }

    public JButton getRemoveBtn() {
        if (this.removeBtn == null) {
            this.removeBtn = new JButton("Remove Graphics");
            this.removeBtn.addActionListener(evt -> this.remove());
        }
        return this.removeBtn;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null) {
            this.cancelBtn = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CyCustomGraphicsValueEditor.this.cancel();
                }
            });
        }
        return this.cancelBtn;
    }

    private JButton getApplyBtn() {
        if (this.applyBtn == null) {
            this.applyBtn = new JButton(new AbstractAction("Apply"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CyCustomGraphicsValueEditor.this.apply();
                }
            });
        }
        return this.applyBtn;
    }

    private class CustomGraphics2Panel
    extends JPanel {
        static final int ICON_SIZE = 18;
        private final String group;
        private Collection<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> supportedFactories = Collections.emptyList();
        private CyCustomGraphics2 cg2;
        private boolean updatingTypes;
        private JTabbedPane typeTpn;

        public CustomGraphics2Panel(String group) {
            this.group = group;
            this.setLayout(new BorderLayout());
            this.add((Component)this.getTypeTpn(), "Center");
        }

        String getGroup() {
            return this.group;
        }

        boolean canEdit(CyCustomGraphics2 cg2) {
            for (CyCustomGraphics2Factory<? extends CustomGraphicLayer> cf : this.supportedFactories) {
                if (!cf.getSupportedClass().isAssignableFrom(cg2.getClass())) continue;
                return true;
            }
            return false;
        }

        CyCustomGraphics2 getCustomGraphics2() {
            return this.cg2;
        }

        int getEditorCount() {
            return this.getTypeTpn().getTabCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(CyCustomGraphics2 cg2, Class<? extends CyIdentifiable> targetType) {
            this.updatingTypes = true;
            CustomGraphics2Manager cg2Mgr = (CustomGraphics2Manager)CyCustomGraphicsValueEditor.this.serviceRegistrar.getService(CustomGraphics2Manager.class);
            this.supportedFactories = cg2Mgr.getCustomGraphics2Factories(targetType, this.group);
            CustomGraphics2EditorPane selectedEditorPn = null;
            int maxWidth = 100;
            try {
                this.getTypeTpn().removeAll();
                CyCustomGraphics2 initialCg2 = null;
                for (CyCustomGraphics2Factory<? extends CustomGraphicLayer> cf : this.supportedFactories) {
                    CustomGraphics2EditorPane cg2EditorPn = new CustomGraphics2EditorPane(cf, targetType);
                    Icon icon = cf.getIcon(18, 18);
                    if (cg2 != null) {
                        HashMap props = new HashMap(cg2.getProperties());
                        if (!cf.getSupportedClass().isAssignableFrom(cg2.getClass())) {
                            props.remove("cy_colorScheme");
                            props.remove("cy_colors");
                        }
                        initialCg2 = cf.getInstance(props);
                        if (cf.getSupportedClass().isAssignableFrom(cg2.getClass())) {
                            selectedEditorPn = cg2EditorPn;
                            this.cg2 = initialCg2;
                        }
                    } else {
                        initialCg2 = cf.getInstance(new HashMap());
                        this.cg2 = null;
                    }
                    cg2EditorPn.update(initialCg2);
                    if (cg2EditorPn.getEditor() == null) continue;
                    this.getTypeTpn().addTab(icon == null ? cf.getDisplayName() : "", icon, cg2EditorPn, cf.getDisplayName());
                    maxWidth = Math.max(maxWidth, cg2EditorPn.getPreferredSize().width);
                }
                if (this.getEditorCount() > 0) {
                    if (selectedEditorPn != null) {
                        this.getTypeTpn().setSelectedComponent(selectedEditorPn);
                    } else {
                        this.getTypeTpn().setSelectedIndex(0);
                    }
                }
            }
            finally {
                this.updatingTypes = false;
            }
            if (this.cg2 == null && (selectedEditorPn = (CustomGraphics2EditorPane)this.getTypeTpn().getSelectedComponent()) != null) {
                this.cg2 = selectedEditorPn.getCg2();
            }
            this.getTypeTpn().setPreferredSize(new Dimension(maxWidth + 40, 520));
        }

        private JTabbedPane getTypeTpn() {
            if (this.typeTpn == null) {
                this.typeTpn = new JTabbedPane();
                this.typeTpn.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (CustomGraphics2Panel.this.updatingTypes) {
                            return;
                        }
                        Component c = CustomGraphics2Panel.this.typeTpn.getSelectedComponent();
                        if (c instanceof CustomGraphics2EditorPane) {
                            CyCustomGraphics2Factory<?> cf = ((CustomGraphics2EditorPane)c).getFactory();
                            if (CustomGraphics2Panel.this.cg2 == null || !cf.getSupportedClass().isAssignableFrom(CustomGraphics2Panel.this.cg2.getClass())) {
                                HashMap props = CustomGraphics2Panel.this.cg2 != null ? new HashMap(CustomGraphics2Panel.this.cg2.getProperties()) : new HashMap();
                                props.remove("cy_colorScheme");
                                props.remove("cy_colors");
                                CustomGraphics2Panel.this.cg2 = cf.getInstance(props);
                            }
                            ((CustomGraphics2EditorPane)c).update(CustomGraphics2Panel.this.cg2);
                        }
                    }
                });
            }
            return this.typeTpn;
        }

        @Override
        public String toString() {
            return "CG2 Panel for " + this.group;
        }

        private class CustomGraphics2EditorPane
        extends JScrollPane {
            private JComponent editor;
            private CyCustomGraphics2 cg2;
            private final CyCustomGraphics2Factory<?> factory;
            private final Class<? extends CyIdentifiable> targetType;

            CustomGraphics2EditorPane(CyCustomGraphics2Factory<?> factory, Class<? extends CyIdentifiable> targetType) {
                this.factory = factory;
                this.targetType = targetType;
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setOpaque(!LookAndFeelUtil.isAquaLAF());
                this.getViewport().setOpaque(!LookAndFeelUtil.isAquaLAF());
            }

            void update(CyCustomGraphics2 initialCg2) {
                this.cg2 = initialCg2;
                this.editor = this.factory.createEditor(initialCg2);
                if (this.editor instanceof AbstractChartEditor) {
                    ((AbstractChartEditor)this.editor).setTargetType(this.targetType);
                }
                this.setViewportView(this.editor);
                this.updateUI();
            }

            CyCustomGraphics2 getCg2() {
                return this.cg2;
            }

            CyCustomGraphics2Factory<?> getFactory() {
                return this.factory;
            }

            JComponent getEditor() {
                return this.editor;
            }

            @Override
            public String toString() {
                return "CG2EditorPane for " + this.factory.getDisplayName();
            }
        }
    }
}

