/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.PercentLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.cytoscape.cg.internal.editor.CyCustomGraphicsCellRenderer;
import org.cytoscape.cg.internal.editor.CyCustomGraphicsValueEditor;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

public class CyCustomGraphicsPropertyEditor
extends AbstractPropertyEditor {
    private final CyCustomGraphicsValueEditor valueEditor;
    private CyCustomGraphicsCellRenderer label;
    private JButton button;
    private VisualProperty<CyCustomGraphics> visualProperty;
    private CyCustomGraphics<?> customGraphics;
    private CyCustomGraphics<?> oldCustomGraphics;
    private final CyServiceRegistrar serviceRegistrar;

    public CyCustomGraphicsPropertyEditor(CyCustomGraphicsValueEditor valueEditor, CyServiceRegistrar serviceRegistrar) {
        this.valueEditor = valueEditor;
        this.serviceRegistrar = serviceRegistrar;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new JPanel((LayoutManager)new PercentLayout(0, 0));
            ((JPanel)this.editor).setOpaque(false);
            this.label = new CyCustomGraphicsCellRenderer();
            ((JPanel)this.editor).add("*", (Component)((Object)this.label));
            this.label.setOpaque(false);
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.button = ComponentFactory.Helper.getFactory().createMiniButton();
            ((JPanel)this.editor).add(this.button);
            this.button.setText("\uf141");
            this.button.setFont(iconManager.getIconFont(13.0f));
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CyCustomGraphicsPropertyEditor.this.editChart();
                }
            });
            this.button = ComponentFactory.Helper.getFactory().createMiniButton();
            ((JPanel)this.editor).add(this.button);
            this.button.setText("\uf00d");
            this.button.setFont(iconManager.getIconFont(13.0f));
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CyCustomGraphics<?> old = CyCustomGraphicsPropertyEditor.this.customGraphics;
                    CyCustomGraphicsPropertyEditor.this.label.setValue(null);
                    CyCustomGraphicsPropertyEditor.this.customGraphics = null;
                    CyCustomGraphicsPropertyEditor.this.firePropertyChange(old, null);
                }
            });
        }
        return super.getCustomEditor();
    }

    public Object getValue() {
        return this.customGraphics;
    }

    public void setValue(Object value) {
        this.customGraphics = (CyCustomGraphics)value;
        this.label.setValue(value);
    }

    public void setVisualProperty(VisualProperty<CyCustomGraphics> visualProperty) {
        this.visualProperty = visualProperty;
    }

    private void editChart() {
        CyCustomGraphics<CustomGraphicLayer> newVal = this.valueEditor.showEditor((Component)null, this.customGraphics, this.visualProperty);
        if (newVal != null) {
            this.setValue(newVal);
            this.firePropertyChange(null, newVal);
            this.oldCustomGraphics = newVal;
        }
    }
}

