/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.editor;

import com.kitfox.svg.app.beans.SVGIcon;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.cytoscape.cg.internal.util.IconUtil;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.util.CustomGraphicsUtil;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

public class CyCustomGraphicsCellRenderer
extends DefaultCellRenderer {
    private final int WIDTH = 20;
    private final int HEIGHT = 20;

    public CyCustomGraphicsCellRenderer() {
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this});
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        if (value instanceof CyCustomGraphics) {
            CyCustomGraphics cg = (CyCustomGraphics)value;
            if (cg instanceof SVGCustomGraphics) {
                URL url = ((SVGCustomGraphics)cg).getSourceURL();
                SVGIcon icon = new SVGIcon();
                icon.setSvgResourcePath(url.getPath());
                this.setIcon((Icon)icon);
            } else {
                Image img = cg.getRenderedImage();
                this.setIcon(img != null ? IconUtil.resizeIcon(new ImageIcon(img), 20, 20) : null);
            }
            this.setText(CustomGraphicsUtil.getShortName(cg.getDisplayName()));
            this.setHorizontalTextPosition(4);
            this.setVerticalTextPosition(0);
            this.setIconTextGap(10);
        } else {
            this.setIcon(null);
            this.setText(null);
        }
        return this;
    }
}

