/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.util;

import java.awt.Color;
import java.awt.Paint;
import org.cytoscape.cg.internal.util.MathUtil;
import org.jdesktop.swingx.color.ColorUtil;
import org.jfree.chart.renderer.PaintScale;

public class ColorScale
implements PaintScale {
    private final double lowerBound;
    private final double upperBound;
    private final Color lowerColor;
    private final Color zeroColor;
    private final Color upperColor;
    private final Color nanColor;
    private static double EPSILON = 1.0E-30;

    public ColorScale(double lowerBound, double upperBound, Color lowerColor, Color zeroColor, Color upperColor, Color nanColor) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerColor = lowerColor;
        this.zeroColor = zeroColor;
        this.upperColor = upperColor;
        this.nanColor = nanColor;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public Color getLowerColor() {
        return this.lowerColor;
    }

    public Color getZeroColor() {
        return this.zeroColor;
    }

    public Color getUpperColor() {
        return this.upperColor;
    }

    public Color getNanColor() {
        return this.nanColor;
    }

    public Paint getPaint(double value) {
        if (Double.isNaN(value)) {
            return this.nanColor;
        }
        return ColorScale.getPaint(value, this.lowerBound, this.upperBound, this.lowerColor, this.zeroColor, this.upperColor);
    }

    public static Paint getPaint(double value, double lowerBound, double upperBound, Color lowerColor, Color zeroColor, Color upperColor) {
        boolean hasZero;
        boolean bl = hasZero = lowerBound < -EPSILON && upperBound > EPSILON && zeroColor != null;
        if (hasZero && value < EPSILON && value > -EPSILON) {
            return zeroColor;
        }
        Color color = value < 0.0 ? lowerColor : upperColor;
        double f = value < 0.0 ? MathUtil.invLinearInterp(value, lowerBound, 0.0) : MathUtil.invLinearInterp(value, 0.0, upperBound);
        float t = (float)(value < 0.0 ? MathUtil.linearInterp(f, 0.0, 1.0) : MathUtil.linearInterp(f, 1.0, 0.0));
        t = Math.max(0.0f, t);
        t = Math.min(1.0f, t);
        return ColorUtil.interpolate((Color)zeroColor, (Color)color, (float)t);
    }
}

