/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.line;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.charts.AbstractChartLayer;
import org.cytoscape.cg.internal.charts.CustomCategoryItemLabelGenerator;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.util.EqualDashStroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class LineLayer
extends AbstractChartLayer<CategoryDataset> {
    private final boolean showRangeZeroBaseline;
    private final float lineWidth;

    public LineLayer(Map<String, List<Double>> data, List<String> itemLabels, List<String> domainLabels, List<String> rangeLabels, boolean showItemLabels, boolean showDomainAxis, boolean showRangeAxis, boolean showRangeZeroBaseline, float itemFontSize, LabelPosition domainLabelPosition, List<Color> colors, float axisWidth, Color axisColor, float axisFontSize, List<Double> range, float lineWidth) {
        super(data, itemLabels, domainLabels, rangeLabels, showItemLabels, showDomainAxis, showRangeAxis, itemFontSize, domainLabelPosition, colors, axisWidth, axisColor, axisFontSize, 0.0f, TRANSPARENT_COLOR, range);
        this.showRangeZeroBaseline = showRangeZeroBaseline;
        this.lineWidth = lineWidth >= 0.0f ? lineWidth : 1.0f;
    }

    @Override
    protected CategoryDataset createDataset() {
        return LineLayer.createCategoryDataset(this.data, true, this.domainLabels);
    }

    @Override
    protected JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setAntiAlias(true);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        chart.setBackgroundImageAlpha(0.0f);
        chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setOutlineVisible(false);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setAxisOffset(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setBackgroundAlpha(0.0f);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        if (this.showRangeZeroBaseline) {
            plot.setRangeZeroBaselineVisible(true);
            plot.setRangeZeroBaselinePaint((Paint)this.axisColor);
            plot.setRangeZeroBaselineStroke((Stroke)new EqualDashStroke(this.axisWidth));
        }
        BasicStroke axisStroke = new BasicStroke(this.axisWidth, 1, 1);
        BasicStroke gridLineStroke = new BasicStroke(this.axisWidth, 1, 1, 0.5f, new float[]{0.5f}, 0.0f);
        plot.setRangeGridlineStroke((Stroke)gridLineStroke);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(this.showDomainAxis);
        domainAxis.setAxisLineStroke((Stroke)axisStroke);
        domainAxis.setAxisLinePaint((Paint)this.axisColor);
        domainAxis.setTickMarksVisible(true);
        domainAxis.setTickMarkStroke((Stroke)axisStroke);
        domainAxis.setTickMarkPaint((Paint)this.axisColor);
        domainAxis.setTickLabelsVisible(true);
        domainAxis.setTickLabelFont(domainAxis.getTickLabelFont().deriveFont(this.axisFontSize).deriveFont(0));
        domainAxis.setTickLabelPaint((Paint)this.axisColor);
        domainAxis.setCategoryLabelPositions(this.getCategoryLabelPosition());
        domainAxis.setCategoryMargin(0.1);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setVisible(this.showRangeAxis);
        rangeAxis.setAxisLineStroke((Stroke)axisStroke);
        rangeAxis.setAxisLinePaint((Paint)this.axisColor);
        rangeAxis.setTickMarkStroke((Stroke)axisStroke);
        rangeAxis.setTickMarkPaint((Paint)this.axisColor);
        rangeAxis.setTickLabelFont(rangeAxis.getLabelFont().deriveFont(this.axisFontSize).deriveFont(0));
        rangeAxis.setTickLabelPaint((Paint)this.axisColor);
        rangeAxis.setLowerMargin(0.0);
        rangeAxis.setUpperMargin(0.0);
        if (this.range != null && this.range.size() >= 2 && this.range.get(0) != null && this.range.get(1) != null) {
            rangeAxis.setLowerBound((Double)this.range.get(0) * 1.1);
            rangeAxis.setUpperBound((Double)this.range.get(1) * 1.1);
        }
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)(this.showItemLabels ? new CustomCategoryItemLabelGenerator(this.itemLabels) : null));
        renderer.setBaseItemLabelsVisible(this.showItemLabels);
        renderer.setBaseItemLabelFont(renderer.getBaseItemLabelFont().deriveFont(this.itemFontSize));
        renderer.setBaseItemLabelPaint((Paint)this.labelColor);
        BasicStroke seriesStroke = new BasicStroke(this.lineWidth, 1, 1);
        List keys = dataset.getRowKeys();
        if (this.colors != null && this.colors.size() >= keys.size()) {
            for (int i = 0; i < keys.size(); ++i) {
                Color c = (Color)this.colors.get(i);
                renderer.setSeriesPaint(i, (Paint)c);
                renderer.setSeriesStroke(i, (Stroke)seriesStroke);
            }
        }
        return chart;
    }
}

