/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.line;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.internal.charts.line.LineChart;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class LineChartEditor
extends AbstractChartEditor<LineChart> {
    private JLabel lineWidthLbl;
    private JTextField lineWidthTxt;

    public LineChartEditor(LineChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, Number.class, true, true, false, true, true, false, true, true, serviceRegistrar);
        this.getBorderPnl().setVisible(false);
    }

    @Override
    protected void createLabels() {
        super.createLabels();
        this.lineWidthLbl = new JLabel("Line Width:");
    }

    @Override
    protected JPanel getOtherAdvancedOptionsPnl() {
        JPanel p = super.getOtherAdvancedOptionsPnl();
        p.setVisible(true);
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.lineWidthLbl).addComponent(this.getLineWidthTxt(), -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.lineWidthLbl).addComponent(this.getLineWidthTxt())));
        return p;
    }

    private JTextField getLineWidthTxt() {
        if (this.lineWidthTxt == null) {
            this.lineWidthTxt = new JTextField("" + ((LineChart)this.chart).get("cy_lineWidth", Float.class, Float.valueOf(2.0f)));
            this.lineWidthTxt.setInputVerifier(new AbstractChartEditor.DoubleInputVerifier());
            this.lineWidthTxt.setPreferredSize(new Dimension(40, this.lineWidthTxt.getMinimumSize().height));
            this.lineWidthTxt.setHorizontalAlignment(11);
            this.lineWidthTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        float width = Double.valueOf(LineChartEditor.this.lineWidthTxt.getText().trim()).floatValue();
                        ((LineChart)LineChartEditor.this.chart).set("cy_lineWidth", Float.valueOf(width));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.lineWidthTxt;
    }
}

