/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.line;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.cytoscape.cg.internal.charts.AbstractChart;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.charts.line.LineLayer;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;

public class LineChart
extends AbstractChart<LineLayer> {
    public static final String FACTORY_ID = "org.cytoscape.LineChart";
    public static final String DISPLAY_NAME = "Line Chart";
    public static final String LINE_WIDTH = "cy_lineWidth";
    public static ImageIcon ICON;

    public LineChart(Map<String, Object> properties, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, properties, serviceRegistrar);
    }

    public LineChart(LineChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, serviceRegistrar);
    }

    public LineChart(String input, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, input, serviceRegistrar);
    }

    public Image getRenderedImage() {
        return ICON.getImage();
    }

    @Override
    public Class<?> getSettingType(String key) {
        if (key.equalsIgnoreCase(LINE_WIDTH)) {
            return Float.class;
        }
        return super.getSettingType(key);
    }

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    protected LineLayer getLayer(CyRow row) {
        List<String> itemLabels = this.getItemLabels(row);
        List<String> domainLabels = this.getLabelsFromColumn(row, this.get("cy_domainLabelsColumn", CyColumnIdentifier.class));
        List<String> rangeLabels = this.getLabelsFromColumn(row, this.get("cy_rangeLabelsColumn", CyColumnIdentifier.class));
        Boolean global = this.get("cy_globalRange", Boolean.class, true);
        List<Double> range = global != false ? this.getList("cy_range", Double.class) : null;
        Map<String, List<Double>> data = this.getData(row);
        if (domainLabels.isEmpty() && data.size() == 1) {
            domainLabels = this.getSingleValueColumnNames(row);
        }
        List<Color> colors = this.getColors(data);
        Boolean showItemLabels = this.get("cy_showItemLabels", Boolean.class, false);
        Boolean showDomainAxis = this.get("cy_showDomainAxis", Boolean.class, false);
        Boolean showRangeAxis = this.get("cy_showRangeAxis", Boolean.class, false);
        Boolean showRangeZeroBaseline = this.get("cy_showRangeZeroBaseline", Boolean.class, false);
        LabelPosition domainLabelPosition = this.get("cy_domainLabelPosition", LabelPosition.class);
        Float axisWidth = this.get("cy_axisWidth", Float.class, Float.valueOf(0.25f));
        Color axisColor = this.get("cy_axisColor", Color.class, Color.DARK_GRAY);
        float axisFontSize = LineChart.convertFontSize(this.get("cy_axisLabelFontSize", Integer.class, 1));
        float itemFontSize = LineChart.convertFontSize(this.get("cy_itemLabelFontSize", Integer.class, 1));
        Float lineWidth = this.get(LINE_WIDTH, Float.class, Float.valueOf(1.0f));
        LineLayer layer = new LineLayer(data, itemLabels, domainLabels, rangeLabels, (boolean)showItemLabels, (boolean)showDomainAxis, (boolean)showRangeAxis, showRangeZeroBaseline, itemFontSize, domainLabelPosition, colors, axisWidth.floatValue(), axisColor, axisFontSize, range, lineWidth.floatValue());
        return layer;
    }

    static {
        try {
            ICON = new ImageIcon(ImageIO.read(LineChart.class.getClassLoader().getResource("images/charts/line-chart.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

