/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.box;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.cytoscape.cg.internal.charts.AbstractChart;
import org.cytoscape.cg.internal.charts.box.BoxLayer;
import org.cytoscape.cg.model.Orientation;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;

public class BoxChart
extends AbstractChart<BoxLayer> {
    public static final String FACTORY_ID = "org.cytoscape.BoxChart";
    public static final String DISPLAY_NAME = "Box Chart";
    public static ImageIcon ICON;

    public BoxChart(Map<String, Object> properties, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, properties, serviceRegistrar);
    }

    public BoxChart(BoxChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, serviceRegistrar);
    }

    public BoxChart(String input, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, input, serviceRegistrar);
    }

    public Image getRenderedImage() {
        return ICON.getImage();
    }

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    protected BoxLayer getLayer(CyRow row) {
        Boolean global = this.get("cy_globalRange", Boolean.class, true);
        List<Double> range = global != false ? this.getList("cy_range", Double.class) : null;
        Map<String, List<Double>> data = this.getData(row);
        List<Color> colors = this.getColors(data);
        Orientation orientation = this.get("cy_orientation", Orientation.class);
        Boolean showRangeAxis = this.get("cy_showRangeAxis", Boolean.class, false);
        Boolean showRangeZeroBaseline = this.get("cy_showRangeZeroBaseline", Boolean.class, false);
        Float axisWidth = this.get("cy_axisWidth", Float.class, Float.valueOf(0.25f));
        Color axisColor = this.get("cy_axisColor", Color.class, Color.DARK_GRAY);
        float axisFontSize = BoxChart.convertFontSize(this.get("cy_axisLabelFontSize", Integer.class, 1));
        Float borderWidth = this.get("cy_borderWidth", Float.class, Float.valueOf(0.25f));
        Color borderColor = this.get("cy_borderColor", Color.class, Color.DARK_GRAY);
        BoxLayer layer = new BoxLayer(data, showRangeAxis, showRangeZeroBaseline, colors, axisWidth.floatValue(), axisColor, axisFontSize, borderWidth.floatValue(), borderColor, range, orientation);
        return layer;
    }

    static {
        try {
            ICON = new ImageIcon(ImageIO.read(BoxChart.class.getClassLoader().getResource("images/charts/box-chart.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

