/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.bar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.charts.AbstractChartLayer;
import org.cytoscape.cg.internal.charts.CustomCategoryItemLabelGenerator;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.charts.bar.BarChart;
import org.cytoscape.cg.internal.charts.util.ColorScale;
import org.cytoscape.cg.internal.util.EqualDashStroke;
import org.cytoscape.cg.model.Orientation;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class BarLayer
extends AbstractChartLayer<CategoryDataset> {
    private final BarChart.BarChartType type;
    private final boolean showRangeZeroBaseline;
    private final double separation;
    private final Orientation orientation;
    private final boolean singleCategory;

    public BarLayer(Map<String, List<Double>> data, BarChart.BarChartType type, List<String> itemLabels, List<String> domainLabels, List<String> rangeLabels, boolean showItemLabels, boolean showDomainAxis, boolean showRangeAxis, boolean showRangeZeroBaseline, float itemFontSize, LabelPosition domainLabelPosition, List<Color> colors, float axisWidth, Color axisColor, float axisFontSize, float borderWidth, Color borderColor, double separation, List<Double> range, Orientation orientation) {
        super(data, itemLabels, domainLabels, rangeLabels, showItemLabels, showDomainAxis, showRangeAxis, itemFontSize, domainLabelPosition, colors, axisWidth, axisColor, axisFontSize, borderWidth, borderColor, range);
        this.type = type;
        this.showRangeZeroBaseline = showRangeZeroBaseline;
        this.separation = separation;
        this.orientation = orientation;
        boolean bl = this.singleCategory = data.size() == 1;
        if (type == BarChart.BarChartType.HEAT_STRIPS && (this.range == null || this.range.size() < 2 || this.range.get(0) == null || this.range.get(1) == null)) {
            this.range = BarLayer.calculateRange(data.values(), false);
        }
    }

    @Override
    protected CategoryDataset createDataset() {
        boolean listIsSeries = this.singleCategory && this.type != BarChart.BarChartType.STACKED;
        return BarLayer.createCategoryDataset(this.data, listIsSeries, this.domainLabels);
    }

    @Override
    protected JFreeChart createChart(CategoryDataset dataset) {
        int colCount;
        PlotOrientation plotOrientation = this.orientation == null || this.orientation == Orientation.AUTO ? ((colCount = dataset.getColumnCount()) > 1 ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL) : (this.orientation == Orientation.HORIZONTAL ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL);
        JFreeChart chart = this.type == BarChart.BarChartType.STACKED ? ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)false, (boolean)false, (boolean)false) : ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)false, (boolean)false, (boolean)false);
        chart.setAntiAlias(true);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        chart.setBackgroundImageAlpha(0.0f);
        chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setOutlineVisible(false);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setAxisOffset(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setBackgroundAlpha(0.0f);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        if (this.showRangeZeroBaseline) {
            plot.setRangeZeroBaselineVisible(true);
            plot.setRangeZeroBaselinePaint((Paint)this.axisColor);
            plot.setRangeZeroBaselineStroke((Stroke)new EqualDashStroke(this.axisWidth));
        }
        BasicStroke axisStroke = new BasicStroke(this.axisWidth, 1, 1);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(this.showDomainAxis);
        domainAxis.setAxisLineStroke((Stroke)axisStroke);
        domainAxis.setAxisLinePaint((Paint)this.axisColor);
        domainAxis.setTickMarkStroke((Stroke)axisStroke);
        domainAxis.setTickMarkPaint((Paint)this.axisColor);
        domainAxis.setTickMarksVisible(true);
        domainAxis.setTickLabelsVisible(true);
        domainAxis.setTickLabelFont(domainAxis.getTickLabelFont().deriveFont(this.axisFontSize));
        domainAxis.setTickLabelPaint((Paint)this.axisColor);
        domainAxis.setCategoryLabelPositions(this.getCategoryLabelPosition());
        domainAxis.setCategoryMargin(this.type == BarChart.BarChartType.STACKED || this.singleCategory ? this.separation : 0.1);
        domainAxis.setLowerMargin(0.025);
        domainAxis.setUpperMargin(0.025);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setVisible(this.showRangeAxis);
        rangeAxis.setAxisLineStroke((Stroke)axisStroke);
        rangeAxis.setAxisLinePaint((Paint)this.axisColor);
        rangeAxis.setTickMarkStroke((Stroke)axisStroke);
        rangeAxis.setTickMarkPaint((Paint)this.axisColor);
        rangeAxis.setTickLabelFont(rangeAxis.getLabelFont().deriveFont(this.axisFontSize).deriveFont(0));
        rangeAxis.setTickLabelPaint((Paint)this.axisColor);
        rangeAxis.setLowerMargin(0.1);
        rangeAxis.setUpperMargin(0.1);
        if (this.range != null && this.range.size() >= 2 && this.range.get(0) != null && this.range.get(1) != null) {
            rangeAxis.setLowerBound(((Double)this.range.get(0)).doubleValue());
            rangeAxis.setUpperBound(((Double)this.range.get(1)).doubleValue());
        }
        if (this.type != BarChart.BarChartType.STACKED) {
            if (this.type == BarChart.BarChartType.HEAT_STRIPS || this.type == BarChart.BarChartType.UP_DOWN) {
                Color zero;
                Color up = this.colors.size() > 0 ? (Color)this.colors.get(0) : Color.LIGHT_GRAY;
                Color color = zero = this.colors.size() > 2 ? (Color)this.colors.get(1) : Color.BLACK;
                Color down = this.colors.size() > 2 ? (Color)this.colors.get(2) : (this.colors.size() > 1 ? (Color)this.colors.get(1) : Color.GRAY);
                plot.setRenderer((CategoryItemRenderer)new UpDownColorBarRenderer(up, zero, down));
            } else if (this.singleCategory) {
                plot.setRenderer((CategoryItemRenderer)new SingleCategoryRenderer());
            }
        }
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setShadowVisible(false);
        renderer.setDrawBarOutline(true);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)(this.showItemLabels ? new CustomCategoryItemLabelGenerator(this.itemLabels) : null));
        renderer.setBaseItemLabelsVisible(this.showItemLabels);
        renderer.setBaseItemLabelFont(renderer.getBaseItemLabelFont().deriveFont(this.itemFontSize));
        renderer.setBaseItemLabelPaint((Paint)this.labelColor);
        renderer.setItemMargin(this.separation);
        if (this.type != BarChart.BarChartType.STACKED && this.showItemLabels) {
            double angle = this.orientation == Orientation.HORIZONTAL ? 0.0 : -1.5707963267948966;
            renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, angle));
            renderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, angle));
        }
        BasicStroke borderStroke = new BasicStroke(this.borderWidth, 1, 1);
        List keys = dataset.getRowKeys();
        for (int i = 0; i < keys.size(); ++i) {
            renderer.setSeriesOutlineStroke(i, (Stroke)borderStroke);
            renderer.setSeriesOutlinePaint(i, (Paint)(this.borderWidth > 0.0f ? this.borderColor : TRANSPARENT_COLOR));
            if (this.type == BarChart.BarChartType.UP_DOWN || this.type == BarChart.BarChartType.HEAT_STRIPS) continue;
            Color c = DEFAULT_ITEM_BG_COLOR;
            if (this.colors != null && this.colors.size() > i) {
                c = (Color)this.colors.get(i);
            }
            renderer.setSeriesPaint(i, (Paint)c);
        }
        return chart;
    }

    class UpDownColorBarRenderer
    extends BarRenderer {
        private Color upColor;
        private Color zeroColor;
        private Color downColor;

        UpDownColorBarRenderer(Color up, Color zero, Color down) {
            this.upColor = up;
            this.zeroColor = zero;
            this.downColor = down;
        }

        public Paint getItemPaint(int row, int column) {
            CategoryDataset dataset = this.getPlot().getDataset();
            String rowKey = (String)((Object)dataset.getRowKey(row));
            String colKey = (String)((Object)dataset.getColumnKey(column));
            double value = dataset.getValue((Comparable)((Object)rowKey), (Comparable)((Object)colKey)).doubleValue();
            if (BarLayer.this.type == BarChart.BarChartType.HEAT_STRIPS) {
                if (Double.isNaN(value)) {
                    return this.zeroColor;
                }
                return ColorScale.getPaint(value, (Double)BarLayer.this.range.get(0), (Double)BarLayer.this.range.get(1), this.downColor, this.zeroColor, this.upColor);
            }
            return value < 0.0 ? this.downColor : this.upColor;
        }
    }

    class SingleCategoryRenderer
    extends BarRenderer {
        SingleCategoryRenderer() {
        }

        public Paint getItemPaint(int row, int column) {
            return BarLayer.this.colors != null && BarLayer.this.colors.size() > column ? (Paint)BarLayer.this.colors.get(column) : AbstractChartLayer.DEFAULT_ITEM_BG_COLOR;
        }
    }
}

