/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.bar;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.cytoscape.cg.internal.charts.AbstractChart;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.charts.bar.BarChartTypeJsonDeserializer;
import org.cytoscape.cg.internal.charts.bar.BarLayer;
import org.cytoscape.cg.model.Orientation;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;

public class BarChart
extends AbstractChart<BarLayer> {
    public static final String FACTORY_ID = "org.cytoscape.BarChart";
    public static final String DISPLAY_NAME = "Bar Chart";
    public static final String TYPE = "cy_type";
    public static final String SEPARATION = "cy_separation";
    public static final double MAX_SEPARATION = 0.5;
    public static ImageIcon ICON;

    public BarChart(Map<String, Object> properties, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, properties, serviceRegistrar);
    }

    public BarChart(BarChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, serviceRegistrar);
    }

    public BarChart(String input, CyServiceRegistrar serviceRegistrar) {
        super(DISPLAY_NAME, input, serviceRegistrar);
    }

    public Image getRenderedImage() {
        return ICON.getImage();
    }

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    public Class<?> getSettingType(String key) {
        if (key.equalsIgnoreCase(TYPE)) {
            return BarChartType.class;
        }
        if (key.equalsIgnoreCase(SEPARATION)) {
            return Double.class;
        }
        return super.getSettingType(key);
    }

    @Override
    public void addJsonDeserializers(SimpleModule module) {
        super.addJsonDeserializers(module);
        module.addDeserializer(BarChartType.class, (JsonDeserializer)new BarChartTypeJsonDeserializer());
    }

    @Override
    protected BarLayer getLayer(CyRow row) {
        List<String> itemLabels = this.getItemLabels(row);
        List<String> domainLabels = this.getLabelsFromColumn(row, this.get("cy_domainLabelsColumn", CyColumnIdentifier.class));
        List<String> rangeLabels = this.getLabelsFromColumn(row, this.get("cy_rangeLabelsColumn", CyColumnIdentifier.class));
        Boolean global = this.get("cy_globalRange", Boolean.class, true);
        List<Double> range = global != false ? this.getList("cy_range", Double.class) : null;
        BarChartType type = this.get(TYPE, BarChartType.class, BarChartType.GROUPED);
        Map<String, List<Double>> data = this.getData(row);
        if (domainLabels.isEmpty() && data.size() == 1 && type != BarChartType.STACKED) {
            domainLabels = this.getSingleValueColumnNames(row);
        }
        List<Color> colors = this.getColors(data);
        Orientation orientation = this.get("cy_orientation", Orientation.class);
        Boolean showLabels = this.get("cy_showItemLabels", Boolean.class, false);
        Boolean showDomainAxis = this.get("cy_showDomainAxis", Boolean.class, false);
        Boolean showRangeAxis = this.get("cy_showRangeAxis", Boolean.class, false);
        Boolean showRangeZeroBaseline = this.get("cy_showRangeZeroBaseline", Boolean.class, false);
        LabelPosition domainLabelPosition = this.get("cy_domainLabelPosition", LabelPosition.class);
        Float axisWidth = this.get("cy_axisWidth", Float.class, Float.valueOf(0.25f));
        Color axisColor = this.get("cy_axisColor", Color.class, Color.DARK_GRAY);
        float axisFontSize = BarChart.convertFontSize(this.get("cy_axisLabelFontSize", Integer.class, 1));
        float itemFontSize = BarChart.convertFontSize(this.get("cy_itemLabelFontSize", Integer.class, 1));
        Float borderWidth = this.get("cy_borderWidth", Float.class, Float.valueOf(0.25f));
        Color borderColor = this.get("cy_borderColor", Color.class, Color.DARK_GRAY);
        Double separation = this.get(SEPARATION, Double.class, 0.0);
        separation = separation > 0.5 ? 0.5 : (separation < 0.0 ? 0.0 : separation);
        BarLayer layer = new BarLayer(data, type, itemLabels, domainLabels, rangeLabels, showLabels, showDomainAxis, showRangeAxis, showRangeZeroBaseline, itemFontSize, domainLabelPosition, colors, axisWidth.floatValue(), axisColor, axisFontSize, borderWidth.floatValue(), borderColor, separation, range, orientation);
        return layer;
    }

    static {
        try {
            ICON = new ImageIcon(ImageIO.read(BarChart.class.getClassLoader().getResource("images/charts/bar-chart.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum BarChartType {
        GROUPED,
        STACKED,
        HEAT_STRIPS,
        UP_DOWN;

    }
}

