/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.cg.internal.util.ColorUtil;
import org.cytoscape.cg.internal.util.IconUtil;
import org.cytoscape.cg.model.AbstractCustomGraphics2;
import org.cytoscape.cg.model.ColorScheme;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteProviderManager;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;

public class ColorSchemeEditor<T extends AbstractCustomGraphics2<?>>
extends JPanel {
    private static final Color DEFAULT_COLOR = Color.LIGHT_GRAY;
    private final Border COLOR_BORDER;
    private final Border COLOR_HOVER_BORDER;
    private JLabel colorSchemeLbl;
    private JButton colorPaletteBtn;
    private JPanel colorListPnl;
    private Palette palette;
    private PaletteType paletteType;
    private String defaultPaletteName;
    private ColorScheme defaultColorScheme;
    protected final T chart;
    protected final boolean columnIsSeries;
    protected final CyNetwork network;
    protected final CyServiceRegistrar serviceRegistrar;
    protected int total = 0;

    public ColorSchemeEditor(T chart, boolean columnIsSeries, PaletteType paletteType, String defaultPaletteName, CyNetwork network, CyServiceRegistrar serviceRegistrar) {
        this.chart = chart;
        this.columnIsSeries = columnIsSeries;
        this.network = network;
        this.serviceRegistrar = serviceRegistrar;
        this.setPaletteType(paletteType);
        this.setDefaultPaletteName(defaultPaletteName);
        List<Color> colors = ((AbstractCustomGraphics2)chart).getList("cy_colors", Color.class);
        this.palette = colors.isEmpty() ? this.getDefaultPalette() : null;
        this.COLOR_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("TextField.background"), 2), BorderFactory.createLineBorder(UIManager.getColor("TextField.inactiveForeground"), 1));
        this.COLOR_HOVER_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Focus.color"), 2), BorderFactory.createLineBorder(UIManager.getColor("TextField.background"), 1));
        this.init();
        this.updateColorList(colors.isEmpty());
        this.updateColorPaletteBtn();
    }

    public void setPaletteType(PaletteType paletteType) {
        if (paletteType == null) {
            throw new IllegalArgumentException("'paletteType' must not be null.");
        }
        if (this.paletteType != paletteType) {
            this.paletteType = paletteType;
            if (this.palette != null && !paletteType.equals(this.palette.getType())) {
                this.palette = null;
            }
        }
    }

    public void setDefaultPaletteName(String defaultPaletteName) {
        if (defaultPaletteName == null) {
            throw new IllegalArgumentException("'defaultPaletteName' must not be null.");
        }
        this.defaultPaletteName = defaultPaletteName;
    }

    public void reset(boolean resetColorScheme) {
        if (resetColorScheme) {
            this.defaultColorScheme = null;
            this.palette = this.getDefaultPalette();
            ((AbstractCustomGraphics2)this.chart).set("cy_colorScheme", this.getDefaultColorScheme());
        }
        this.total = 0;
        this.updateColorList(true);
        this.updateColorPaletteBtn();
    }

    private void init() {
        this.colorSchemeLbl = new JLabel("Color Palette:");
        this.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        JSeparator sep = new JSeparator();
        JScrollPane colorListScr = new JScrollPane(this.getColorListPnl(), 21, 30);
        colorListScr.setPreferredSize(new Dimension(160, 50));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.colorSchemeLbl).addComponent(this.getColorPaletteBtn(), -2, -1, -2)).addComponent(colorListScr).addComponent(sep));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.colorSchemeLbl).addComponent(this.getColorPaletteBtn())).addComponent(colorListScr, -2, -1, -2).addComponent(sep, -2, -1, -2));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getColorPaletteBtn()});
    }

    protected JButton getColorPaletteBtn() {
        if (this.colorPaletteBtn == null) {
            this.colorPaletteBtn = new JButton();
            this.colorPaletteBtn.addActionListener(evt -> {
                CyColorPaletteChooserFactory chooserFactory = (CyColorPaletteChooserFactory)this.serviceRegistrar.getService(CyColorPaletteChooserFactory.class);
                CyColorPaletteChooser chooser = chooserFactory.getColorPaletteChooser(this.paletteType, true);
                String title = "Palettes";
                int size = this.getPaletteSize();
                Palette newPalette = chooser.showDialog((Component)this, title, this.palette, size = Math.min(Math.max(size, 2), 12));
                if (newPalette != null) {
                    this.palette = newPalette;
                    ColorScheme newScheme = new ColorScheme(this.palette);
                    ((AbstractCustomGraphics2)this.chart).set("cy_colorScheme", newScheme);
                    this.updateColorList(true);
                    this.updateColorPaletteBtn();
                }
            });
        }
        return this.colorPaletteBtn;
    }

    protected JPanel getColorListPnl() {
        if (this.colorListPnl == null) {
            this.colorListPnl = new JPanel();
            this.colorListPnl.setOpaque(false);
            this.colorListPnl.setLayout(new BoxLayout(this.colorListPnl, 0));
        }
        return this.colorListPnl;
    }

    private Palette getDefaultPalette() {
        ColorScheme scheme = this.getDefaultColorScheme();
        return scheme != null ? scheme.getPalette() : null;
    }

    protected ColorScheme getDefaultColorScheme() {
        if (this.defaultColorScheme == null) {
            PaletteProviderManager ppManager = (PaletteProviderManager)this.serviceRegistrar.getService(PaletteProviderManager.class);
            List providers = ppManager.getPaletteProviders();
            for (PaletteProvider pp : providers) {
                Palette p = pp.getPalette(this.defaultPaletteName);
                if (p == null) continue;
                this.defaultColorScheme = new ColorScheme(p);
                break;
            }
            if (this.defaultColorScheme == null) {
                this.defaultColorScheme = ColorScheme.CONTRASTING;
            }
        }
        return this.defaultColorScheme;
    }

    private void updateColorPaletteBtn() {
        this.getColorPaletteBtn().setText(this.palette != null ? this.palette.getName() : "None");
    }

    protected void updateColorList(boolean isNewScheme) {
        List<Color> colors = new ArrayList<Color>(((AbstractCustomGraphics2)this.chart).getList("cy_colors", Color.class));
        ColorScheme scheme = ((AbstractCustomGraphics2)this.chart).get("cy_colorScheme", ColorScheme.class);
        if (scheme != null) {
            this.palette = scheme.getPalette();
        } else if (colors.isEmpty()) {
            this.palette = this.getDefaultPalette();
            scheme = this.getDefaultColorScheme();
            ((AbstractCustomGraphics2)this.chart).set("cy_colorScheme", scheme);
        }
        this.updateColorPaletteBtn();
        int nColors = this.getTotal();
        int paletteSize = this.getPaletteSize();
        if (nColors > 0) {
            List<Color> newColors;
            if (isNewScheme || colors.isEmpty()) {
                if (ColorScheme.CUSTOM.equals(scheme)) {
                    int newSize = Math.max(colors.size(), nColors);
                    colors = new ArrayList(newSize);
                    for (i = 0; i < newSize; ++i) {
                        colors.add(i % 2 == 0 ? DEFAULT_COLOR : DEFAULT_COLOR.darker());
                    }
                } else {
                    int missing;
                    if (scheme != null) {
                        colors = scheme.getColors(paletteSize);
                    }
                    if ((missing = nColors - paletteSize) > 0) {
                        colors = new ArrayList<Color>(colors);
                        for (i = 0; i < missing; ++i) {
                            colors.add(Color.GRAY);
                        }
                    }
                }
            } else if (scheme != null && colors.size() < nColors && (newColors = scheme.getColors(nColors)).size() > colors.size()) {
                colors.addAll(newColors.subList(colors.size(), newColors.size()));
            }
        }
        this.getColorListPnl().removeAll();
        for (int i = 0; i < this.total; ++i) {
            Color c = colors.size() > i ? colors.get(i) : Color.GRAY;
            ColorPanel cp = new ColorPanel(c, "");
            this.style(cp, i);
            this.getColorListPnl().add(cp);
        }
        this.getColorListPnl().repaint();
        if (!colors.isEmpty()) {
            ((AbstractCustomGraphics2)this.chart).set("cy_colors", colors);
        }
    }

    protected void style(ColorPanel cp, int index) {
        String label = "" + (index + 1);
        cp.setText(label);
    }

    protected int getPaletteSize() {
        return this.getTotal();
    }

    protected int getTotal() {
        if (this.total <= 0) {
            List<CyColumnIdentifier> dataColumns = ((AbstractCustomGraphics2)this.chart).getList("cy_dataColumns", CyColumnIdentifier.class);
            if (this.columnIsSeries) {
                this.total = dataColumns.size();
            } else if (this.network != null) {
                int nColors1 = 0;
                int nColors2 = 0;
                List allNodes = this.network.getNodeList();
                CyTable table = this.network.getDefaultNodeTable();
                for (CyColumnIdentifier colId : dataColumns) {
                    CyColumn column = table.getColumn(colId.getColumnName());
                    if (column == null) continue;
                    if (column.getType() == List.class) {
                        for (CyNode node : allNodes) {
                            CyRow row = this.network.getRow((CyIdentifiable)node);
                            List values = row.getList(column.getName(), column.getListElementType());
                            if (values == null) continue;
                            nColors1 = Math.max(nColors1, values.size());
                        }
                        continue;
                    }
                    ++nColors2;
                }
                this.total = Math.max(nColors1, nColors2);
            }
        }
        return this.total;
    }

    protected class ColorPanel
    extends JLabel {
        private Color color;

        ColorPanel(Color color, String label) {
            super(label, IconUtil.emptyIcon(20, 20), 0);
            if (color == null) {
                color = Color.LIGHT_GRAY;
            }
            this.color = color;
            this.setFont(this.getFont().deriveFont(10.0f));
            this.setHorizontalTextPosition(0);
            this.setOpaque(true);
            this.setBackground(color);
            this.setForeground(ColorUtil.getContrastingColor(color));
            this.setBorder(ColorSchemeEditor.this.COLOR_BORDER);
            this.setToolTipText(String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ColorPanel.this.chooseColor();
                    ColorPanel.this.onColorUpdated();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ColorPanel.this.setBorder(ColorSchemeEditor.this.COLOR_HOVER_BORDER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ColorPanel.this.setBorder(ColorSchemeEditor.this.COLOR_BORDER);
                }
            });
        }

        public Color getColor() {
            return this.color;
        }

        private void chooseColor() {
            Color newColor;
            CyColorPaletteChooserFactory chooserFactory = (CyColorPaletteChooserFactory)ColorSchemeEditor.this.serviceRegistrar.getService(CyColorPaletteChooserFactory.class);
            CyColorPaletteChooser chooser = chooserFactory.getColorPaletteChooser((PaletteType)BrewerType.ANY, false);
            int size = ColorSchemeEditor.this.getPaletteSize();
            if (size < 2) {
                size = 5;
            }
            if ((newColor = chooser.showDialog((Component)this, "Colors", ColorSchemeEditor.this.palette, this.color, size)) != null) {
                List<Color> pColors;
                this.color = newColor;
                this.setBackground(newColor);
                this.setForeground(ColorUtil.getContrastingColor(newColor));
                if (ColorSchemeEditor.this.palette != null && !(pColors = Arrays.asList(ColorSchemeEditor.this.palette.getColors())).contains(newColor)) {
                    ColorSchemeEditor.this.palette = null;
                    ColorSchemeEditor.this.updateColorPaletteBtn();
                }
            }
        }

        private void onColorUpdated() {
            Component[] rows = ColorSchemeEditor.this.getColorListPnl().getComponents();
            ArrayList<Color> newColors = new ArrayList<Color>();
            if (rows != null) {
                for (Component c : rows) {
                    if (!(c instanceof ColorPanel)) continue;
                    Color color = ((ColorPanel)c).getColor();
                    newColors.add(color);
                }
            }
            ((AbstractCustomGraphics2)ColorSchemeEditor.this.chart).set("cy_colors", newColors);
            if (ColorSchemeEditor.this.palette == null) {
                ((AbstractCustomGraphics2)ColorSchemeEditor.this.chart).set("cy_colorScheme", null);
            }
        }
    }
}

