/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.json.CyColumnIdentifierJsonDeserializer;
import org.cytoscape.cg.internal.json.CyColumnIdentifierJsonSerializer;
import org.cytoscape.cg.model.AbstractCustomGraphics2;
import org.cytoscape.cg.model.ColorScheme;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifierFactory;
import org.cytoscape.view.presentation.property.values.MappableVisualPropertyValue;

public abstract class AbstractChart<T extends CustomGraphicLayer>
extends AbstractCustomGraphics2<T>
implements MappableVisualPropertyValue {
    public static final String DATA_COLUMNS = "cy_dataColumns";
    public static final String ITEM_LABELS_COLUMN = "cy_itemLabelsColumn";
    public static final String ITEM_LABELS = "cy_itemLabels";
    public static final String ITEM_LABEL_FONT_SIZE = "cy_itemLabelFontSize";
    public static final String DOMAIN_LABELS_COLUMN = "cy_domainLabelsColumn";
    public static final String RANGE_LABELS_COLUMN = "cy_rangeLabelsColumn";
    public static final String DOMAIN_LABEL_POSITION = "cy_domainLabelPosition";
    public static final String AXIS_LABEL_FONT_SIZE = "cy_axisLabelFontSize";
    public static final String GLOBAL_RANGE = "cy_globalRange";
    public static final String AUTO_RANGE = "cy_autoRange";
    public static final String RANGE = "cy_range";
    public static final String SHOW_ITEM_LABELS = "cy_showItemLabels";
    public static final String SHOW_DOMAIN_AXIS = "cy_showDomainAxis";
    public static final String SHOW_RANGE_AXIS = "cy_showRangeAxis";
    public static final String SHOW_RANGE_ZERO_BASELINE = "cy_showRangeZeroBaseline";
    public static final String AXIS_WIDTH = "cy_axisWidth";
    public static final String AXIS_COLOR = "cy_axisColor";
    public static final String VALUES = "cy_values";
    public static final String BORDER_WIDTH = "cy_borderWidth";
    public static final String BORDER_COLOR = "cy_borderColor";
    protected final CyServiceRegistrar serviceRegistrar;

    protected AbstractChart(String displayName, CyServiceRegistrar serviceRegistrar) {
        super(displayName);
        if (serviceRegistrar == null) {
            throw new IllegalArgumentException("'serviceRegistrar' must not be null.");
        }
        this.serviceRegistrar = serviceRegistrar;
    }

    protected AbstractChart(String displayName, String input, CyServiceRegistrar serviceRegistrar) {
        this(displayName, serviceRegistrar);
        this.addProperties(this.parseInput(input));
    }

    protected AbstractChart(AbstractChart<T> chart, CyServiceRegistrar serviceRegistrar) {
        this(chart.getDisplayName(), serviceRegistrar);
        this.addProperties(chart.getProperties());
    }

    protected AbstractChart(String displayName, Map<String, Object> properties, CyServiceRegistrar serviceRegistrar) {
        this(displayName, serviceRegistrar);
        this.addProperties(properties);
    }

    public List<T> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> view) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        CyIdentifiable model = (CyIdentifiable)view.getModel();
        CyRow row = network.getRow(model);
        return Collections.singletonList(this.getLayer(row));
    }

    public List<T> getLayers(CyTableView tableView, CyColumnView columnView, CyRow row) {
        return Collections.singletonList(this.getLayer(row));
    }

    protected abstract T getLayer(CyRow var1);

    public Set<CyColumnIdentifier> getMappedColumns() {
        HashSet<CyColumnIdentifier> set = new HashSet<CyColumnIdentifier>();
        set.addAll(this.getList(DATA_COLUMNS, CyColumnIdentifier.class));
        if (this.get(SHOW_ITEM_LABELS, Boolean.class, Boolean.FALSE).booleanValue()) {
            set.addAll(this.getList(ITEM_LABELS_COLUMN, CyColumnIdentifier.class));
        }
        if (this.get(SHOW_DOMAIN_AXIS, Boolean.class, Boolean.FALSE).booleanValue() && this.get(DOMAIN_LABELS_COLUMN, CyColumnIdentifier.class) != null) {
            set.add(this.get(DOMAIN_LABELS_COLUMN, CyColumnIdentifier.class));
        }
        if (this.get(SHOW_RANGE_AXIS, Boolean.class, Boolean.FALSE).booleanValue() && this.get(RANGE_LABELS_COLUMN, CyColumnIdentifier.class) != null) {
            set.add(this.get(RANGE_LABELS_COLUMN, CyColumnIdentifier.class));
        }
        return set;
    }

    public String getSerializableString() {
        return this.toSerializableString();
    }

    public void update() {
    }

    public Map<String, List<Double>> getDataFromColumns(CyRow row, List<CyColumnIdentifier> columnNames) {
        LinkedHashMap<String, List<Double>> data = new LinkedHashMap<String, List<Double>>();
        if (row == null) {
            return data;
        }
        CyTable table = row.getTable();
        ArrayList<Double> singleSeriesValues = new ArrayList<Double>();
        StringBuilder singleSeriesKey = new StringBuilder();
        int singleSeriesIndex = -1;
        int count = 0;
        for (CyColumnIdentifier colId : columnNames) {
            CyColumn column = table.getColumn(colId.getColumnName());
            if (column == null) continue;
            String colName = column.getName();
            ArrayList<Double> values = new ArrayList<Double>();
            if (column.getType() == List.class) {
                List list;
                type = column.getListElementType();
                if (type == Double.class) {
                    list = row.getList(colName, Double.class);
                    if (list != null) {
                        values.addAll(list);
                    }
                } else if (type == Integer.class) {
                    list = row.getList(colName, Integer.class);
                    if (list != null) {
                        for (Integer i : list) {
                            values.add(i.doubleValue());
                        }
                    }
                } else if (type == Long.class) {
                    list = row.getList(colName, Long.class);
                    if (list != null) {
                        for (Long l : list) {
                            values.add(l.doubleValue());
                        }
                    }
                } else if (type == Float.class && (list = row.getList(colName, Float.class)) != null) {
                    for (Float f : list) {
                        values.add(f.doubleValue());
                    }
                }
                data.put(colName, values);
            } else {
                type = column.getType();
                if (Number.class.isAssignableFrom(type)) {
                    if (!row.isSet(colName)) {
                        singleSeriesValues.add(Double.NaN);
                    } else if (type == Double.class) {
                        singleSeriesValues.add((Double)row.get(colName, Double.class));
                    } else if (type == Integer.class) {
                        Integer i = (Integer)row.get(colName, Integer.class);
                        singleSeriesValues.add(i == null ? Double.NaN : i.doubleValue());
                    } else if (type == Float.class) {
                        Float f = (Float)row.get(colName, Float.class);
                        singleSeriesValues.add(f == null ? Double.NaN : f.doubleValue());
                    }
                    singleSeriesKey.append(colName + ",");
                    if (singleSeriesIndex == -1) {
                        singleSeriesIndex = count;
                    }
                }
            }
            ++count;
        }
        if (!singleSeriesValues.isEmpty()) {
            singleSeriesKey.deleteCharAt(singleSeriesKey.length() - 1);
            Set<Map.Entry<String, List<Double>>> entrySet = data.entrySet();
            data = new LinkedHashMap();
            int i = 0;
            for (Map.Entry<String, List<Double>> entry : entrySet) {
                if (i == singleSeriesIndex) {
                    data.put(singleSeriesKey.toString(), singleSeriesValues);
                }
                data.put(entry.getKey(), entry.getValue());
                ++i;
            }
            if (!data.containsKey(singleSeriesKey.toString())) {
                data.put(singleSeriesKey.toString(), singleSeriesValues);
            }
        }
        return data;
    }

    public List<String> getLabelsFromColumn(CyRow row, CyColumnIdentifier columnId) {
        CyTable table;
        CyColumn column;
        ArrayList<String> labels = new ArrayList<String>();
        if (row != null && columnId != null && (column = (table = row.getTable()).getColumn(columnId.getColumnName())) != null && column.getType() == List.class) {
            Class type = column.getListElementType();
            List values = row.getList(columnId.getColumnName(), type);
            if (type == String.class) {
                labels.addAll(values);
            } else {
                for (Object obj : values) {
                    labels.add(obj.toString());
                }
            }
        }
        return labels;
    }

    protected List<String> getSingleValueColumnNames(CyRow row) {
        ArrayList<String> names = new ArrayList<String>();
        if (row == null) {
            return names;
        }
        List<CyColumnIdentifier> dataColumns = this.getList(DATA_COLUMNS, CyColumnIdentifier.class);
        CyTable table = row.getTable();
        boolean invalid = false;
        for (CyColumnIdentifier colId : dataColumns) {
            CyColumn column = table.getColumn(colId.getColumnName());
            if (column == null || column.getType() == List.class) {
                invalid = true;
                break;
            }
            names.add(colId.getColumnName());
        }
        if (invalid) {
            names.clear();
        }
        return names;
    }

    protected Map<String, List<Double>> getData(CyRow row) {
        HashMap<String, List<Double>> data;
        List<Double> values = this.getList(VALUES, Double.class);
        if (values == null || values.isEmpty()) {
            List<CyColumnIdentifier> dataColumns = this.getList(DATA_COLUMNS, CyColumnIdentifier.class);
            data = this.getDataFromColumns(row, dataColumns);
        } else {
            data = new HashMap<String, List<Double>>();
            data.put("Values", values);
        }
        return data;
    }

    protected List<String> getItemLabels(CyRow row) {
        List<String> labels = this.getList(ITEM_LABELS, String.class);
        if (labels == null || labels.isEmpty()) {
            CyColumnIdentifier labelsColumn = this.get(ITEM_LABELS_COLUMN, CyColumnIdentifier.class);
            labels = this.getLabelsFromColumn(row, labelsColumn);
        }
        return labels;
    }

    protected List<Color> getColors(Map<String, List<Double>> data) {
        ColorScheme scheme;
        List<Color> colors = this.getList("cy_colors", Color.class);
        if ((colors == null || colors.isEmpty()) && (scheme = this.get("cy_colorScheme", ColorScheme.class)) != null && data != null && !data.isEmpty()) {
            int nColors = 0;
            for (List<Double> values : data.values()) {
                if (values == null) continue;
                nColors = Math.max(nColors, values.size());
            }
            colors = scheme.getColors(nColors);
        }
        return colors;
    }

    @Override
    public Class<?> getSettingType(String key) {
        if (key.equalsIgnoreCase(DATA_COLUMNS)) {
            return List.class;
        }
        if (key.equalsIgnoreCase(VALUES)) {
            return List.class;
        }
        if (key.equalsIgnoreCase(ITEM_LABELS_COLUMN)) {
            return CyColumnIdentifier.class;
        }
        if (key.equalsIgnoreCase(ITEM_LABELS)) {
            return List.class;
        }
        if (key.equalsIgnoreCase(ITEM_LABEL_FONT_SIZE)) {
            return Integer.class;
        }
        if (key.equalsIgnoreCase(DOMAIN_LABELS_COLUMN)) {
            return CyColumnIdentifier.class;
        }
        if (key.equalsIgnoreCase(RANGE_LABELS_COLUMN)) {
            return CyColumnIdentifier.class;
        }
        if (key.equalsIgnoreCase(SHOW_ITEM_LABELS)) {
            return Boolean.class;
        }
        if (key.equalsIgnoreCase(SHOW_RANGE_AXIS)) {
            return Boolean.class;
        }
        if (key.equalsIgnoreCase(SHOW_DOMAIN_AXIS)) {
            return Boolean.class;
        }
        if (key.equalsIgnoreCase(SHOW_RANGE_ZERO_BASELINE)) {
            return Boolean.class;
        }
        if (key.equalsIgnoreCase(DOMAIN_LABEL_POSITION)) {
            return LabelPosition.class;
        }
        if (key.equalsIgnoreCase(AXIS_LABEL_FONT_SIZE)) {
            return Integer.class;
        }
        if (key.equalsIgnoreCase(AXIS_WIDTH)) {
            return Float.class;
        }
        if (key.equalsIgnoreCase(AXIS_COLOR)) {
            return Color.class;
        }
        if (key.equalsIgnoreCase(GLOBAL_RANGE)) {
            return Boolean.class;
        }
        if (key.equalsIgnoreCase(AUTO_RANGE)) {
            return Boolean.class;
        }
        if (key.equalsIgnoreCase(RANGE)) {
            return List.class;
        }
        if (key.equalsIgnoreCase(BORDER_WIDTH)) {
            return Float.class;
        }
        if (key.equalsIgnoreCase(BORDER_COLOR)) {
            return Color.class;
        }
        return super.getSettingType(key);
    }

    @Override
    public Class<?> getSettingElementType(String key) {
        if (key.equalsIgnoreCase(DATA_COLUMNS)) {
            return CyColumnIdentifier.class;
        }
        if (key.equalsIgnoreCase(VALUES)) {
            return Double.class;
        }
        if (key.equalsIgnoreCase(ITEM_LABELS)) {
            return String.class;
        }
        if (key.equalsIgnoreCase(RANGE)) {
            return Double.class;
        }
        return super.getSettingElementType(key);
    }

    @Override
    protected void addJsonSerializers(SimpleModule module) {
        super.addJsonSerializers(module);
        module.addSerializer((JsonSerializer)new CyColumnIdentifierJsonSerializer());
    }

    @Override
    protected void addJsonDeserializers(SimpleModule module) {
        super.addJsonDeserializers(module);
        CyColumnIdentifierFactory colIdFactory = (CyColumnIdentifierFactory)this.serviceRegistrar.getService(CyColumnIdentifierFactory.class);
        module.addDeserializer(CyColumnIdentifier.class, (JsonDeserializer)new CyColumnIdentifierJsonDeserializer(colIdFactory));
    }

    protected static float convertFontSize(int size) {
        return (float)size * 2.0f;
    }
}

