/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.cg.internal.action.CustomGraphicsManagerAction;
import org.cytoscape.cg.internal.charts.AbstractChartFactory;
import org.cytoscape.cg.internal.charts.bar.BarChartFactory;
import org.cytoscape.cg.internal.charts.box.BoxChartFactory;
import org.cytoscape.cg.internal.charts.heatmap.HeatMapChartFactory;
import org.cytoscape.cg.internal.charts.line.LineChartFactory;
import org.cytoscape.cg.internal.charts.pie.PieChartFactory;
import org.cytoscape.cg.internal.charts.ring.RingChartFactory;
import org.cytoscape.cg.internal.editor.CustomGraphicsVisualPropertyEditor;
import org.cytoscape.cg.internal.editor.CyCustomGraphicsValueEditor;
import org.cytoscape.cg.internal.gradient.linear.LinearGradientFactory;
import org.cytoscape.cg.internal.gradient.radial.RadialGradientFactory;
import org.cytoscape.cg.internal.image.BitmapCustomGraphicsFactory;
import org.cytoscape.cg.internal.image.SVGCustomGraphicsFactory;
import org.cytoscape.cg.internal.model.CustomGraphics2ManagerImpl;
import org.cytoscape.cg.internal.model.CustomGraphicsManagerImpl;
import org.cytoscape.cg.internal.vector.GradientOvalFactory;
import org.cytoscape.cg.internal.vector.GradientRoundRectangleFactory;
import org.cytoscape.cg.model.ColorScheme;
import org.cytoscape.cg.model.CustomGraphics2Manager;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.CustomGraphicsRange;
import org.cytoscape.cg.model.CustomGraphicsTranslator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2Factory;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphicsFactory;
import org.cytoscape.view.vizmap.gui.editor.ContinuousMappingCellRendererFactory;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyEditor;
import org.cytoscape.view.vizmap.mappings.ValueTranslator;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    private CustomGraphicsManager cgManager;
    private CustomGraphics2Manager cg2Manager;

    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        this.startCustomGraphicsMgr(bc, serviceRegistrar);
        this.startCharts(bc, serviceRegistrar);
        this.startGradients(bc, serviceRegistrar);
        this.startPresentationImpl(bc, serviceRegistrar);
    }

    private void startCustomGraphicsMgr(BundleContext bc, CyServiceRegistrar serviceRegistrar) {
        ColorScheme.setServiceRegistrar(serviceRegistrar);
        this.cgManager = new CustomGraphicsManagerImpl(serviceRegistrar);
        this.registerAllServices(bc, this.cgManager);
        CustomGraphicsRange.setManager(this.cgManager);
        CustomGraphicsManagerAction cgManagerAction = new CustomGraphicsManagerAction(this.cgManager, serviceRegistrar);
        this.registerService(bc, (Object)cgManagerAction, CyAction.class);
        BitmapCustomGraphicsFactory bitmapFactory = new BitmapCustomGraphicsFactory(this.cgManager, serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("SUPPORTED_CLASS_ID", "org.cytoscape.ding.customgraphics.bitmap.URLImageCustomGraphics");
        this.cgManager.addCustomGraphicsFactory(bitmapFactory, props);
        SVGCustomGraphicsFactory vectorFactory = new SVGCustomGraphicsFactory(this.cgManager, serviceRegistrar);
        props = new Properties();
        props.setProperty("SUPPORTED_CLASS_ID", "org.cytoscape.ding.customgraphics.image.SVGCustomGraphics");
        this.cgManager.addCustomGraphicsFactory(vectorFactory, props);
        GradientOvalFactory ovalFactory = new GradientOvalFactory(this.cgManager);
        this.cgManager.addCustomGraphicsFactory(ovalFactory, new Properties());
        GradientRoundRectangleFactory rectangleFactory = new GradientRoundRectangleFactory(this.cgManager);
        this.cgManager.addCustomGraphicsFactory(rectangleFactory, new Properties());
        this.registerServiceListener(bc, this.cgManager::addCustomGraphicsFactory, this.cgManager::removeCustomGraphicsFactory, CyCustomGraphicsFactory.class);
        this.cg2Manager = CustomGraphics2ManagerImpl.getInstance();
        this.registerAllServices(bc, this.cg2Manager);
        this.registerServiceListener(bc, ((CustomGraphics2ManagerImpl)this.cg2Manager)::addFactory, ((CustomGraphics2ManagerImpl)this.cg2Manager)::removeFactory, CyCustomGraphics2Factory.class);
    }

    private void startCharts(BundleContext bc, CyServiceRegistrar serviceRegistrar) {
        Properties props = new Properties();
        props.setProperty("group", "Charts");
        AbstractChartFactory factory = new BarChartFactory(Arrays.asList(CyNode.class, CyColumn.class), serviceRegistrar);
        this.registerService(bc, factory, CyCustomGraphics2Factory.class, props);
        factory = new BoxChartFactory(Collections.singleton(CyNode.class), serviceRegistrar);
        this.registerService(bc, factory, CyCustomGraphics2Factory.class, props);
        factory = new PieChartFactory(Arrays.asList(CyNode.class, CyColumn.class), serviceRegistrar);
        this.registerService(bc, factory, CyCustomGraphics2Factory.class, props);
        factory = new RingChartFactory(Collections.singleton(CyNode.class), serviceRegistrar);
        this.registerService(bc, factory, CyCustomGraphics2Factory.class, props);
        factory = new LineChartFactory(Arrays.asList(CyNode.class, CyColumn.class), serviceRegistrar);
        this.registerService(bc, factory, CyCustomGraphics2Factory.class, props);
        factory = new HeatMapChartFactory(Collections.singleton(CyNode.class), serviceRegistrar);
        this.registerService(bc, factory, CyCustomGraphics2Factory.class, props);
    }

    private void startGradients(BundleContext bc, CyServiceRegistrar serviceRegistrar) {
        Properties props = new Properties();
        props.setProperty("group", "Gradients");
        Object factory = new LinearGradientFactory(serviceRegistrar);
        this.registerService(bc, factory, CyCustomGraphics2Factory.class, props);
        factory = new RadialGradientFactory(serviceRegistrar);
        this.registerService(bc, factory, CyCustomGraphics2Factory.class, props);
    }

    private void startPresentationImpl(BundleContext bc, CyServiceRegistrar serviceRegistrar) {
        CustomGraphicsTranslator cgTranslator = new CustomGraphicsTranslator(this.cgManager, this.cg2Manager);
        this.registerService(bc, cgTranslator, ValueTranslator.class);
        CyCustomGraphicsValueEditor cgValueEditor = new CyCustomGraphicsValueEditor(serviceRegistrar);
        this.registerAllServices(bc, cgValueEditor);
        ContinuousMappingCellRendererFactory cmCellRendererFactory = (ContinuousMappingCellRendererFactory)this.getService(bc, ContinuousMappingCellRendererFactory.class);
        CustomGraphicsVisualPropertyEditor cgVisualPropertyEditor = new CustomGraphicsVisualPropertyEditor(CyCustomGraphics.class, cgValueEditor, cmCellRendererFactory, serviceRegistrar);
        this.registerService(bc, (Object)cgVisualPropertyEditor, VisualPropertyEditor.class);
    }
}

