/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.functions;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.internal.functions.SuidSearchUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.service.util.CyServiceRegistrar;

public class TargetID
extends AbstractFunction {
    private final CyServiceRegistrar registrar;

    public TargetID(CyServiceRegistrar serviceRegistrar) {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.INT, "edge_SUID", "The SUID identifier attribute of an edge.")});
        this.registrar = serviceRegistrar;
    }

    public String getName() {
        return "TARGETID";
    }

    public String getCategoryName() {
        return "Network";
    }

    public String getFunctionSummary() {
        return "Returns the SUID of the edge's target node.";
    }

    public Class<?> getReturnType() {
        return Long.class;
    }

    public Object evaluateFunction(Object[] args) {
        Long edgeID = FunctionUtil.getArgAsLong((Object)args[0]);
        Long targetId = SuidSearchUtil.lookup(this.registrar, CyEdge.class, edgeID, (net, edge) -> edge.getTarget().getSUID());
        if (targetId == null) {
            throw new IllegalArgumentException("\"" + edgeID + "\" is not a valid edge identifier.");
        }
        return targetId;
    }
}

