/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.functions;

import java.util.Set;
import java.util.function.BiFunction;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;

public class SuidSearchUtil {
    public static <T, R> R lookup(CyServiceRegistrar registrar, Class<T> type, Long suid, BiFunction<CyNetwork, T, R> func) {
        T elem;
        CyNetwork currentNetwork = ((CyApplicationManager)registrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        if (currentNetwork != null && (elem = SuidSearchUtil.getIdentifiable(type, currentNetwork, suid)) != null) {
            return func.apply(currentNetwork, (CyNetwork)elem);
        }
        Set allNetworks = ((CyNetworkManager)registrar.getService(CyNetworkManager.class)).getNetworkSet();
        for (CyNetwork network : allNetworks) {
            T elem2;
            if (network == currentNetwork || (elem2 = SuidSearchUtil.getIdentifiable(type, network, suid)) == null) continue;
            return func.apply(network, (CyNetwork)elem2);
        }
        return null;
    }

    private static <T> T getIdentifiable(Class<T> type, CyNetwork network, Long suid) {
        if (type == CyNode.class) {
            return type.cast(network.getNode(suid.longValue()));
        }
        if (type == CyEdge.class) {
            return type.cast(network.getEdge(suid.longValue()));
        }
        return null;
    }
}

