/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.functions;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.internal.functions.SuidSearchUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;

public class Degree
extends AbstractFunction {
    private final CyServiceRegistrar registrar;

    public Degree(CyServiceRegistrar serviceRegistrar) {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.INT, "node_SUID", "The SUID identifier attribute of a node.")});
        this.registrar = serviceRegistrar;
    }

    public String getName() {
        return "DEGREE";
    }

    public String getCategoryName() {
        return "Network";
    }

    public String getFunctionSummary() {
        return "Returns the degree of a node. The degree is the number of edges connected to the node.";
    }

    public Class<?> getReturnType() {
        return Long.class;
    }

    public Object evaluateFunction(Object[] args) {
        Long nodeID = FunctionUtil.getArgAsLong((Object)args[0]);
        Long degree = SuidSearchUtil.lookup(this.registrar, CyNode.class, nodeID, this::degree);
        if (degree == null) {
            throw new IllegalArgumentException("\"" + nodeID + "\" is not a valid node identifier.");
        }
        return degree;
    }

    private Long degree(CyNetwork net, CyNode node) {
        return net.getAdjacentEdgeList(node, CyEdge.Type.ANY).size();
    }
}

