/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.network.merge.internal.model.AttributeMapping;
import org.cytoscape.network.merge.internal.model.MatchingAttribute;
import org.cytoscape.network.merge.internal.ui.RowTableCellEditor;
import org.cytoscape.network.merge.internal.util.ColumnType;
import org.cytoscape.util.swing.LookAndFeelUtil;

class MergeAttributeTable
extends JTable {
    private final String nullAttr = "[DELETE THIS]";
    private MatchingAttribute matchingAttribute;
    private AttributeMapping attributeMapping;
    private String mergedNetworkName;
    private MergeAttributeTableModel model;
    private boolean isNode;
    private int indexMatchingAttr;

    public MergeAttributeTable(AttributeMapping attributeMapping, MatchingAttribute matchingAttribute) {
        this.isNode = true;
        this.indexMatchingAttr = -1;
        this.mergedNetworkName = "Merged Network";
        this.attributeMapping = attributeMapping;
        this.matchingAttribute = matchingAttribute;
        this.model = new MergeAttributeTableModel();
        this.setModel(this.model);
        this.setSelectionMode(0);
    }

    public MergeAttributeTable(AttributeMapping attributeMapping) {
        this.mergedNetworkName = "Merged Network";
        this.attributeMapping = attributeMapping;
        this.model = new MergeAttributeTableModel();
        this.isNode = false;
        this.setModel(this.model);
    }

    public String getMergedNetworkName() {
        return this.mergedNetworkName;
    }

    private Vector<String> getComboboxOption(int col) {
        CyNetwork net = this.model.getNetork(col);
        CyTable table = this.attributeMapping.getCyTable(net);
        Vector<String> colNames = new Vector<String>();
        for (CyColumn cyCol : table.getColumns()) {
            String colName = cyCol.getName();
            if (colName.equals("SUID") || colName.equals("selected") || colName.equals("__Annotations")) continue;
            colNames.add(colName);
        }
        colNames.add("[DELETE THIS]");
        return colNames;
    }

    protected void setColumnEditorAndRenderer() {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            if (this.isColumnOriginalNetwork(i)) {
                Vector<String> attrs = this.getComboboxOption(i);
                JComboBox<String> comboBox = new JComboBox<String>(attrs);
                column.setCellEditor(new DefaultCellEditor(comboBox));
                column.setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
                        this.setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
                        if (row < (MergeAttributeTable.this.isNode ? 1 : 0)) {
                            this.setToolTipText("Change this in the matching node table above");
                        } else {
                            this.setToolTipText(null);
                        }
                        return this;
                    }
                });
                continue;
            }
            if (this.isColumnMergedNetwork(i)) {
                column.setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (MergeAttributeTable.this.isNode && row == 0) {
                            this.setToolTipText("Change me!");
                        } else {
                            this.setToolTipText("Click to change...");
                        }
                        if (isSelected) {
                            this.setForeground(UIManager.getColor("Table.selectionForeground"));
                            this.setBackground(UIManager.getColor("Table.selectionBackground"));
                        } else {
                            this.setBackground(UIManager.getColor("Table.background"));
                            if (row >= table.getRowCount() - 1) {
                                this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                            } else if (MergeAttributeTable.this.isNode && row == 0) {
                                this.setForeground(LookAndFeelUtil.getErrorColor());
                                this.setToolTipText("Change me!");
                            } else {
                                this.setForeground(table.getForeground());
                                this.setToolTipText("Click to change...");
                            }
                        }
                        return this;
                    }
                });
                continue;
            }
            if (!this.isColumnMergedType(i)) continue;
            RowTableCellEditor rowEditor = new RowTableCellEditor(this);
            int nr = this.getRowCount();
            Vector[] cbvalues = new Vector[nr];
            for (int ir = 0; ir < nr - 1; ++ir) {
                Vector<ColumnType> convertiableTypes;
                int iAttr = ir;
                Map<CyNetwork, String> mapNetAttr = this.attributeMapping.getOriginalAttributeMap(iAttr);
                EnumSet<ColumnType> types = EnumSet.noneOf(ColumnType.class);
                for (Map.Entry<CyNetwork, String> entry : mapNetAttr.entrySet()) {
                    CyTable cyTable = this.attributeMapping.getCyTable(entry.getKey());
                    types.add(ColumnType.getType(cyTable.getColumn(entry.getValue())));
                }
                ColumnType reasonalbeType = ColumnType.getResonableCompatibleConvertionType(types);
                cbvalues[ir] = convertiableTypes = new Vector<ColumnType>(ColumnType.getConvertibleTypes(reasonalbeType));
                JComboBox<ColumnType> cb = new JComboBox<ColumnType>(convertiableTypes);
                cb.setSelectedItem((Object)this.attributeMapping.getMergedAttributeType(iAttr));
                rowEditor.setEditorAt(ir, new DefaultCellEditor(cb));
            }
            column.setCellEditor(rowEditor);
            column.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
                    this.setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
                    if (row >= table.getRowCount() - 1) {
                        this.setBackground(UIManager.getColor("TextField.inactiveForeground"));
                    } else if (!table.isCellEditable(row, column)) {
                        this.setBackground(UIManager.getColor("TextField.inactiveForeground"));
                        this.setToolTipText("Only types of new columns are changeable");
                    }
                    return this;
                }
            });
        }
    }

    protected void setMergedNetworkNameTableHeaderListener() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTableHeader header = (JTableHeader)e.getSource();
                JTable table = header.getTable();
                int columnIndex = header.columnAtPoint(e.getPoint());
                if (columnIndex == MergeAttributeTable.this.attributeMapping.getSizeNetwork()) {
                    String title = JOptionPane.showInputDialog(table.getParent(), (Object)"Input the title for the merged network");
                    if (title != null && title.length() != 0) {
                        MergeAttributeTable.this.mergedNetworkName = title;
                        MergeAttributeTable.this.fireTableHeaderChanged();
                    } else {
                        MergeAttributeTable.this.fireTableHeaderChanged();
                    }
                }
            }
        });
    }

    public void fireTableStructureChanged() {
        this.model.fireTableStructureChanged();
        this.setColumnEditorAndRenderer();
        this.setMergedNetworkNameTableHeaderListener();
    }

    public void updateMatchingAttribute() {
        if (!this.isNode) {
            throw new UnsupportedOperationException("updateMatchingAttribute is only supported for node table");
        }
        boolean update = false;
        if (this.indexMatchingAttr == -1) {
            this.indexMatchingAttr = 0;
            String attr_merged = "Matching.Attribute";
            HashMap<CyNetwork, String> netAttrMap = new HashMap<CyNetwork, String>();
            EnumSet<ColumnType> types = EnumSet.noneOf(ColumnType.class);
            for (Map.Entry<CyNetwork, CyColumn> entry : this.matchingAttribute.getNetAttrMap().entrySet()) {
                netAttrMap.put(entry.getKey(), entry.getValue().getName());
                types.add(ColumnType.getType(entry.getValue()).toPlain());
            }
            this.attributeMapping.addAttributes(netAttrMap, attr_merged, this.indexMatchingAttr);
            this.attributeMapping.setMergedAttributeType(this.indexMatchingAttr, ColumnType.getResonableCompatibleConvertionType(types).toList());
            update = true;
        } else {
            Set<CyNetwork> networks = this.matchingAttribute.getNetworkSet();
            Iterator<CyNetwork> it = networks.iterator();
            if (!it.hasNext()) {
                this.indexMatchingAttr = -1;
            }
            while (it.hasNext()) {
                String old;
                CyNetwork network = it.next();
                String attr = this.matchingAttribute.getAttributeForMatching(network).getName();
                if (attr.compareTo(old = this.attributeMapping.setOriginalAttribute(network, attr, this.indexMatchingAttr)) == 0) continue;
                update = true;
            }
        }
        if (update) {
            this.fireTableStructureChanged();
        }
    }

    protected void fireTableHeaderChanged() {
        this.model.fireTableStructureChanged();
        this.setColumnEditorAndRenderer();
    }

    protected boolean isColumnOriginalNetwork(int col) {
        return col >= 0 && col < this.attributeMapping.getSizeNetwork();
    }

    protected boolean isColumnMergedNetwork(int col) {
        return col == this.attributeMapping.getSizeNetwork();
    }

    protected boolean isColumnMergedType(int col) {
        return col == this.attributeMapping.getSizeNetwork() + 1;
    }

    protected class MergeAttributeTableModel
    extends AbstractTableModel {
        ArrayList<CyNetwork> networks;

        public MergeAttributeTableModel() {
            this.resetNetworks();
        }

        @Override
        public int getColumnCount() {
            int n = MergeAttributeTable.this.attributeMapping.getSizeNetwork();
            return n == 0 ? 0 : n + 2;
        }

        @Override
        public int getRowCount() {
            int n = MergeAttributeTable.this.attributeMapping.getSizeMergedAttributes() + 1;
            int count = MergeAttributeTable.this.attributeMapping.getSizeNetwork() == 0 ? 0 : n;
            return count;
        }

        @Override
        public String getColumnName(int col) {
            if (MergeAttributeTable.this.isColumnMergedType(col)) {
                return "Column type";
            }
            if (MergeAttributeTable.this.isColumnMergedNetwork(col)) {
                return MergeAttributeTable.this.mergedNetworkName;
            }
            if (MergeAttributeTable.this.isColumnOriginalNetwork(col)) {
                return this.networks.get(col).toString();
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            int iAttr = row;
            if (row == this.getRowCount() - 1) {
                return null;
            }
            if (MergeAttributeTable.this.isColumnOriginalNetwork(col)) {
                return MergeAttributeTable.this.attributeMapping.getOriginalAttribute(this.networks.get(col), iAttr);
            }
            if (MergeAttributeTable.this.isColumnMergedNetwork(col)) {
                return MergeAttributeTable.this.attributeMapping.getMergedAttribute(iAttr);
            }
            if (MergeAttributeTable.this.isColumnMergedType(col)) {
                return MergeAttributeTable.this.attributeMapping.getMergedAttributeType(iAttr);
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (MergeAttributeTable.this.isNode && row == 0) {
                return !MergeAttributeTable.this.isColumnOriginalNetwork(col);
            }
            if (MergeAttributeTable.this.isColumnOriginalNetwork(col)) {
                return true;
            }
            if (MergeAttributeTable.this.isColumnMergedNetwork(col)) {
                return row != this.getRowCount() - 1;
            }
            return MergeAttributeTable.this.isColumnMergedType(col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ColumnType type;
            if (value == null) {
                return;
            }
            int iAttr = row;
            int n = MergeAttributeTable.this.attributeMapping.getSizeMergedAttributes();
            if (iAttr > n) {
                return;
            }
            if (MergeAttributeTable.this.isColumnMergedType(col)) {
                if (iAttr == n) {
                    return;
                }
                type = (ColumnType)((Object)value);
                ColumnType type_curr = MergeAttributeTable.this.attributeMapping.getMergedAttributeType(iAttr);
                if (type == type_curr) {
                    return;
                }
            } else {
                if (MergeAttributeTable.this.isColumnMergedNetwork(col)) {
                    if (iAttr == n) {
                        return;
                    }
                    String v = (String)value;
                    String attr_curr = MergeAttributeTable.this.attributeMapping.getMergedAttribute(iAttr);
                    if (attr_curr.compareTo(v) == 0) {
                        return;
                    }
                    if (v.length() == 0) {
                        JOptionPane.showMessageDialog(MergeAttributeTable.this.getParent(), "Please use a non-empty name for the column.", "Error: empty column name", 0);
                        return;
                    }
                    if (MergeAttributeTable.this.attributeMapping.containsMergedAttribute(v)) {
                        JOptionPane.showMessageDialog(MergeAttributeTable.this.getParent(), "Column " + v + " already exist. Please use another name for this column.", "Error: duplicated column name", 0);
                        return;
                    }
                    MergeAttributeTable.this.attributeMapping.setMergedAttribute(iAttr, v);
                    this.fireTableDataChanged();
                    return;
                }
                CyNetwork net = this.networks.get(col);
                String v = (String)value;
                if (iAttr == n) {
                    if (v.compareTo("[DELETE THIS]") == 0) {
                        return;
                    }
                    HashMap<CyNetwork, String> map = new HashMap<CyNetwork, String>();
                    map.put(net, v);
                    MergeAttributeTable.this.attributeMapping.addAttributes(map, v);
                    this.fireTableDataChanged();
                    return;
                }
                String curr_attr = MergeAttributeTable.this.attributeMapping.getOriginalAttribute(net, iAttr);
                if (curr_attr != null && curr_attr.compareTo(v) == 0) {
                    return;
                }
                if (v.compareTo("[DELETE THIS]") == 0) {
                    if (curr_attr == null) {
                        return;
                    }
                    MergeAttributeTable.this.attributeMapping.removeOriginalAttribute(net, iAttr);
                } else {
                    MergeAttributeTable.this.attributeMapping.setOriginalAttribute(net, v, iAttr);
                }
                this.fireTableDataChanged();
                return;
            }
            MergeAttributeTable.this.attributeMapping.setMergedAttributeType(iAttr, type);
        }

        @Override
        public void fireTableStructureChanged() {
            this.resetNetworks();
            super.fireTableStructureChanged();
        }

        private void resetNetworks() {
            this.networks = new ArrayList<CyNetwork>(MergeAttributeTable.this.attributeMapping.getNetworkSet());
        }

        public CyNetwork getNetork(int col) {
            return this.networks.get(col);
        }
    }
}

