/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.cytoscape.network.merge.internal.ui.IDTypeSelectionTable;

public class IDMappingDialog
extends JDialog {
    private JPanel idTypePanel;
    private IDTypeSelectionTable idTypeSelectionTable;
    private JScrollPane idTypeScrollPane;
    private JButton okButton;
    private JButton optionButton;
    private JPanel optionPanel;
    private JComboBox toComboBox;
    private JLabel toLabel;
    private boolean cancelled;
    private Frame frame;
    private boolean isNode;
    private Map<String, Map<String, Set<String>>> selectedNetworkAttributeIDType;

    public IDMappingDialog(Frame parent, boolean modal, Map<String, Set<String>> selectedNetworkAttribute, boolean isNode) {
        super(parent, modal);
        this.frame = parent;
        this.isNode = isNode;
        this.initSrcTypes(selectedNetworkAttribute);
        this.cancelled = true;
        this.initComponents();
    }

    private void initSrcTypes(Map<String, Set<String>> selectedNetworkAttribute) {
        this.selectedNetworkAttributeIDType = new HashMap<String, Map<String, Set<String>>>();
        for (Map.Entry<String, Set<String>> entry : selectedNetworkAttribute.entrySet()) {
            String netID = entry.getKey();
            HashMap mapAttributeIDType = new HashMap();
            this.selectedNetworkAttributeIDType.put(netID, mapAttributeIDType);
            for (String attr : entry.getValue()) {
                HashSet types = new HashSet();
                mapAttributeIDType.put(attr, types);
            }
        }
    }

    private void initComponents() {
        this.idTypePanel = new JPanel();
        this.idTypeScrollPane = new JScrollPane();
        JPanel toPanel = new JPanel();
        this.toLabel = new JLabel();
        this.toComboBox = new JComboBox();
        this.optionPanel = new JPanel();
        this.optionButton = new JButton();
        JPanel okPanel = new JPanel();
        this.okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("ID Mapping Configuration");
        this.getContentPane().setLayout(new GridBagLayout());
        this.idTypePanel.setBorder(BorderFactory.createTitledBorder("Select ID type(s) for each column"));
        this.idTypePanel.setLayout(new BoxLayout(this.idTypePanel, 2));
        this.idTypeScrollPane.setMinimumSize(new Dimension(450, 200));
        this.idTypeScrollPane.setPreferredSize(new Dimension(500, 300));
        this.idTypeSelectionTable = new IDTypeSelectionTable(this.frame, this);
        this.idTypeScrollPane.setViewportView(this.idTypeSelectionTable);
        this.idTypePanel.add(this.idTypeScrollPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.idTypePanel, gridBagConstraints);
        toPanel.setLayout(new FlowLayout(0, 10, 5));
        this.toLabel.setText("Destination ID Type:");
        toPanel.add(this.toLabel);
        toPanel.add(this.toComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)toPanel, gridBagConstraints);
        this.optionPanel.setLayout(new BoxLayout(this.optionPanel, 2));
        this.optionButton.setText("Configure ID Mapping Resources");
        this.optionButton.setToolTipText("Click to set up options");
        this.optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDMappingDialog.this.optionButtonActionPerformed(evt);
            }
        });
        this.optionPanel.add(this.optionButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.optionPanel, gridBagConstraints);
        this.okButton.setText("   OK   ");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDMappingDialog.this.okButtonActionPerformed(evt);
            }
        });
        okPanel.add(this.okButton);
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDMappingDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        okPanel.add(cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        this.getContentPane().add((Component)okPanel, gridBagConstraints);
        this.pack();
    }

    private void optionButtonActionPerformed(ActionEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public Map<String, Map<String, Set<String>>> getSrcTypes() {
        return this.selectedNetworkAttributeIDType;
    }

    void updateGoButtonEnable() {
        if (this.getTgtType() == null) {
            this.okButton.setToolTipText("No target ID type available");
            this.okButton.setEnabled(false);
            return;
        }
        for (String network : this.selectedNetworkAttributeIDType.keySet()) {
            Map<String, Set<String>> mapAttrIDType = this.selectedNetworkAttributeIDType.get(network);
            Iterator<Set<String>> itTypes = mapAttrIDType.values().iterator();
            while (itTypes.hasNext()) {
                if (!itTypes.next().isEmpty()) continue;
                this.okButton.setToolTipText("Select at least one ID type for each column");
                this.okButton.setEnabled(false);
                return;
            }
        }
        this.okButton.setToolTipText(null);
        this.okButton.setEnabled(true);
    }

    public String getTgtType() {
        if (this.toComboBox.getItemCount() == 0) {
            return null;
        }
        return (String)this.toComboBox.getSelectedItem();
    }

    public void setTgtType(String type) {
        if (type == null) {
            return;
        }
        this.toComboBox.setSelectedItem(type);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

