/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.task;

import java.awt.Dialog;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.network.merge.internal.ui.NetworkMergeDialog;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class NetworkMergeTaskFactory
implements TaskFactory {
    final CyServiceRegistrar registrar;
    final CyNetworkManager netManager;

    public NetworkMergeTaskFactory(CyServiceRegistrar reg) {
        this.registrar = reg;
        this.netManager = (CyNetworkManager)reg.getService(CyNetworkManager.class);
    }

    public boolean isReady() {
        return this.netManager.getNetworkSet() != null && this.netManager.getNetworkSet().size() > 0;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new NetworkMergeDialogTask(this.registrar)});
    }

    class NetworkMergeDialogTask
    extends AbstractTask {
        final CyServiceRegistrar registrar;
        final CySwingApplication swingApp;

        NetworkMergeDialogTask(CyServiceRegistrar registrar) {
            this.registrar = registrar;
            this.swingApp = (CySwingApplication)registrar.getService(CySwingApplication.class);
        }

        public void run(TaskMonitor monitor) {
            SwingUtilities.invokeLater(() -> {
                NetworkMergeDialog dialog = new NetworkMergeDialog(this.registrar);
                dialog.setLocationRelativeTo(this.swingApp.getJFrame());
                dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
                dialog.setVisible(true);
            });
        }
    }
}

