/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.network.merge.internal.NetworkMerge;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictCollectorImpl;
import org.cytoscape.network.merge.internal.model.AttributeMapping;
import org.cytoscape.network.merge.internal.model.AttributeMappingImpl;
import org.cytoscape.network.merge.internal.model.ColumnMergeRecord;
import org.cytoscape.network.merge.internal.model.MatchingAttribute;
import org.cytoscape.network.merge.internal.model.MatchingAttributeImpl;
import org.cytoscape.network.merge.internal.task.NetworkMergeTask;
import org.cytoscape.network.merge.internal.util.ParseUtils;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class NetworkMergeCommandTask
extends AbstractTask
implements ObservableTask {
    @ContainsTunables
    @Tunable(description="Type of Merge", context="nogui", longDescription="Whether the networks are merged by union, intersection or difference", exampleStringValue="union")
    public ListSingleSelection<String> operation = new ListSingleSelection((Object[])new String[]{"union", "intersection", "difference"});
    @Tunable(description="Name of the output network", context="nogui", longDescription="An override of the name for the network created by this merge", exampleStringValue="Merged Network")
    public String netName;
    @Tunable(description="Source Networks", context="nogui", longDescription="The comma-delimited names of the input networks (max:2)", exampleStringValue="network1, network2")
    public String sources;
    @Tunable(description="Matching Node Columns", context="nogui", longDescription="The comma-delimited, order-dependent list of columns to match each node in the source networks", exampleStringValue="name, shared name")
    public String nodeKeys = "name, name";
    @Tunable(description="Node Merge Map", context="nogui", longDescription="A list of column merge records, each containing a list of column names corresponding to the network list of the form {column1, column2, merged column, type}", exampleStringValue="{name, display name, mergedName, String}, {COMMON, COMMON, COMMON, String}")
    public String nodeMergeMap;
    @Tunable(description="Matching Edge Columns", context="nogui", longDescription="The comma-delimited, order-dependent list of columns to match each edge in the source netw  orks", exampleStringValue="name, name")
    public String edgeKeys;
    @Tunable(description="Edge Merge Map", context="nogui", longDescription="A list of column merge records, each containing a list of column names from the edge table corresponding to the network list of the form {column1, column2, merged column, type}", exampleStringValue="{interaction, shared interaction, relation , String},{name, name, name, String},{EdgeBetweenness, EdgeBetweenness, Betweenness, Double}")
    public String edgeMergeMap;
    @Tunable(description="Network Merge Map", context="nogui", longDescription="A list of column merge records, each containing a list of column names from the network table corresponding to the network list of the form {column1, column2, merged column, type}", exampleStringValue="{_Annotations, _Annotations, _Annotations, List},{name, name, name, String}")
    public String networkMergeMap;
    @Tunable(description="Nodes only", context="nogui", longDescription="If true, this will merge the node tables and dismiss edges.", exampleStringValue="false")
    public boolean nodesOnly = false;
    @Tunable(description="Enable merging nodes/edges in the same network", context="nogui", longDescription="If true, nodes and edges with matching attributes in the same network will be merged", exampleStringValue="true")
    public boolean inNetworkMerge = true;
    private CyServiceRegistrar registrar;
    private boolean verbose = false;
    NetworkMergeTask nmTask;

    public NetworkMergeCommandTask(CyServiceRegistrar reg) {
        this.registrar = reg;
        this.operation.setSelectedValue((Object)"union");
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        CyNetworkNaming cyNetworkNaming = (CyNetworkNaming)this.registrar.getService(CyNetworkNaming.class);
        CyNetworkFactory cyNetworkFactory = (CyNetworkFactory)this.registrar.getService(CyNetworkFactory.class);
        CreateNetworkViewTaskFactory netViewCreator = (CreateNetworkViewTaskFactory)this.registrar.getService(CreateNetworkViewTaskFactory.class);
        CyNetworkManager cnm = (CyNetworkManager)this.registrar.getService(CyNetworkManager.class);
        CyNetworkViewManager nvm = (CyNetworkViewManager)this.registrar.getService(CyNetworkViewManager.class);
        VisualMappingManager vmm = (VisualMappingManager)this.registrar.getService(VisualMappingManager.class);
        if (this.verbose) {
            System.err.println("A: build network list ---------------- ");
        }
        if (this.verbose) {
            this.dumpInfo();
        }
        if (this.netName == null) {
            this.netName = (String)this.operation.getSelectedValue() + ": " + this.sources;
        }
        this.netName = cyNetworkNaming.getSuggestedNetworkTitle(this.netName);
        if (this.verbose) {
            System.out.println(this.netName);
        }
        List<CyNetwork> networkList = this.buildNetworkList(cnm);
        if (this.verbose) {
            for (CyNetwork n : networkList) {
                System.out.println(n.getSUID() + " = " + NetworkMergeCommandTask.getNetworkName(n));
            }
        }
        if (networkList.size() < 2) {
            if (this.verbose) {
                System.err.println("networkList.size() < 2");
            }
            return;
        }
        MatchingAttribute matchingAttribute = this.buildMatchingAttribute(networkList);
        AttributeMapping nodeAttributeMapping = this.buildNodeAttributeMapping(networkList, this.nodeMergeMap);
        AttributeMapping edgeAttributeMapping = this.buildEdgeAttributeMapping(networkList, this.edgeMergeMap);
        AttributeMapping networkAttributeMapping = this.buildNetworkAttributeMapping(networkList, this.networkMergeMap);
        NetworkMerge.Operation op = NetworkMerge.Operation.UNION;
        if (((String)this.operation.getSelectedValue()).equals("union")) {
            op = NetworkMerge.Operation.UNION;
        } else if (((String)this.operation.getSelectedValue()).equals("intersection")) {
            op = NetworkMerge.Operation.INTERSECTION;
        } else if (((String)this.operation.getSelectedValue()).equals("difference")) {
            op = NetworkMerge.Operation.DIFFERENCE;
        }
        if (this.verbose) {
            System.err.println("Operation: " + op.toString());
        }
        boolean useDiference = op == NetworkMerge.Operation.DIFFERENCE;
        AttributeConflictCollectorImpl conflictCollector = new AttributeConflictCollectorImpl();
        this.nmTask = new NetworkMergeTask(this.registrar, this.netName, matchingAttribute, nodeAttributeMapping, edgeAttributeMapping, networkAttributeMapping, networkList, op, useDiference, conflictCollector, this.inNetworkMerge, this.nodesOnly);
        TaskManager tm = (TaskManager)this.registrar.getService(SynchronousTaskManager.class);
        tm.execute(new TaskIterator(new Task[]{this.nmTask}));
    }

    private MatchingAttribute buildMatchingAttribute(List<CyNetwork> networkList) {
        MatchingAttributeImpl joinColumns = new MatchingAttributeImpl();
        if (this.nodeKeys.trim().length() > 0) {
            List<String> columnNames = this.parseKeys(this.nodeKeys);
            if (networkList.size() != columnNames.size()) {
                System.err.println("size mismatch!!");
            }
            int z = networkList.size();
            for (int i = 0; i < z; ++i) {
                String colname = columnNames.get(i);
                CyNetwork net = networkList.get(i);
                CyColumn column = net.getDefaultNodeTable().getColumn(colname);
                if (column != null) {
                    joinColumns.putAttributeForMatching(net, column);
                    if (!this.verbose) continue;
                    System.out.println(" putting: " + column.getName() + " for " + net);
                    continue;
                }
                System.out.println(" not found:  ");
            }
        }
        return joinColumns;
    }

    private List<String> parseKeys(String keys2) {
        String[] keys;
        ArrayList<String> strs = new ArrayList<String>();
        for (String key : keys = keys2.split(",")) {
            strs.add(key.trim());
        }
        if (this.verbose) {
            System.out.print("parseKeys: ");
            for (String s : keys) {
                System.out.print(s + ", ");
            }
            System.out.println(keys.length);
        }
        return strs;
    }

    private List<CyNetwork> buildNetworkList(CyNetworkManager cnm) {
        if (this.verbose) {
            System.out.println("A:  buildNetworkList ------------");
        }
        Set sessionNets = cnm.getNetworkSet();
        ArrayList<CyNetwork> networkList = new ArrayList<CyNetwork>();
        ArrayList<String> sourceList = new ArrayList<String>();
        String[] strs = this.sources.split(",");
        for (String str : strs) {
            sourceList.add(str.trim());
        }
        if (this.verbose) {
            System.out.print("sources: ");
            for (String str : sourceList) {
                System.out.print(str + ", ");
            }
            System.out.println("");
        }
        for (String src : sourceList) {
            CyNetwork sessionNet = this.find(sessionNets, src);
            String netName = NetworkMergeCommandTask.getNetworkName(sessionNet);
            if (sessionNet != null) {
                networkList.add(sessionNet);
                if (!this.verbose) continue;
                System.out.println(netName + "<-" + sessionNet.getSUID());
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("net not found: " + netName);
        }
        if (this.verbose) {
            System.out.println(networkList + " size: " + networkList.size());
        }
        return networkList;
    }

    private CyNetwork find(Set<CyNetwork> sessionNets, String src) {
        for (CyNetwork net : sessionNets) {
            if (!NetworkMergeCommandTask.getNetworkName(net).equals(src)) continue;
            return net;
        }
        return null;
    }

    private AttributeMapping buildAttributeMapping(AttributeMapping mapping, List<CyNetwork> networkList, String mergeString) {
        List<ColumnMergeRecord> mergeColumns = ParseUtils.getMergeMap(mergeString, networkList);
        if (mergeColumns == null) {
            return mapping;
        }
        for (ColumnMergeRecord rec : mergeColumns) {
            String mergedAttribute = rec.outName;
            int mergedAttributeIndex = mapping.getMergedAttributeIndex(mergedAttribute);
            if (mergedAttributeIndex == -1) {
                mapping.addAttributes(rec.columnNames, mergedAttribute);
                continue;
            }
            for (CyNetwork net : networkList) {
                mapping.setOriginalAttribute(net, rec.columnNames.get(net), mergedAttributeIndex);
            }
            mapping.setMergedAttributeType(mergedAttributeIndex, rec.outType);
        }
        return mapping;
    }

    private AttributeMapping buildNodeAttributeMapping(List<CyNetwork> networkList, String mergeString) {
        AttributeMappingImpl nodeAttributeMapping = new AttributeMappingImpl();
        for (CyNetwork net : networkList) {
            CyTable nodeTable = net.getDefaultNodeTable();
            nodeAttributeMapping.addNetwork(net, nodeTable);
        }
        return this.buildAttributeMapping(nodeAttributeMapping, networkList, mergeString);
    }

    private AttributeMapping buildNetworkAttributeMapping(List<CyNetwork> networkList, String mergeString) {
        AttributeMappingImpl networkAttributeMapping = new AttributeMappingImpl();
        for (CyNetwork net : networkList) {
            CyTable netTable = net.getDefaultNetworkTable();
            networkAttributeMapping.addNetwork(net, netTable);
        }
        return this.buildAttributeMapping(networkAttributeMapping, networkList, mergeString);
    }

    private AttributeMapping buildEdgeAttributeMapping(List<CyNetwork> networkList, String mergeString) {
        AttributeMappingImpl edgeAttributeMapping = new AttributeMappingImpl();
        for (CyNetwork net : networkList) {
            CyTable edgeTable = net.getDefaultEdgeTable();
            edgeAttributeMapping.addNetwork(net, edgeTable);
        }
        return this.buildAttributeMapping(edgeAttributeMapping, networkList, mergeString);
    }

    public static String getNetworkName(CyNetwork net) {
        CyTable table = net.getDefaultNetworkTable();
        if (table == null) {
            return "ERR1";
        }
        CyRow row = (CyRow)table.getAllRows().get(0);
        if (row == null) {
            return "ERR2";
        }
        String netName = (String)row.get("name", String.class);
        return netName;
    }

    public static String getNodeName(CyNetwork net, CyNode node) {
        if (net == null) {
            return "No Net";
        }
        if (node == null) {
            return "No node";
        }
        String ret = "" + node.getSUID();
        try {
            CyTable table = net.getDefaultNodeTable();
            CyRow row = table.getRow((Object)node.getSUID());
            if (row != null) {
                ret = (String)row.get("name", String.class) + " [" + node.getSUID() + "]";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getNetAndNodeName(CyNode node) {
        CyNetwork net = node.getNetworkPointer();
        return net == null ? "" + node.getSUID() : NetworkMergeCommandTask.getNetworkName(net) + ":" + NetworkMergeCommandTask.getNodeName(net, node);
    }

    public static String edgeName(CyNetwork net, CyEdge edge) {
        return NetworkMergeCommandTask.getNodeName(net, edge.getSource()) + " -> " + NetworkMergeCommandTask.getNodeName(net, edge.getTarget());
    }

    public static String getEdgeSet(CyNetwork netw, Set<CyEdge> edgeSet) {
        StringBuilder build = new StringBuilder("[");
        for (CyEdge e : edgeSet) {
            build.append(NetworkMergeCommandTask.edgeName(netw, e)).append(", ");
        }
        return build.toString() + "]";
    }

    private void dumpInfo() {
        System.out.println("sources: " + this.sources);
        System.out.println("keys: " + this.nodeKeys);
        System.out.println("nodeMergeMap: " + this.nodeMergeMap);
        System.out.println("edgeKeys: " + this.edgeKeys);
        System.out.println("edgeMergeMap: " + this.edgeMergeMap);
        System.out.println("operation: " + (String)this.operation.getSelectedValue());
        System.out.println("nodesOnly: " + (this.nodesOnly ? "T" : "F"));
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, CyNetwork.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(String.class)) {
            return (R)this.nmTask.getResults(String.class);
        }
        if (type.equals(JSONResult.class)) {
            return (R)this.nmTask.getResults(JSONResult.class);
        }
        if (type.equals(CyNetwork.class)) {
            return (R)this.nmTask.getResults(CyNetwork.class);
        }
        return null;
    }

    public void cancel() {
    }
}

