/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.model;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.network.merge.internal.model.MatchingAttribute;

public class MatchingAttributeImpl
implements MatchingAttribute {
    private Map<CyNetwork, CyColumn> attributeForMatching = new WeakHashMap<CyNetwork, CyColumn>();

    @Override
    public Map<CyNetwork, CyColumn> getNetAttrMap() {
        return this.attributeForMatching;
    }

    @Override
    public CyColumn getAttributeForMatching(CyNetwork net) {
        if (net == null) {
            throw new NullPointerException();
        }
        return this.attributeForMatching.get(net);
    }

    @Override
    public void putAttributeForMatching(CyNetwork net, CyColumn col) {
        if (net == null || col == null) {
            throw new NullPointerException();
        }
        this.attributeForMatching.put(net, col);
    }

    @Override
    public void addNetwork(CyNetwork net) {
        if (net == null) {
            throw new NullPointerException();
        }
        CyTable table = net.getDefaultNodeTable();
        CyColumn col = table.getColumn("name");
        this.putAttributeForMatching(net, col);
    }

    @Override
    public CyColumn removeNetwork(CyNetwork net) {
        if (net == null) {
            throw new NullPointerException();
        }
        return this.attributeForMatching.remove(net);
    }

    @Override
    public int getSizeNetwork() {
        return this.attributeForMatching.size();
    }

    @Override
    public Set<CyNetwork> getNetworkSet() {
        return this.attributeForMatching.keySet();
    }

    @Override
    public void clear() {
        this.attributeForMatching.clear();
    }
}

