/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.network.merge.internal.model.AttributeMapping;
import org.cytoscape.network.merge.internal.util.ColumnType;

public class AttributeMappingImpl
implements AttributeMapping {
    private Map<CyNetwork, List<String>> attributeMapping = new WeakHashMap<CyNetwork, List<String>>();
    private List<String> mergedAttributes = new ArrayList<String>();
    private List<ColumnType> mergedAttributeTypes = new ArrayList<ColumnType>();
    private List<Boolean> mergedAttributeMutability = new ArrayList<Boolean>();
    private Map<CyNetwork, CyTable> cyTables = new WeakHashMap<CyNetwork, CyTable>();
    private final String nullAttr = "";

    @Override
    public CyTable getCyTable(CyNetwork net) {
        return this.cyTables.get(net);
    }

    @Override
    public String[] getMergedAttributes() {
        return this.mergedAttributes.toArray(new String[0]);
    }

    @Override
    public int getSizeMergedAttributes() {
        return this.mergedAttributes.size();
    }

    @Override
    public String getMergedAttribute(int index) {
        if (index < 0 || index >= this.getSizeMergedAttributes()) {
            throw new IndexOutOfBoundsException("Index out of boundary.");
        }
        return this.mergedAttributes.get(index);
    }

    @Override
    public int getMergedAttributeIndex(String attr) {
        return this.mergedAttributes.indexOf(attr);
    }

    @Override
    public String setMergedAttribute(int index, String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("Column name is null.");
        }
        String ret = this.mergedAttributes.set(index, attributeName);
        this.resetMergedAttributeType(index, false);
        return ret;
    }

    @Override
    public ColumnType getMergedAttributeType(int index) {
        if (index >= this.getSizeMergedAttributes() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.mergedAttributeTypes.get(index);
    }

    @Override
    public ColumnType getMergedAttributeType(String mergedAttributeName) {
        if (mergedAttributeName == null) {
            throw new NullPointerException("Null netID or mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            throw new IllegalArgumentException("No " + mergedAttributeName + " is contained in merged table columns");
        }
        return this.getMergedAttributeType(index);
    }

    @Override
    public boolean setMergedAttributeType(int index, ColumnType type) {
        if (index >= this.getSizeMergedAttributes() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Map<CyNetwork, String> map = this.getOriginalAttributeMap(index);
        for (Map.Entry<CyNetwork, String> entry : map.entrySet()) {
            CyTable table = this.cyTables.get(entry.getKey());
            ColumnType oriType = ColumnType.getType(table.getColumn(entry.getValue()));
            if (ColumnType.isConvertable(oriType, type)) continue;
            System.err.println("Cannot convert from " + oriType.name() + " to " + type.name());
            return false;
        }
        this.mergedAttributeTypes.set(index, type);
        return true;
    }

    @Override
    public boolean setMergedAttributeType(String mergedAttributeName, ColumnType type) {
        if (mergedAttributeName == null) {
            throw new NullPointerException("Null netID or mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            throw new IllegalArgumentException("No " + mergedAttributeName + " is contained in merged table columns");
        }
        return this.setMergedAttributeType(index, type);
    }

    @Override
    public boolean getMergedAttributeMutability(int index) {
        if (index >= this.getSizeMergedAttributes() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.mergedAttributeMutability.get(index);
    }

    @Override
    public boolean getMergedAttributeMutability(String mergedAttributeName) {
        if (mergedAttributeName == null) {
            throw new NullPointerException("Null netID or mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            throw new IllegalArgumentException("No " + mergedAttributeName + " is contained in merged table columns");
        }
        return this.getMergedAttributeMutability(index);
    }

    @Override
    public void setMergedAttributeMutability(int index, boolean isImmutable) {
        if (index >= this.getSizeMergedAttributes() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.mergedAttributeMutability.set(index, isImmutable);
    }

    @Override
    public void setMergedAttributeMutability(String mergedAttributeName, boolean isImmutable) {
        if (mergedAttributeName == null) {
            throw new NullPointerException("Null netID or mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            throw new IllegalArgumentException("No " + mergedAttributeName + " is contained in merged table columns");
        }
        this.setMergedAttributeMutability(index, isImmutable);
    }

    @Override
    public boolean containsMergedAttribute(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("Column name is null.");
        }
        return this.mergedAttributes.contains(attributeName);
    }

    @Override
    public String getOriginalAttribute(CyNetwork net, String mergedAttributeName) {
        if (net == null || mergedAttributeName == null) {
            throw new NullPointerException("Null netID or mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            throw new IllegalArgumentException("No " + mergedAttributeName + " is contained in merged table columns");
        }
        return this.getOriginalAttribute(net, index);
    }

    @Override
    public String getOriginalAttribute(CyNetwork net, int index) {
        List<String> attrs = this.attributeMapping.get(net);
        if (attrs == null) {
            throw new IllegalArgumentException(net.toString() + " is not selected as merging network");
        }
        if (index >= attrs.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        String attr = attrs.get(index);
        if (attr.compareTo("") == 0) {
            return null;
        }
        return attr;
    }

    @Override
    public Map<CyNetwork, String> getOriginalAttributeMap(String mergedAttributeName) {
        if (mergedAttributeName == null) {
            throw new NullPointerException("Null netID or mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            throw new IllegalArgumentException("No " + mergedAttributeName + " is contained in merged table columns");
        }
        return this.getOriginalAttributeMap(index);
    }

    @Override
    public Map<CyNetwork, String> getOriginalAttributeMap(int index) {
        if (index >= this.getSizeMergedAttributes() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        HashMap<CyNetwork, String> return_this = new HashMap<CyNetwork, String>();
        for (Map.Entry<CyNetwork, List<String>> entry : this.attributeMapping.entrySet()) {
            CyNetwork net = entry.getKey();
            List<String> attrs = entry.getValue();
            String attr = attrs.get(index);
            if (attr.compareTo("") == 0) continue;
            return_this.put(net, attr);
        }
        return return_this;
    }

    @Override
    public String setOriginalAttribute(CyNetwork net, String attributeName, String mergedAttributeName) {
        if (net == null || mergedAttributeName == null) {
            throw new NullPointerException("Null netID or mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            throw new IllegalArgumentException("No " + mergedAttributeName + " is contained in merged table columns");
        }
        return this.setOriginalAttribute(net, attributeName, index);
    }

    @Override
    public String setOriginalAttribute(CyNetwork net, String attributeName, int index) {
        if (net == null || attributeName == null || attributeName == null) {
            throw new NullPointerException("Null netID or attributeName or mergedAttributeName");
        }
        List<String> attrs = this.attributeMapping.get(net);
        if (attrs == null) {
            return null;
        }
        if (index >= attrs.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        String old = attrs.get(index);
        if (old.compareTo(attributeName) != 0) {
            attrs.set(index, attributeName);
            this.resetMergedAttributeType(index, false);
        }
        return old;
    }

    @Override
    public String removeOriginalAttribute(CyNetwork net, String mergedAttributeName) {
        if (net == null || mergedAttributeName == null) {
            throw new NullPointerException("Null netID or mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            throw new IllegalArgumentException("No " + mergedAttributeName + " is contained in merged table columns");
        }
        return this.removeOriginalAttribute(net, index);
    }

    @Override
    public String removeOriginalAttribute(CyNetwork net, int index) {
        if (net == null) {
            throw new NullPointerException("Null netID");
        }
        if (index < 0 || index >= this.getSizeMergedAttributes()) {
            throw new IndexOutOfBoundsException("Index out of bounds");
        }
        List<String> attrs = this.attributeMapping.get(net);
        String old = attrs.set(index, "");
        if (!this.pack(index)) {
            this.resetMergedAttributeType(index, false);
        }
        return old;
    }

    @Override
    public String removeMergedAttribute(String mergedAttributeName) {
        if (mergedAttributeName == null) {
            throw new NullPointerException("Null mergedAttributeName");
        }
        int index = this.mergedAttributes.indexOf(mergedAttributeName);
        if (index == -1) {
            return null;
        }
        return this.removeMergedAttribute(index);
    }

    @Override
    public String removeMergedAttribute(int index) {
        if (index < 0 || index >= this.getSizeMergedAttributes()) {
            throw new IndexOutOfBoundsException("Index out of bounds");
        }
        for (List<String> attrs : this.attributeMapping.values()) {
            attrs.remove(index);
        }
        this.mergedAttributeTypes.remove(index);
        this.mergedAttributeMutability.remove(index);
        return this.mergedAttributes.remove(index);
    }

    @Override
    public String addAttributes(Map<CyNetwork, String> mapNetAttributeName, String mergedAttrName) {
        return this.addAttributes(mapNetAttributeName, mergedAttrName, this.getSizeMergedAttributes());
    }

    @Override
    public String addAttributes(Map<CyNetwork, String> mapNetAttributeName, String mergedAttrName, int index) {
        if (mapNetAttributeName == null || mergedAttrName == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index > this.getSizeMergedAttributes()) {
            throw new IndexOutOfBoundsException("Index out of bounds");
        }
        if (mapNetAttributeName.isEmpty()) {
            throw new IllegalArgumentException("Empty map");
        }
        Set<CyNetwork> networkSet = this.getNetworkSet();
        if (!networkSet.containsAll(mapNetAttributeName.keySet())) {
            throw new IllegalArgumentException("Non-exist network(s)");
        }
        for (Map.Entry<CyNetwork, List<String>> entry : this.attributeMapping.entrySet()) {
            CyNetwork net = entry.getKey();
            List<String> attrs = entry.getValue();
            String name = mapNetAttributeName.get(net);
            if (name != null) {
                attrs.add(index, name);
                continue;
            }
            attrs.add(index, "");
        }
        String defaultName = this.getDefaultMergedAttrName(mergedAttrName);
        this.mergedAttributes.add(index, defaultName);
        this.resetMergedAttributeType(index, true);
        this.resetMergedAttributeMutability(index, true);
        return defaultName;
    }

    @Override
    public void addNetwork(CyNetwork net, CyTable table) {
        List<Object> attrs;
        if (net == null || table == null) {
            throw new NullPointerException();
        }
        this.cyTables.put(net, table);
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (CyColumn col : table.getColumns()) {
            String colName = col.getName();
            if (colName.equals("SUID") || colName.equals("selected") || colName.equals("__Annotations")) continue;
            attributeNames.add(col.getName());
        }
        Collections.sort(attributeNames);
        int nAttr = attributeNames.size();
        if (this.attributeMapping.isEmpty()) {
            attrs = new ArrayList();
            this.attributeMapping.put(net, attrs);
            for (int i = 0; i < nAttr; ++i) {
                this.addNewAttribute(net, (String)attributeNames.get(i));
            }
        } else {
            int i;
            attrs = this.attributeMapping.get(net);
            if (attrs != null) {
                System.err.println("Error: this network already exist");
                return;
            }
            int nr = this.mergedAttributes.size();
            attrs = new ArrayList(nr);
            for (i = 0; i < nr; ++i) {
                attrs.add("");
            }
            this.attributeMapping.put(net, attrs);
            for (i = 0; i < nAttr; ++i) {
                String at = (String)attributeNames.get(i);
                boolean found = false;
                block4: for (int ir = 0; ir < nr; ++ir) {
                    if (((String)attrs.get(ir)).compareTo("") != 0) continue;
                    if (this.mergedAttributes.get(ir).compareTo(at) == 0) {
                        found = true;
                        this.setOriginalAttribute(net, at, ir);
                        break;
                    }
                    for (CyNetwork net_curr : this.attributeMapping.keySet()) {
                        String attr_curr = this.attributeMapping.get(net_curr).get(ir);
                        if (attr_curr.compareTo(at) != 0) continue;
                        found = true;
                        this.setOriginalAttribute(net, at, ir);
                        continue block4;
                    }
                }
                if (found) continue;
                this.addNewAttribute(net, at);
            }
        }
    }

    @Override
    public Set<CyNetwork> getNetworkSet() {
        return this.attributeMapping.keySet();
    }

    @Override
    public int getSizeNetwork() {
        return this.attributeMapping.size();
    }

    @Override
    public void removeNetwork(CyNetwork net) {
        if (net == null) {
            throw new NullPointerException();
        }
        List<String> removed = this.attributeMapping.remove(net);
        int n = removed.size();
        for (int i = n - 1; i >= 0; --i) {
            if (removed.get(i).compareTo("") == 0 || this.pack(i)) continue;
            this.resetMergedAttributeType(i, false);
            this.resetMergedAttributeMutability(i, false);
        }
    }

    protected boolean pack(int index) {
        if (index < 0 || index >= this.getSizeMergedAttributes()) {
            throw new IndexOutOfBoundsException("Index out of boundary.");
        }
        Iterator<List<String>> it = this.attributeMapping.values().iterator();
        while (it.hasNext()) {
            if (it.next().get(index).compareTo("") == 0) continue;
            return false;
        }
        this.removeMergedAttribute(index);
        return true;
    }

    private String getDefaultMergedAttrName(String attr) {
        String attr_ret;
        if (attr == null) {
            throw new NullPointerException();
        }
        Object appendix = "";
        int i = 0;
        while (this.mergedAttributes.contains(attr_ret = attr + (String)appendix)) {
            appendix = "." + ++i;
        }
        return attr + (String)appendix;
    }

    protected void addNewAttribute(CyNetwork net, String attributeName) {
        if (net == null || attributeName == null) {
            throw new NullPointerException();
        }
        Iterator<List<String>> it = this.attributeMapping.values().iterator();
        while (it.hasNext()) {
            it.next().add("");
        }
        List<String> attrs = this.attributeMapping.get(net);
        attrs.set(attrs.size() - 1, attributeName);
        String attrMerged = attributeName;
        this.mergedAttributes.add(this.getDefaultMergedAttrName(attrMerged));
        this.resetMergedAttributeType(this.mergedAttributeTypes.size(), true);
        this.resetMergedAttributeMutability(this.mergedAttributeMutability.size(), true);
    }

    protected void resetMergedAttributeType(int index, boolean add) {
        if (this.getSizeMergedAttributes() > this.mergedAttributeTypes.size() + (add ? 1 : 0)) {
            throw new IllegalStateException("column type not complete");
        }
        if (index >= this.getSizeMergedAttributes() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Map<CyNetwork, String> map = this.getOriginalAttributeMap(index);
        EnumSet<ColumnType> types = EnumSet.noneOf(ColumnType.class);
        for (Map.Entry<CyNetwork, String> entry : map.entrySet()) {
            CyTable table = this.cyTables.get(entry.getKey());
            types.add(ColumnType.getType(table.getColumn(entry.getValue())));
        }
        ColumnType type = ColumnType.getResonableCompatibleConvertionType(types);
        if (add) {
            this.mergedAttributeTypes.add(index, type);
        } else {
            ColumnType old = this.mergedAttributeTypes.get(index);
            if (!ColumnType.isConvertable(type, old)) {
                this.mergedAttributeTypes.set(index, type);
            }
        }
    }

    protected void resetMergedAttributeMutability(int index, boolean add) {
        if (this.getSizeMergedAttributes() > this.mergedAttributeMutability.size() + (add ? 1 : 0)) {
            throw new IllegalStateException("column mutability not complete");
        }
        if (index >= this.getSizeMergedAttributes() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Map<CyNetwork, String> map = this.getOriginalAttributeMap(index);
        boolean isImmutable = true;
        for (Map.Entry<CyNetwork, String> entry : map.entrySet()) {
            CyTable table = this.cyTables.get(entry.getKey());
            if (table.getColumn(entry.getValue()).isImmutable()) continue;
            isImmutable = false;
            break;
        }
        if (add) {
            this.mergedAttributeMutability.add(index, isImmutable);
        } else {
            this.mergedAttributeMutability.set(index, isImmutable);
        }
    }
}

