/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.network.merge.internal.AbstractNetworkMerge;
import org.cytoscape.network.merge.internal.model.AttributeMapping;
import org.cytoscape.network.merge.internal.model.MatchingAttribute;
import org.cytoscape.network.merge.internal.util.AttributeMerger;
import org.cytoscape.network.merge.internal.util.AttributeValueMatcher;
import org.cytoscape.network.merge.internal.util.ColumnType;
import org.cytoscape.network.merge.internal.util.DefaultAttributeValueMatcher;
import org.cytoscape.work.TaskMonitor;

public class AttributeBasedNetworkMerge
extends AbstractNetworkMerge {
    private final MatchingAttribute matchingAttribute;
    private final AttributeMapping nodeAttributeMapping;
    private final AttributeMapping edgeAttributeMapping;
    private final AttributeMapping networkAttributeMapping;
    private final AttributeValueMatcher attributeValueMatcher;
    private final AttributeMerger attributeMerger;

    public AttributeBasedNetworkMerge(MatchingAttribute matchingAttribute, AttributeMapping nodeAttributeMapping, AttributeMapping edgeAttributeMapping, AttributeMapping networkAttributeMapping, AttributeMerger attributeMerger, TaskMonitor taskMonitor) {
        this(matchingAttribute, nodeAttributeMapping, edgeAttributeMapping, networkAttributeMapping, attributeMerger, new DefaultAttributeValueMatcher(), taskMonitor);
    }

    public AttributeBasedNetworkMerge(MatchingAttribute matchingAttribute, AttributeMapping nodeAttributeMapping, AttributeMapping edgeAttributeMapping, AttributeMapping networkAttributeMapping, AttributeMerger attributeMerger, AttributeValueMatcher attributeValueMatcher, TaskMonitor taskMonitor) {
        super(taskMonitor);
        if (matchingAttribute == null || nodeAttributeMapping == null || edgeAttributeMapping == null || attributeMerger == null || attributeValueMatcher == null) {
            throw new NullPointerException();
        }
        this.matchingAttribute = matchingAttribute;
        this.nodeAttributeMapping = nodeAttributeMapping;
        this.edgeAttributeMapping = edgeAttributeMapping;
        this.networkAttributeMapping = networkAttributeMapping;
        this.attributeMerger = attributeMerger;
        this.attributeValueMatcher = attributeValueMatcher;
    }

    @Override
    protected boolean matchNode(CyNetwork net1, CyNode n1, CyNetwork net2, CyNode n2) {
        if (net1 == null || n1 == null || net2 == null || n2 == null) {
            throw new NullPointerException();
        }
        if (n1 == n2) {
            return true;
        }
        CyColumn attr1 = this.matchingAttribute.getAttributeForMatching(net1);
        CyColumn attr2 = this.matchingAttribute.getAttributeForMatching(net2);
        if (attr1 == null || attr2 == null) {
            throw new IllegalArgumentException("Please specify the matching table column first");
        }
        return this.attributeValueMatcher.matched((CyIdentifiable)n1, attr1, (CyIdentifiable)n2, attr2);
    }

    @Override
    protected void proprocess(CyNetwork toNetwork) {
        this.setAttributeTypes(toNetwork.getDefaultNodeTable(), this.nodeAttributeMapping);
        this.setAttributeTypes(toNetwork.getDefaultEdgeTable(), this.edgeAttributeMapping);
        this.setAttributeTypes(toNetwork.getDefaultNetworkTable(), this.networkAttributeMapping);
    }

    private void setAttributeTypes(CyTable table, AttributeMapping attributeMapping) {
        int n = attributeMapping.getSizeMergedAttributes();
        for (int i = 0; i < n; ++i) {
            String attr = attributeMapping.getMergedAttribute(i);
            if (table.getColumn(attr) != null) continue;
            ColumnType type = attributeMapping.getMergedAttributeType(i);
            boolean isImmutable = attributeMapping.getMergedAttributeMutability(i);
            if (type.isList()) {
                table.createListColumn(attr, type.getType(), isImmutable);
                continue;
            }
            table.createColumn(attr, type.getType(), isImmutable);
        }
    }

    @Override
    protected void mergeNetworks(List<CyNetwork> nets, CyNetwork newNetwork) {
        if (this.networkAttributeMapping == null) {
            return;
        }
        LinkedHashMap mapNetNet = new LinkedHashMap();
        for (CyNetwork net : nets) {
            mapNetNet.put(net, Collections.singleton(net));
        }
        this.setAttribute(newNetwork, newNetwork, mapNetNet, this.networkAttributeMapping);
    }

    @Override
    protected void mergeNode(Map<CyNetwork, Set<CyNode>> mapNetNode, CyNode newNode, CyNetwork newNetwork) {
        if (mapNetNode == null || mapNetNode.isEmpty()) {
            return;
        }
        this.setAttribute(newNetwork, newNode, mapNetNode, this.nodeAttributeMapping);
    }

    @Override
    public void mergeEdge(Map<CyNetwork, Set<CyEdge>> mapNetEdge, CyEdge newEdge, CyNetwork newNetwork) {
        if (mapNetEdge == null || mapNetEdge.isEmpty() || newEdge == null) {
            throw new IllegalArgumentException();
        }
        this.setAttribute(newNetwork, newEdge, mapNetEdge, this.edgeAttributeMapping);
    }

    protected <T extends CyIdentifiable> void setAttribute(CyNetwork newNetwork, T toEntry, Map<CyNetwork, Set<T>> mapNetGOs, AttributeMapping attributeMapping) {
        int nattr = attributeMapping.getSizeMergedAttributes();
        for (int i = 0; i < nattr; ++i) {
            CyColumn attr_merged = newNetwork.getRow(toEntry).getTable().getColumn(attributeMapping.getMergedAttribute(i));
            LinkedHashMap<CyIdentifiable, CyColumn> mapGOAttr = new LinkedHashMap<CyIdentifiable, CyColumn>();
            for (Map.Entry<CyNetwork, Set<T>> entryNetGOs : mapNetGOs.entrySet()) {
                CyNetwork net = entryNetGOs.getKey();
                String attrName = attributeMapping.getOriginalAttribute(net, i);
                CyTable table = attributeMapping.getCyTable(net);
                if (attrName == null) continue;
                for (CyIdentifiable idGO : entryNetGOs.getValue()) {
                    mapGOAttr.put(idGO, table.getColumn(attrName));
                }
            }
            try {
                this.attributeMerger.mergeAttribute(mapGOAttr, toEntry, attr_merged, newNetwork);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

