/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.network.merge.internal.NetworkMerge;
import org.cytoscape.work.TaskMonitor;

public abstract class AbstractNetworkMerge
implements NetworkMerge {
    protected boolean withinNetworkMerge = false;
    protected final TaskMonitor taskMonitor;
    protected Map<CyNode, Integer> mapNodesIndex;
    protected Map<String, Map<Long, Integer>> mapEdgeDirectedInteractions;
    protected Map<String, Map<Long, Integer>> mapEdgeInteractions;
    protected Map<Long, Integer> mapEdgeNoInteractions;
    protected Map<Long, Integer> mapEdgeDirectedNoInteractions;
    private volatile boolean interrupted;

    public AbstractNetworkMerge(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
        this.interrupted = false;
        this.mapNodesIndex = new HashMap<CyNode, Integer>();
        this.mapEdgeDirectedInteractions = new HashMap<String, Map<Long, Integer>>();
        this.mapEdgeInteractions = new HashMap<String, Map<Long, Integer>>();
        this.mapEdgeNoInteractions = new HashMap<Long, Integer>();
        this.mapEdgeDirectedNoInteractions = new HashMap<Long, Integer>();
    }

    public void setWithinNetworkMerge(boolean withinNetworkMerge) {
        this.withinNetworkMerge = withinNetworkMerge;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    protected abstract boolean matchNode(CyNetwork var1, CyNode var2, CyNetwork var3, CyNode var4);

    protected abstract void mergeNode(Map<CyNetwork, Set<CyNode>> var1, CyNode var2, CyNetwork var3);

    protected abstract void mergeNetworks(List<CyNetwork> var1, CyNetwork var2);

    protected abstract void mergeEdge(Map<CyNetwork, Set<CyEdge>> var1, CyEdge var2, CyNetwork var3);

    protected int matchEdge(CyNetwork network1, CyEdge e1, int position) {
        long id1;
        int index = -1;
        long id2 = 0L;
        Map<Long, Integer> mapNodesEdges = null;
        Map<Long, Integer> mapNodesDirectedEdges = null;
        if (e1 == null) {
            throw new NullPointerException();
        }
        String i1 = (String)network1.getRow((CyIdentifiable)e1).get("interaction", String.class);
        CyNode source = e1.getSource();
        CyNode target = e1.getTarget();
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        int iSource = this.mapNodesIndex.get(source);
        int iTarget = this.mapNodesIndex.get(target);
        if (e1.isDirected()) {
            mapNodesDirectedEdges = i1 == null ? this.mapEdgeDirectedNoInteractions : this.mapEdgeDirectedInteractions.get(i1);
            id1 = this.getUniqueIdNumber(iSource, iTarget);
            if (mapNodesDirectedEdges != null && mapNodesDirectedEdges.get(id1) != null) {
                index = mapNodesDirectedEdges.get(id1);
            }
        } else {
            mapNodesEdges = i1 == null ? this.mapEdgeNoInteractions : this.mapEdgeInteractions.get(i1);
            id1 = this.getUniqueIdNumber(iSource, iTarget);
            id2 = this.getUniqueIdNumber(iTarget, iSource);
            if (mapNodesEdges != null && mapNodesEdges.get(id1) != null && mapNodesEdges.get(id2) != null && mapNodesEdges.get(id1).equals(mapNodesEdges.get(id2))) {
                index = mapNodesEdges.get(id1);
            }
        }
        if (index == -1) {
            if (e1.isDirected()) {
                if (mapNodesDirectedEdges != null) {
                    mapNodesDirectedEdges.put(id1, position);
                } else {
                    mapNodesDirectedEdges = new HashMap<Long, Integer>();
                    mapNodesDirectedEdges.put(id1, position);
                    this.mapEdgeDirectedInteractions.put(i1, mapNodesDirectedEdges);
                }
            } else if (mapNodesEdges != null) {
                mapNodesEdges.put(id1, position);
                mapNodesEdges.put(id2, position);
            } else {
                mapNodesEdges = new HashMap<Long, Integer>();
                mapNodesEdges.put(id1, position);
                mapNodesEdges.put(id2, position);
                this.mapEdgeInteractions.put(i1, mapNodesEdges);
            }
        }
        return index;
    }

    private long getUniqueIdNumber(int a, int b) {
        return (long)a << 32 | (long)b;
    }

    protected abstract void proprocess(CyNetwork var1);

    @Override
    public CyNetwork mergeNetwork(CyNetwork mergedNetwork, List<CyNetwork> fromNetworks, NetworkMerge.Operation op, boolean subtractOnlyUnconnectedNodes, boolean nodesOnly) {
        if (mergedNetwork == null) {
            throw new NullPointerException("Merged networks wasn't created.");
        }
        if (fromNetworks == null) {
            throw new NullPointerException("No networks selected.");
        }
        if (op == null) {
            throw new NullPointerException("Operation parameter is missing.");
        }
        if (fromNetworks.isEmpty()) {
            throw new IllegalArgumentException("No source networks!");
        }
        this.proprocess(mergedNetwork);
        this.mapNodesIndex.clear();
        this.mapEdgeDirectedInteractions.clear();
        this.mapEdgeInteractions.clear();
        this.mapEdgeDirectedNoInteractions.clear();
        this.mapEdgeNoInteractions.clear();
        List matchedNodeList = this.getMatchedList(fromNetworks, true);
        List differenceNodeList = null;
        if (op == NetworkMerge.Operation.DIFFERENCE && subtractOnlyUnconnectedNodes) {
            differenceNodeList = matchedNodeList;
        }
        if (this.interrupted) {
            return null;
        }
        matchedNodeList = this.selectMatchedGOList(matchedNodeList, op, fromNetworks);
        HashMap differenceNodeMap = null;
        if (differenceNodeList != null) {
            differenceNodeList.removeAll(matchedNodeList);
            differenceNodeMap = new HashMap();
            for (Map mapNetNode : differenceNodeList) {
                Set nodes = mapNetNode.get(fromNetworks.get(0));
                if (nodes == null) continue;
                for (int i = 1; i < fromNetworks.size(); ++i) {
                    mapNetNode.remove(fromNetworks.get(i));
                }
                for (CyNode node : nodes) {
                    differenceNodeMap.put(node, mapNetNode);
                }
            }
        }
        HashMap<CyNode, CyNode> mapNN = new HashMap<CyNode, CyNode>();
        this.taskMonitor.setStatusMessage("Merging nodes...");
        long nNode = matchedNodeList.size();
        int i = 0;
        while ((long)i < nNode) {
            if (this.interrupted) {
                return null;
            }
            this.taskMonitor.setProgress((double)(i + 1) / (double)nNode * 0.5);
            Map<CyNetwork, Set<CyNode>> mapNetNode = matchedNodeList.get(i);
            if (mapNetNode != null && !mapNetNode.isEmpty()) {
                CyNode node = mergedNetwork.addNode();
                this.mergeNode(mapNetNode, node, mergedNetwork);
                for (Set<CyNode> nodes_ori : mapNetNode.values()) {
                    for (CyNode node_ori : nodes_ori) {
                        mapNN.put(node_ori, node);
                    }
                }
            }
            ++i;
        }
        this.taskMonitor.setStatusMessage("Merging edges...");
        List matchedEdgeList = this.getMatchedList(fromNetworks, false);
        if (this.interrupted) {
            return null;
        }
        matchedEdgeList = nodesOnly ? this.selectMatchedGOList(matchedEdgeList, NetworkMerge.Operation.UNION, fromNetworks) : this.selectMatchedGOList(matchedEdgeList, op, fromNetworks);
        double nEdge = matchedEdgeList.size();
        int i2 = 0;
        while ((double)i2 < nEdge) {
            block29: {
                CyNode target;
                CyNode source;
                CyEdge originalEdge;
                Map<CyNetwork, Set<CyEdge>> mapNetEdge;
                block31: {
                    block30: {
                        Map mapNetNode;
                        if (this.interrupted) {
                            return null;
                        }
                        this.taskMonitor.setProgress((double)(i2 + 1) / nEdge * 0.5 + 0.5);
                        mapNetEdge = matchedEdgeList.get(i2);
                        if (mapNetEdge == null || mapNetEdge.isEmpty()) break block29;
                        Iterator itEdges = mapNetEdge.values().iterator();
                        Set edgeSet = itEdges.next();
                        if (edgeSet == null || edgeSet.isEmpty()) {
                            throw new IllegalStateException("Null or empty edge set");
                        }
                        originalEdge = (CyEdge)edgeSet.iterator().next();
                        source = (CyNode)mapNN.get(originalEdge.getSource());
                        target = (CyNode)mapNN.get(originalEdge.getTarget());
                        if (differenceNodeMap == null) break block30;
                        if (source == null) {
                            CyNode originalSource = originalEdge.getSource();
                            source = mergedNetwork.addNode();
                            mapNetNode = (Map)differenceNodeMap.get(originalSource);
                            this.mergeNode(mapNetNode, source, mergedNetwork);
                            for (Set nodes : mapNetNode.values()) {
                                for (CyNode node : nodes) {
                                    mapNN.put(node, source);
                                }
                            }
                        }
                        if (target == null) {
                            CyNode originalTarget = originalEdge.getTarget();
                            target = mergedNetwork.addNode();
                            mapNetNode = (Map)differenceNodeMap.get(originalTarget);
                            this.mergeNode(mapNetNode, target, mergedNetwork);
                            for (Set nodes : mapNetNode.values()) {
                                for (CyNode node : nodes) {
                                    mapNN.put(node, target);
                                }
                            }
                        }
                        break block31;
                    }
                    if (source == null || target == null) break block29;
                }
                boolean directed = originalEdge.isDirected();
                CyEdge edge = mergedNetwork.addEdge(source, target, directed);
                this.mergeEdge(mapNetEdge, edge, mergedNetwork);
            }
            ++i2;
        }
        this.mergeNetworks(fromNetworks, mergedNetwork);
        return mergedNetwork;
    }

    private <T extends CyIdentifiable> List<Map<CyNetwork, Set<T>>> getMatchedList(List<CyNetwork> networks, boolean isNode) {
        int index = 0;
        if (networks == null) {
            throw new NullPointerException();
        }
        if (networks.isEmpty()) {
            throw new IllegalArgumentException("No merging network");
        }
        ArrayList<Map<CyNetwork, Set<T>>> matchedList = new ArrayList<Map<CyNetwork, Set<T>>>();
        int nNet = networks.size();
        for (int i = 0; i < nNet; ++i) {
            CyNetwork net1 = networks.get(i);
            List graphObjectList = isNode ? net1.getNodeList() : net1.getEdgeList();
            for (CyIdentifiable go1 : graphObjectList) {
                if (this.interrupted) {
                    return null;
                }
                boolean matched = false;
                int n = matchedList.size();
                if (isNode) {
                    for (int j = 0; j < n; ++j) {
                        Map matchedGO = (Map)matchedList.get(j);
                        block3: for (CyNetwork net2 : matchedGO.keySet()) {
                            if (!this.withinNetworkMerge && net1 == net2) continue;
                            for (CyIdentifiable go2 : (Set)matchedGO.get(net2)) {
                                matched = this.matchNode(net1, (CyNode)go1, net2, (CyNode)go2);
                                if (!matched) continue;
                                index = j;
                                this.mapNodesIndex.put((CyNode)go1, index);
                                continue block3;
                            }
                        }
                        if (!matched) {
                            continue;
                        }
                        break;
                    }
                } else {
                    index = this.matchEdge(net1, (CyEdge)go1, n);
                    matched = index >= 0 ? !((Map)matchedList.get(index)).containsKey(net1) || ((Map)matchedList.get(index)).keySet().size() != 1 || this.withinNetworkMerge : false;
                }
                if (!matched) {
                    LinkedHashMap matchedGO = new LinkedHashMap();
                    HashSet<CyIdentifiable> gos1 = new HashSet<CyIdentifiable>();
                    gos1.add(go1);
                    matchedGO.put(net1, gos1);
                    if (isNode) {
                        this.mapNodesIndex.put((CyNode)go1, n);
                    }
                    matchedList.add(matchedGO);
                    continue;
                }
                HashSet<CyIdentifiable> gos1 = (HashSet<CyIdentifiable>)((Map)matchedList.get(index)).get(net1);
                if (gos1 == null) {
                    gos1 = new HashSet<CyIdentifiable>();
                    ((Map)matchedList.get(index)).put(net1, gos1);
                }
                gos1.add(go1);
            }
        }
        return matchedList;
    }

    private <T extends CyIdentifiable> List<Map<CyNetwork, Set<T>>> selectMatchedGOList(List<Map<CyNetwork, Set<T>>> matchedGOList, NetworkMerge.Operation op, List<CyNetwork> networks) {
        if (matchedGOList == null || op == null) {
            throw new NullPointerException();
        }
        int nnet = networks.size();
        if (op == NetworkMerge.Operation.UNION) {
            return matchedGOList;
        }
        if (op == NetworkMerge.Operation.INTERSECTION) {
            ArrayList<Map<CyNetwork, Set<T>>> list = new ArrayList<Map<CyNetwork, Set<T>>>();
            for (Map<CyNetwork, Set<T>> map : matchedGOList) {
                if (map.size() != nnet) continue;
                list.add(map);
            }
            return list;
        }
        ArrayList<Map<CyNetwork, Set<T>>> list = new ArrayList<Map<CyNetwork, Set<T>>>();
        if (nnet < 2) {
            return list;
        }
        CyNetwork net1 = networks.get(0);
        CyNetwork net2 = networks.get(1);
        for (Map<CyNetwork, Set<T>> map : matchedGOList) {
            if (!map.containsKey(net1) || map.containsKey(net2)) continue;
            list.add(map);
        }
        return list;
    }
}

