/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.util.LinkedList;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;

public class NodeBetweenInfo {
    private LinkedList<CyNode> predecessors;
    private LinkedList<CyEdge> outedges;
    private long spCount;
    private int spLength;
    private double dependency;
    private double betweenness;

    public NodeBetweenInfo(long initCount, int initLength, double initBetweenness) {
        this.spCount = initCount;
        this.spLength = initLength;
        this.dependency = 0.0;
        this.betweenness = initBetweenness;
        this.predecessors = new LinkedList();
        this.outedges = new LinkedList();
    }

    public int getSPLength() {
        return this.spLength;
    }

    public long getSPCount() {
        return this.spCount;
    }

    public double getDependency() {
        return this.dependency;
    }

    public double getBetweenness() {
        return this.betweenness;
    }

    public CyNode pullPredecessor() {
        return this.predecessors.removeFirst();
    }

    public LinkedList<CyEdge> getOutEdges() {
        return this.outedges;
    }

    public boolean isEmptyPredecessors() {
        return this.predecessors.isEmpty();
    }

    public void setSPLength(int newLength) {
        this.spLength = newLength;
    }

    public void addSPCount(long newSPCount) {
        this.spCount += newSPCount;
    }

    public void addDependency(double newDependency) {
        this.dependency += newDependency;
    }

    public void addPredecessor(CyNode pred) {
        this.predecessors.add(pred);
    }

    public void addOutedge(CyEdge outedge) {
        this.outedges.add(outedge);
    }

    public void addBetweenness(double newBetweenness) {
        this.betweenness += newBetweenness;
    }

    public void reset() {
        this.spCount = 0L;
        this.spLength = -1;
        this.dependency = 0.0;
        this.predecessors = new LinkedList();
        this.outedges = new LinkedList();
    }

    public void setSource() {
        this.spCount = 1L;
        this.spLength = 0;
        this.dependency = 0.0;
        this.predecessors = new LinkedList();
        this.outedges = new LinkedList();
    }
}

