/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import org.cytoscape.analyzer.util.Msgs;

public class NetworkInterpretation {
    private boolean paired;
    private String message;
    private boolean directed;
    private boolean ignoreUSL;

    public NetworkInterpretation(String aMessage, boolean aDirected) {
        this.directed = aDirected;
        this.ignoreUSL = false;
        this.paired = false;
        this.message = "<html>" + aMessage;
    }

    public NetworkInterpretation(boolean aDirected) {
        this(aDirected ? Msgs.NI_TD : Msgs.NI_TU, aDirected);
    }

    public NetworkInterpretation(boolean aDirected, boolean aAdditional) {
        this.directed = aDirected;
        if (aDirected) {
            this.ignoreUSL = aAdditional;
            this.paired = false;
            this.message = aAdditional ? "<html>" + Msgs.NI_IGNOREUSL + "<br>" + Msgs.NI_TD : "<html>" + Msgs.NI_TD;
        } else {
            this.ignoreUSL = false;
            this.paired = aAdditional;
            this.message = aAdditional ? "<html>" + Msgs.NI_COMBPAIRED + "<br>" + Msgs.NI_TU : "<html>" + Msgs.NI_NOTCOMB + "<br>" + Msgs.NI_TU;
        }
    }

    public String getInterpretSuffix() {
        return this.directed ? Msgs.DT_DIRECTED : Msgs.DT_UNDIRECTED;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isIgnoreUSL() {
        return this.ignoreUSL;
    }

    public boolean isPaired() {
        return this.paired;
    }
}

