/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Msgs {
    private static final Map<String, String> simpleParams = new HashMap<String, String>(16);
    private static final Set<String> dirNodeAttributes;
    private static final Set<String> undirNodeAttributes;
    private static final Map<String, String> nodeAttributes;
    private static final Map<String, String> edgeAttributes;
    public static String DT_DIRECTED;
    public static String DT_UNDIRECTED;
    public static String SM_CONNECTED;
    public static String SM_CREATEVIEW;
    public static String SM_DEFFAILED;
    public static String SM_DONE;
    public static String SM_FILEEXISTS;
    public static String SM_INTERNALERROR;
    public static String SM_LOGERROR;
    public static String SM_NETWORKEMPTY;
    public static String SM_NETWORKFILEINVALID;
    public static String SM_NETWORKNOTOPENED;
    public static String SM_OUTPUTIOERROR;
    public static String SM_OUTPUTNOTCREATED;
    public static String SM_REMDUPEDGES;
    public static String SM_UNKNOWNERROR;
    public static String AC_ANALYZE;
    public static String AC_MENU_ANALYSIS;
    public static String NI_COMBPAIRED;
    public static String NI_DIRPAIRED;
    public static String NI_DIRUNPAIRED;
    public static String NI_FORCETU;
    public static String NI_IGNOREUSL;
    public static String NI_LOOPSBOTH;
    public static String NI_LOOPSDIR;
    public static String NI_LOOPSUNDIR;
    public static String NI_MIXED;
    public static String NI_NOTCOMB;
    public static String NI_PAIRED;
    public static String NI_R_DIR;
    public static String NI_R_DIRL;
    public static String NI_R_UNDIR;
    public static String NI_R_UNDIRC;
    public static String NI_TD;
    public static String NI_TU;
    public static String NI_UNDIR;
    public static String NI_UNPAIRED;

    public static boolean containsSimpleParam(String aParamID) {
        return simpleParams.containsKey(aParamID);
    }

    public static String get(String aParamID) {
        return simpleParams.get(aParamID);
    }

    public static String getAttr(String aID) {
        String attribute = nodeAttributes.get(aID);
        if (attribute == null) {
            attribute = edgeAttributes.get(aID);
        }
        return attribute;
    }

    public static Set<String> getEdgeAttributes() {
        return new HashSet<String>(edgeAttributes.values());
    }

    public static Set<String> getNodeAttributes() {
        return new HashSet<String>(nodeAttributes.values());
    }

    public static String constructLabel(String aLine1, String aLine2) {
        return "<html><b>" + aLine1 + "</b><br><br>" + aLine2 + "</html>";
    }

    static {
        simpleParams.put("networkTitle", "");
        simpleParams.put("time", "Analysis time (sec)");
        simpleParams.put("nodeCount", "Number of nodes");
        simpleParams.put("edgeCount", "Number of edges");
        simpleParams.put("density", "Network density");
        simpleParams.put("heterogeneity", "Network heterogeneity");
        simpleParams.put("centralization", "Network centralization");
        simpleParams.put("avNeighbors", "Avg. number of neighbors");
        simpleParams.put("ncc", "Connected components");
        simpleParams.put("connPairs", "Shortest paths");
        simpleParams.put("diameter", "Network diameter");
        simpleParams.put("radius", "Network radius");
        simpleParams.put("avSpl", "Characteristic path length");
        simpleParams.put("cc", "Clustering coefficient");
        simpleParams.put("nsl", "Number of self-loops");
        simpleParams.put("mnp", "Multi-edge node pairs");
        simpleParams.put("usn", "Isolated nodes");
        nodeAttributes = new HashMap<String, String>(32);
        nodeAttributes.put("spl", "Eccentricity");
        nodeAttributes.put("cco", "ClusteringCoefficient");
        nodeAttributes.put("tco", "TopologicalCoefficient");
        nodeAttributes.put("apl", "AverageShortestPathLength");
        nodeAttributes.put("clc", "ClosenessCentrality");
        nodeAttributes.put("isn", "IsSingleNode");
        nodeAttributes.put("nco", "NeighborhoodConnectivity");
        nodeAttributes.put("nde", "NumberOfDirectedEdges");
        nodeAttributes.put("nue", "NumberOfUndirectedEdges");
        nodeAttributes.put("slo", "SelfLoops");
        nodeAttributes.put("deg", "Degree");
        nodeAttributes.put("pmn", "PartnerOfMultiEdgedNodePairs");
        nodeAttributes.put("din", "Indegree");
        nodeAttributes.put("dou", "Outdegree");
        nodeAttributes.put("dal", "EdgeCount");
        nodeAttributes.put("nbt", "BetweennessCentrality");
        nodeAttributes.put("rad", "Radiality");
        nodeAttributes.put("stress", "Stress");
        dirNodeAttributes = new HashSet<String>(16);
        dirNodeAttributes.add("Eccentricity");
        dirNodeAttributes.add("AverageShortestPathLength");
        dirNodeAttributes.add("ClosenessCentrality");
        dirNodeAttributes.add("ClusteringCoefficient");
        dirNodeAttributes.add("Indegree");
        dirNodeAttributes.add("Outdegree");
        dirNodeAttributes.add("EdgeCount");
        dirNodeAttributes.add("IsSingleNode");
        dirNodeAttributes.add("SelfLoops");
        dirNodeAttributes.add("PartnerOfMultiEdgedNodePairs");
        dirNodeAttributes.add("NeighborhoodConnectivity");
        dirNodeAttributes.add("BetweennessCentrality");
        dirNodeAttributes.add("Stress");
        undirNodeAttributes = new HashSet<String>(16);
        undirNodeAttributes.add("Degree");
        undirNodeAttributes.add("NeighborhoodConnectivity");
        undirNodeAttributes.add("ClusteringCoefficient");
        undirNodeAttributes.add("TopologicalCoefficient");
        undirNodeAttributes.add("Eccentricity");
        undirNodeAttributes.add("AverageShortestPathLength");
        undirNodeAttributes.add("ClosenessCentrality");
        undirNodeAttributes.add("BetweennessCentrality");
        undirNodeAttributes.add("Stress");
        undirNodeAttributes.add("Radiality");
        undirNodeAttributes.add("SelfLoops");
        undirNodeAttributes.add("IsSingleNode");
        undirNodeAttributes.add("NumberOfUndirectedEdges");
        undirNodeAttributes.add("NumberOfDirectedEdges");
        undirNodeAttributes.add("PartnerOfMultiEdgedNodePairs");
        edgeAttributes = new HashMap<String, String>(2);
        edgeAttributes.put("ebt", "EdgeBetweenness");
        edgeAttributes.put("dpe", "NumberOfUnderlyingEdges");
        DT_DIRECTED = " (directed)";
        DT_UNDIRECTED = " (undirected)";
        SM_CONNECTED = " is connected, i.e. has a single connected component.";
        SM_CREATEVIEW = Msgs.constructLabel("No nodes are selected.", "Please create a network view and select nodes.");
        SM_DEFFAILED = "An I/O error occurred while saving the settings as default.";
        SM_DONE = "done";
        SM_FILEEXISTS = "<html>The specified file already exists.<br>Overwrite?";
        SM_INTERNALERROR = "Internal error occurred during computation.";
        SM_LOGERROR = "NetworkAnalyzer - Internal Error";
        SM_NETWORKEMPTY = "Network contains no nodes.";
        SM_NETWORKFILEINVALID = "Network file is invalid.";
        SM_NETWORKNOTOPENED = "Could not load network from file.";
        SM_OUTPUTIOERROR = "Could not save network statistics file.";
        SM_OUTPUTNOTCREATED = "Could not write to output directory.";
        SM_REMDUPEDGES = " duplicated edge(s) removed from ";
        SM_UNKNOWNERROR = "Unknown error occurred.";
        AC_ANALYZE = "Analyze Network...";
        AC_MENU_ANALYSIS = "Network Analysis[1.0]";
        NI_COMBPAIRED = "Combine paired edges.";
        NI_DIRPAIRED = "The network contains only directed edges and they are paired.";
        NI_DIRUNPAIRED = "The network contains only directed edges and they are not paired.";
        NI_FORCETU = "It will be treated as undirected.";
        NI_IGNOREUSL = "Ignore undirected self-loops.";
        NI_LOOPSBOTH = "It also contains both directed and undirected self-loops.";
        NI_LOOPSDIR = "It also contains directed self-loops.";
        NI_LOOPSUNDIR = "It also contains undirected self-loops.";
        NI_MIXED = "The network contains both directed and undirected edges.";
        NI_NOTCOMB = "Do not combine paired edges.";
        NI_PAIRED = "The directed edges are paired.";
        NI_R_DIR = "Directed.";
        NI_R_DIRL = " Undirected self-loops were ignored.";
        NI_R_UNDIR = "Undirected.";
        NI_R_UNDIRC = " Paired edges were combined.";
        NI_TD = "Treat the network as directed.";
        NI_TU = "Treat the network as undirected.";
        NI_UNDIR = "The network contains only undirected edges.";
        NI_UNPAIRED = "The directed edges are not paired.";
    }
}

