/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.cytoscape.analyzer.ConnComponentAnalyzer;
import org.cytoscape.analyzer.NetworkAnalyzer;
import org.cytoscape.analyzer.UndirNetworkAnalyzer;
import org.cytoscape.analyzer.util.CyNetworkUtils;
import org.cytoscape.analyzer.util.DegreeDistribution;
import org.cytoscape.analyzer.util.LogBinDistribution;
import org.cytoscape.analyzer.util.LongHistogram;
import org.cytoscape.analyzer.util.Msgs;
import org.cytoscape.analyzer.util.MutInteger;
import org.cytoscape.analyzer.util.NetworkStats;
import org.cytoscape.analyzer.util.PathLengthData;
import org.cytoscape.analyzer.util.Points2D;
import org.cytoscape.analyzer.util.SimpleUndirParams;
import org.cytoscape.analyzer.util.SumCountPair;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;

public class ConnectedComponentInfo
implements Comparable<ConnectedComponentInfo> {
    NetworkAnalyzer parent;
    boolean isPaired = false;
    private int size;
    protected long[] sPathLengths;
    protected long[] sharedNeighborsHist;
    protected int networkEdgeCount;
    protected SimpleUndirParams params;
    protected int maxConnectivity;
    protected DegreeDistribution degreeDist;
    protected HashMap<Integer, SumCountPair> CCps;
    protected ArrayList<Point2D.Double> topCoefs;
    protected ArrayList<Point2D.Double> closenessCent;
    protected ArrayList<Point2D.Double> nodeBetweennessArray;
    protected HashMap<Integer, SumCountPair> NCps;
    protected Map<CyNode, Double> aplMap;
    protected LogBinDistribution stressDist;
    protected double[] nodeBetweennessLean;
    protected double[] edgeBetweennessLean;
    protected long[] stressLean;
    protected int componentDiameter;
    protected CyNetwork network;
    protected NetworkStats stats = new NetworkStats();
    private CyNode node;
    private Set<CyNode> connNodes;
    final Set<CyEdge> connEdges = new HashSet<CyEdge>();
    final HashMap<CyNode, Integer> node2Int = new HashMap();
    final HashMap<Long, Integer> edgeHash2Int = new HashMap();
    int[] edgeOffsets;
    int numNodes;
    int[] edges;
    int[] edgeIDs;
    boolean paired = false;

    public ConnectedComponentInfo(NetworkAnalyzer analyzer, int aSize, CyNode aNode, boolean directed) {
        this.size = aSize;
        this.node = aNode;
        this.isPaired = !directed;
        this.parent = analyzer;
        this.sharedNeighborsHist = new long[this.size];
        this.sPathLengths = new long[this.size];
    }

    public int getSize() {
        return this.size;
    }

    public CyNode getNode() {
        return this.node;
    }

    public int nodeToInt(CyNode node) {
        return this.node2Int.get(node);
    }

    public Integer edgeToInt(Long node) {
        return this.edgeHash2Int.get(node);
    }

    public Set<CyNode> getAllNodes() {
        return this.connNodes;
    }

    public void analyze(CyNetwork net, ConnComponentAnalyzer cca) {
        int numEdges;
        this.network = net;
        this.networkEdgeCount = 0;
        this.params = new SimpleUndirParams();
        this.maxConnectivity = 0;
        this.connNodes = cca.getNodesOf(this);
        this.size = this.numNodes = this.connNodes.size();
        this.degreeDist = new DegreeDistribution(this.size);
        this.CCps = new HashMap();
        this.topCoefs = new ArrayList(this.size);
        this.closenessCent = new ArrayList(this.size);
        this.nodeBetweennessArray = new ArrayList(this.size);
        this.NCps = new HashMap();
        this.aplMap = new HashMap<CyNode, Double>();
        this.stressDist = new LogBinDistribution();
        this.edgeOffsets = new int[this.numNodes + 1];
        int numEdgesLocal = 0;
        for (CyNode node : this.connNodes) {
            this.edgeOffsets[this.node2Int.size()] = numEdgesLocal;
            this.node2Int.put(node, this.node2Int.size());
            numEdgesLocal += this.getNeighbors(node).size();
            for (CyEdge edge : this.getIncidentEdges(node, false)) {
                this.connEdges.add(edge);
            }
        }
        this.edgeOffsets[this.numNodes] = numEdges = numEdgesLocal;
        this.edges = new int[numEdges];
        this.edgeIDs = new int[numEdges];
        int e = 0;
        for (CyNode node : this.connNodes) {
            int nodeID = this.node2Int.get(node);
            int offset = this.edgeOffsets[nodeID];
            for (CyNode neighbor : this.getNeighbors(node)) {
                int edgeID;
                int neighborID = this.node2Int.get(neighbor);
                long edgeHash = ConnectedComponentInfo.computeEdgeHash(nodeID, neighborID);
                if (!this.edgeHash2Int.containsKey(edgeHash)) {
                    this.edgeHash2Int.put(edgeHash, e++);
                }
                this.edgeIDs[offset] = edgeID = this.edgeHash2Int.get(edgeHash).intValue();
                this.edges[offset++] = neighborID;
            }
        }
        LinkedList<CyNode> nodeQueue = new LinkedList<CyNode>();
        for (CyNode node : this.getAllNodes()) {
            nodeQueue.add(node);
        }
        this.run(nodeQueue, numEdges);
    }

    private void run(Queue<CyNode> nodeQueue, int numEdges) {
        int nodeID;
        int localNetworkEdgeCount = 0;
        int localMaxConnectivity = 0;
        int localComponentDiameter = 0;
        long[] localSharedNeighborsHist = new long[this.sharedNeighborsHist.length];
        long[] localSPathLengths = new long[this.sPathLengths.length];
        this.nodeBetweennessLean = new double[this.numNodes];
        this.edgeBetweennessLean = new double[numEdges];
        this.stressLean = new long[this.numNodes];
        double[] localNodeBetweenness = new double[this.nodeBetweennessLean.length];
        double[] localEdgeBetweenness = new double[this.edgeBetweennessLean.length];
        long[] localStress = new long[this.stressLean.length];
        this.componentDiameter = 0;
        while (nodeQueue.size() > 0) {
            CyNode node = null;
            if (nodeQueue.size() == 0) break;
            node = nodeQueue.remove();
            ++this.parent.progress;
            long timeStart = System.nanoTime();
            nodeID = this.nodeToInt(node);
            List<CyEdge> incEdges = this.getIncidentEdges(node, this.paired);
            Map<CyNode, MutInteger> neighborMap = CyNetworkUtils.getNeighborMap(this.parent.network, node, incEdges);
            CyRow row = this.parent.network.getRow((CyIdentifiable)node);
            int degree = this.getDegree(node, incEdges, this.paired);
            localNetworkEdgeCount += degree;
            this.degreeDist.addObservation(degree);
            row.set("Degree", (Object)degree);
            int neighborCount = this.calcSimple(node, incEdges, neighborMap, this.params);
            localMaxConnectivity = Math.max(localMaxConnectivity, neighborCount);
            int firstEdge = this.edgeOffsets[nodeID];
            int lastEdge = this.edgeOffsets[nodeID + 1];
            if (neighborCount > 0) {
                int[] neighbors = new int[lastEdge - firstEdge];
                for (int ei = firstEdge; ei < lastEdge; ++ei) {
                    neighbors[ei - firstEdge] = this.edges[ei];
                }
                double accum = 0.0;
                for (int n : neighbors) {
                    accum += (double)(this.edgeOffsets[n + 1] - this.edgeOffsets[n]);
                }
                double neighborConnect = accum / (double)neighbors.length;
                this.parent.accumulate((Map<Integer, SumCountPair>)this.NCps, neighborCount, neighborConnect);
                if (neighborCount > 1) {
                    double topCoef = UndirNetworkAnalyzer.computeTC(nodeID, this.numNodes, this.edges, this.edgeOffsets);
                    if (!Double.isNaN(topCoef)) {
                        this.topCoefs.add(new Point2D.Double(neighborCount, topCoef));
                    } else {
                        topCoef = 0.0;
                    }
                    double nodeCCp = UndirNetworkAnalyzer.computeCC(neighbors, this.numNodes, this.edges, this.edgeOffsets);
                    this.parent.accumulate((Map<Integer, SumCountPair>)this.CCps, neighborCount, nodeCCp);
                    row.set("ClusteringCoefficient", (Object)nodeCCp);
                    row.set("TopologicalCoefficient", (Object)topCoef);
                } else {
                    row.set("ClusteringCoefficient", (Object)0.0);
                    row.set("TopologicalCoefficient", (Object)0.0);
                }
                row.set("NeighborhoodConnectivity", (Object)neighborConnect);
            } else {
                row.set("NeighborhoodConnectivity", (Object)0.0);
                row.set("ClusteringCoefficient", (Object)0.0);
                row.set("TopologicalCoefficient", (Object)0.0);
            }
            if (this.parent.cancelled) break;
            PathLengthData pathLengths = UndirNetworkAnalyzer.computeSPandSN(nodeID, this.numNodes, this.edges, this.edgeOffsets, localSharedNeighborsHist, localSPathLengths);
            int eccentricity = pathLengths.getMaxLength();
            if (this.params.diameter < eccentricity) {
                this.params.diameter = eccentricity;
            }
            if (0 < eccentricity && eccentricity < this.params.radius) {
                this.params.radius = eccentricity;
            }
            localComponentDiameter = Math.max(localComponentDiameter, eccentricity);
            double apl = pathLengths.getCount() > 0 ? pathLengths.getAverageLength() : 0.0;
            this.aplMap.put(node, apl);
            double closeness = apl > 0.0 ? 1.0 / apl : 0.0;
            this.closenessCent.add(new Point2D.Double(neighborCount, closeness));
            row.set(Msgs.getAttr("spl"), (Object)eccentricity);
            row.set(Msgs.getAttr("apl"), (Object)apl);
            row.set(Msgs.getAttr("clc"), (Object)closeness);
            UndirNetworkAnalyzer.computeNBandEB(nodeID, this.numNodes, this.edges, this.edgeOffsets, this.edgeIDs, localNodeBetweenness, localStress, localEdgeBetweenness);
            if (!this.parent.cancelled) continue;
            break;
        }
        this.accumulate(localNetworkEdgeCount, localMaxConnectivity, localMaxConnectivity);
        this.accumulate(localSharedNeighborsHist, localSPathLengths, localNodeBetweenness, localEdgeBetweenness, localStress);
        this.saveStatistics();
        for (CyNode n : this.connNodes) {
            CyRow row = this.parent.network.getRow((CyIdentifiable)n);
            nodeID = this.nodeToInt(n);
            double rad = ((double)this.componentDiameter + 1.0 - this.aplMap.get(n)) / (double)this.componentDiameter;
            row.set("Radiality", (Object)rad);
            double nNormFactor = UndirNetworkAnalyzer.computeNormFactor(this.numNodes);
            double nb = this.nodeBetweennessLean[nodeID] * nNormFactor;
            if (Double.isNaN(nb)) {
                nb = 0.0;
            }
            int degree = this.getDegree(n, this.getIncidentEdges(n, this.paired), this.paired);
            this.nodeBetweennessArray.add(new Point2D.Double(degree, nb));
            row.set(Msgs.getAttr("nbt"), (Object)nb);
            long nodeStress = this.stressLean[nodeID];
            row.set("Stress", (Object)nodeStress);
            this.stressDist.addObservation(nodeStress);
        }
        for (CyEdge edge : this.connEdges) {
            int sourceID = this.nodeToInt(edge.getSource());
            int targetID = this.nodeToInt(edge.getTarget());
            long edgeHash = ConnectedComponentInfo.computeEdgeHash(sourceID, targetID);
            double eb = Double.NaN;
            if (this.edgeToInt(edgeHash) != null) {
                eb = this.edgeBetweennessLean[this.edgeToInt(edgeHash)];
            }
            if (Double.isNaN(eb)) {
                eb = 0.0;
            }
            CyRow edgeRow = this.network.getRow((CyIdentifiable)edge);
            edgeRow.set(Msgs.getAttr("ebt"), (Object)eb);
        }
    }

    private double averageNeighbors(int[] nodes, int[] edgeOffsets) {
        int neighbors = 0;
        for (int node : nodes) {
            neighbors += edgeOffsets[node + 1] - edgeOffsets[node];
        }
        return (double)neighbors / (double)nodes.length;
    }

    protected int calcSimple(CyNode aNode, List<CyEdge> aIncEdges, Map<CyNode, MutInteger> aNeMap, SimpleUndirParams aParams) {
        int neighborCount = aNeMap.size();
        if (aParams.connectivityAccum != null) {
            aParams.connectivityAccum.add(neighborCount);
        } else {
            aParams.connectivityAccum = new SumCountPair(neighborCount);
        }
        if (aParams.sqConnectivityAccum != null) {
            aParams.sqConnectivityAccum.add(neighborCount * neighborCount);
        } else {
            aParams.sqConnectivityAccum = new SumCountPair(neighborCount * neighborCount);
        }
        if (neighborCount == 0) {
            ++aParams.unconnectedNodeCount;
        }
        boolean isDirected = this.parent.isDirected();
        int selfLoops = 0;
        int dirEdges = 0;
        for (int j = 0; j < aIncEdges.size(); ++j) {
            CyEdge e = aIncEdges.get(j);
            if (isDirected && e.isDirected()) {
                ++dirEdges;
            }
            if (e.getSource() != e.getTarget()) continue;
            ++selfLoops;
        }
        aParams.selfLoopCount += selfLoops;
        int undirEdges = aIncEdges.size() - dirEdges;
        int partnerOfMultiEdgeNodePairs = 0;
        for (MutInteger freq : aNeMap.values()) {
            if (freq.value <= 1) continue;
            ++partnerOfMultiEdgeNodePairs;
        }
        aParams.multiEdgePartners += partnerOfMultiEdgeNodePairs;
        CyRow nodeRow = this.network.getRow((CyIdentifiable)aNode);
        nodeRow.set(Msgs.getAttr("slo"), (Object)selfLoops);
        nodeRow.set(Msgs.getAttr("isn"), (Object)(neighborCount == 0 ? 1 : 0));
        nodeRow.set(Msgs.getAttr("nue"), (Object)undirEdges);
        nodeRow.set(Msgs.getAttr("nde"), (Object)dirEdges);
        nodeRow.set(Msgs.getAttr("pmn"), (Object)partnerOfMultiEdgeNodePairs);
        return neighborCount;
    }

    protected Set<CyNode> getNeighbors(CyNode aNode) {
        return CyNetworkUtils.getNeighbors(this.network, aNode, this.getIncidentEdges(aNode, false));
    }

    public List<CyEdge> getIncidentEdges(CyNode aNode, boolean paired) {
        return this.network.getAdjacentEdgeList(aNode, paired ? CyEdge.Type.INCOMING : CyEdge.Type.ANY);
    }

    public static long computeEdgeHash(int id1, int id2) {
        int smaller = id1 < id2 ? id1 : id2;
        int bigger = id1 > id2 ? id1 : id2;
        return ((long)smaller << 32) + (long)bigger;
    }

    protected static Set<Point2D.Double> getAverages(Map<Integer, SumCountPair> pAccumulatedValues) {
        HashSet<Point2D.Double> averages = new HashSet<Point2D.Double>(pAccumulatedValues.size());
        for (Integer x : pAccumulatedValues.keySet()) {
            double y = pAccumulatedValues.get(x).getAverage();
            averages.add(new Point2D.Double(x.doubleValue(), y));
        }
        return averages;
    }

    int getDegree(CyNode aNode, List<CyEdge> aIncEdges, boolean isPaired) {
        int degree = aIncEdges.size();
        for (int i = 0; i < aIncEdges.size(); ++i) {
            CyEdge e = aIncEdges.get(i);
            if (e.getSource() != e.getTarget() || e.isDirected() && isPaired) continue;
            ++degree;
        }
        return degree;
    }

    public void accumulate(int localNetworkEdgeCount, int localMaxConnectivity, int localMaxConnectivity2) {
        this.networkEdgeCount += localNetworkEdgeCount;
        this.maxConnectivity = Math.max(this.maxConnectivity, localMaxConnectivity);
        this.componentDiameter = Math.max(this.componentDiameter, localMaxConnectivity);
    }

    public void accumulate(long[] sharedNeighbors, long[] pathLens, double[] nodeBetweenness, double[] edgeBetweenness, long[] stress) {
        int i;
        for (i = 0; i < sharedNeighbors.length; ++i) {
            int n = i;
            this.sharedNeighborsHist[n] = this.sharedNeighborsHist[n] + sharedNeighbors[i];
        }
        for (i = 0; i < pathLens.length; ++i) {
            int n = i;
            this.sPathLengths[n] = this.sPathLengths[n] + pathLens[i];
        }
        for (i = 0; i < nodeBetweenness.length; ++i) {
            int n = i;
            this.nodeBetweennessLean[n] = this.nodeBetweennessLean[n] + nodeBetweenness[i];
        }
        for (i = 0; i < edgeBetweenness.length; ++i) {
            int n = i;
            this.edgeBetweennessLean[n] = this.edgeBetweennessLean[n] + edgeBetweenness[i];
        }
        for (i = 0; i < stress.length; ++i) {
            int n = i;
            this.stressLean[n] = this.stressLean[n] + stress[i];
        }
    }

    void saveStatistics() {
        if (this.params.connectivityAccum != null) {
            double meanConnectivity = this.params.connectivityAccum.getAverage();
            this.stats.set("avNeighbors", meanConnectivity);
            double density = meanConnectivity / (double)(this.numNodes - 1);
            this.stats.set("density", meanConnectivity / (double)(this.numNodes - 1));
            this.stats.set("centralization", (double)this.numNodes / ((double)this.numNodes - 2.0) * ((double)this.maxConnectivity / ((double)this.numNodes - 1.0) - density));
            double nom = this.params.sqConnectivityAccum.getSum() * (double)this.numNodes;
            double denom = this.params.connectivityAccum.getSum() * this.params.connectivityAccum.getSum();
            this.stats.set("heterogeneity", Math.sqrt(nom / denom - 1.0));
        }
        this.stats.set("degreeDist", this.degreeDist.createHistogram());
        if (this.CCps.size() > 0) {
            Point2D.Double[] averages = new Point2D.Double[this.CCps.size()];
            double cc = this.parent.accumulateCCs(this.CCps, averages) / (double)this.numNodes;
            this.stats.set("cc", cc);
            if (averages.length > 1) {
                this.stats.set("cksDist", new Points2D(averages));
            }
        }
        if (this.topCoefs.size() > 1) {
            this.stats.set("topCoefs", new Points2D(this.topCoefs));
        }
        this.stats.set(Msgs.get("usn"), this.params.unconnectedNodeCount);
        this.stats.set(Msgs.get("nsl"), this.params.selfLoopCount);
        this.stats.set(Msgs.get("mnp"), this.params.multiEdgePartners / 2);
        if (this.isPaired) {
            this.stats.set("edgeCount", this.networkEdgeCount / 2);
        }
        long connPairs = 0L;
        long totalPathLength = 0L;
        for (int i = 1; i <= this.params.diameter; ++i) {
            connPairs += this.sPathLengths[i];
            totalPathLength += (long)i * this.sPathLengths[i];
        }
        this.stats.set("connPairs", connPairs);
        if (this.params.diameter > 0) {
            this.stats.set("diameter", this.params.diameter);
            this.stats.set("radius", this.params.radius);
            this.stats.set("avSpl", (double)totalPathLength / (double)connPairs);
            if (this.params.diameter > 1) {
                this.stats.set("splDist", new LongHistogram(this.sPathLengths, 1, this.params.diameter));
            }
            int largestCommN = 0;
            for (int i = 1; i < this.numNodes; ++i) {
                if (this.sharedNeighborsHist[i] == 0L) continue;
                int n = i;
                this.sharedNeighborsHist[n] = this.sharedNeighborsHist[n] / 2L;
                largestCommN = i;
            }
            if (largestCommN > 0) {
                this.stats.set("commNeighbors", new LongHistogram(this.sharedNeighborsHist, 1, largestCommN));
            }
        }
        if (this.closenessCent.size() > 1) {
            this.stats.set("closenessCent", new Points2D(this.closenessCent));
        }
        if (this.nodeBetweennessArray.size() > 2) {
            this.stats.set("nodeBetween", new Points2D(this.nodeBetweennessArray));
        }
        if (this.NCps.size() > 1) {
            this.stats.set("neighborConn", new Points2D(ConnectedComponentInfo.getAverages(this.NCps)));
        }
        this.stats.set("stressDist", this.stressDist.createPoints2D());
    }

    @Override
    public int compareTo(ConnectedComponentInfo o) {
        return Integer.valueOf(this.getSize()).compareTo(o.getSize());
    }

    public NetworkStats getStats() {
        return this.stats;
    }
}

