/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import org.cytoscape.analyzer.util.Msgs;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;

public final class AttributeSetup {
    private AttributeSetup() {
    }

    public static void createDirectedNodeAttributes(CyTable nodeTable) {
        AttributeSetup.createCommonNodeAttributes(nodeTable);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("dal"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("din"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("dou"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("nbt"), Double.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("nco"), Double.class);
    }

    public static void createUndirectedNodeAttributes(CyTable nodeTable) {
        AttributeSetup.createCommonNodeAttributes(nodeTable);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("deg"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("nbt"), Double.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("nco"), Double.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("nde"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("nue"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("rad"), Double.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("tco"), Double.class);
    }

    private static void createCommonNodeAttributes(CyTable nodeTable) {
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("apl"), Double.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("cco"), Double.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("clc"), Double.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("isn"), Boolean.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("pmn"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("slo"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("spl"), Integer.class);
        AttributeSetup.createAttr(nodeTable, Msgs.getAttr("stress"), Long.class);
    }

    public static void createEdgeBetweennessAttribute(CyTable edgeTable) {
        AttributeSetup.createAttr(edgeTable, Msgs.getAttr("ebt"), Double.class);
    }

    public static void createEdgeDuplicateAttribute(CyTable edgeTable) {
        AttributeSetup.createAttr(edgeTable, Msgs.getAttr("dpe"), Integer.class);
    }

    private static void createAttr(CyTable table, String col, Class<?> newType) {
        CyColumn column = table.getColumn(col);
        if (column != null) {
            if (column.getType() == newType) {
                return;
            }
            throw new IllegalArgumentException("trying to set table column: " + col + " to type: " + newType.getName() + " when it already  has a type of: " + column.getType().getName());
        }
        table.createColumn(col, newType, false);
    }
}

