/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.analyzer.util.CyNetworkUtils;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveSelfLoopsTask
extends AbstractTask
implements ObservableTask {
    private static final Logger logger = LoggerFactory.getLogger(RemoveSelfLoopsTask.class);
    public static String SM_REMSELFLOOPS = " self-loop(s) removed from ";
    @Tunable(description="Network to remove the self loops from", required=true)
    public CyNetwork network;
    private String[] networkNames;
    private int[] removedLoops;

    public void run(TaskMonitor taskMonitor) {
        this.networkNames = new String[1];
        this.removedLoops = new int[1];
        if (this.network != null) {
            this.removedLoops[0] = CyNetworkUtils.removeSelfLoops(this.network);
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        String r = this.constructReport(this.removedLoops, SM_REMSELFLOOPS, this.networkNames);
        if (type.isAssignableFrom(JSONResult.class)) {
            JSONResult res = () -> {
                String str = "{\"network\":" + this.network.getSUID() + ",";
                str = str + "\"removed\":" + this.removedLoops[0] + "}";
                return str;
            };
            return (R)res;
        }
        return (R)r;
    }

    private String constructReport(int[] removedLoops, String s, String[] networkNames) {
        Object report = "";
        for (int index = 0; index < removedLoops.length; ++index) {
            report = (String)report + removedLoops[index] + s + networkNames[index] + "\n";
        }
        return report;
    }
}

