/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.analyzer.util.CyNetworkUtils;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDupEdgesTask
extends AbstractTask
implements ObservableTask {
    private static final Logger logger = LoggerFactory.getLogger(RemoveDupEdgesTask.class);
    @Tunable(description="Network to remove the duplicate edges from", required=true)
    public CyNetwork network;
    @Tunable(description="Ignore edge direction")
    public boolean ignoreDirection = false;
    @Tunable(description="Create column with number of duplicated edges")
    public boolean createColumn = false;
    private String[] networkNames;
    private int[] removedLoops;
    public static String SM_REMDUPEDGES = " edges removed from ";

    public void run(TaskMonitor taskMonitor) {
        this.networkNames = new String[1];
        this.removedLoops = new int[1];
        if (this.network != null) {
            this.networkNames[0] = (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class);
            this.removedLoops[0] = CyNetworkUtils.removeDuplEdges(this.network, this.ignoreDirection, this.createColumn);
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        String r = this.constructReport(this.removedLoops, SM_REMDUPEDGES, this.networkNames);
        if (type.isAssignableFrom(JSONResult.class)) {
            JSONResult res = () -> {
                String str = "{\"network\":" + this.network.getSUID() + ",";
                str = str + "\"removed\":" + this.removedLoops[0] + "}";
                return str;
            };
            return (R)res;
        }
        return (R)r;
    }

    private String constructReport(int[] removedLoops, String s, String[] networkNames) {
        Object report = "";
        for (int index = 0; index < removedLoops.length; ++index) {
            report = (String)report + removedLoops[index] + s + networkNames[index] + "\n";
        }
        return report;
    }
}

