/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import org.cytoscape.analyzer.tasks.ClearMultEdgesDialog;
import org.cytoscape.analyzer.tasks.NetAnalyzerAction;
import org.cytoscape.analyzer.tasks.Utils;
import org.cytoscape.analyzer.util.CyNetworkUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDupEdgesAction
extends NetAnalyzerAction {
    private static final long serialVersionUID = -7465036491341908005L;
    private static final Logger logger = LoggerFactory.getLogger(RemoveDupEdgesAction.class);
    private final CyNetworkManager netMgr;
    CySwingApplication desktop;
    public static String DI_REMOVESL = "Remove duplicate edges from the following networks:";
    public static String AC_REMDUPEDGES = "Remove Duplicate Edges...";
    public static String SM_REMDUPEDGES = " edges removed from ";
    public static String SM_LOGERROR = "NetworkAnalyzer - Internal Error";
    public static String DT_REMDUPEDGES = "Remove Duplicate Edges";

    public RemoveDupEdgesAction(CyApplicationManager appMgr, CySwingApplication swingApp, CyNetworkManager netMgr) {
        super(AC_REMDUPEDGES, appMgr);
        this.setPreferredMenu("Edit");
        this.setMenuGravity(4.2f);
        this.netMgr = netMgr;
        this.desktop = swingApp;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (!this.selectNetwork()) {
                return;
            }
            JFrame frame = this.desktop.getJFrame();
            Object helpURL = null;
            ClearMultEdgesDialog d = new ClearMultEdgesDialog((Frame)frame, this.netMgr);
            d.setVisible(true);
            boolean ignoreDir = d.getIgnoreDirection();
            boolean createEdgeAttr = d.getCreateEdgeAttr();
            CyNetwork[] networks = d.getSelectedNetworks();
            if (networks != null) {
                int size = networks.length;
                int[] removedLoops = new int[size];
                String[] networkNames = new String[size];
                for (int i = 0; i < size; ++i) {
                    CyNetwork currentNet = networks[i];
                    networkNames[i] = (String)currentNet.getRow((CyIdentifiable)currentNet).get("name", String.class);
                    removedLoops[i] = CyNetworkUtils.removeDuplEdges(currentNet, ignoreDir, createEdgeAttr);
                }
                String r = this.constructReport(removedLoops, SM_REMDUPEDGES, networkNames);
                Utils.showInfoBox(frame, DT_REMDUPEDGES, r);
            }
        }
        catch (Exception ex) {
            logger.error(SM_LOGERROR, (Throwable)ex);
        }
    }

    private String constructReport(int[] removedLoops, String s, String[] networkNames) {
        Object report = "";
        for (int index = 0; index < removedLoops.length; ++index) {
            report = (String)report + removedLoops[index] + s + networkNames[index] + "\n";
        }
        return report;
    }
}

