/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import org.cytoscape.analyzer.tasks.NetworkListDialog;
import org.cytoscape.analyzer.tasks.Utils;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class NetModificationDialog
extends NetworkListDialog {
    public static String SM_NETMODIFICATION = "<html><b>Note:</b> This operation cannot be undone.</html>";
    private static final long serialVersionUID = 1576652348409963833L;
    private JButton btnCancel;
    private JButton btnOK;
    private String helpURL;
    private CyNetwork[] selectedNetworks;

    public NetModificationDialog(Frame aOwner, String aTitle, String aLabel, String aHelpURL, CyNetworkManager netMgr) throws HeadlessException {
        this(aOwner, aTitle, aLabel, aHelpURL, true, netMgr);
    }

    public NetModificationDialog(Frame aOwner, String aTitle, String aLabel, String aHelpURL, boolean aWarning, CyNetworkManager netMgr) throws HeadlessException {
        super(aOwner, aTitle, netMgr);
        this.helpURL = aHelpURL;
        this.selectedNetworks = null;
        this.initControls(aLabel, aWarning);
        this.pack();
        this.setLocationRelativeTo(aOwner);
    }

    public CyNetwork[] getSelectedNetworks() {
        return this.selectedNetworks;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.btnOK.getAction().setEnabled(this.isNetNameSelected());
    }

    protected JComponent initAdditionalControls() {
        return null;
    }

    protected void initControls(String title, boolean showWarning) {
        JLabel titleLbl = new JLabel(title);
        JLabel warningLbl = new JLabel(SM_NETMODIFICATION, 10);
        warningLbl.setFont(warningLbl.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        warningLbl.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        warningLbl.setVisible(showWarning);
        JScrollPane networkListScr = new JScrollPane(this.listNetNames);
        networkListScr.setMinimumSize(new Dimension(80, 120));
        JComponent additionalControls = this.initAdditionalControls();
        if (additionalControls == null) {
            additionalControls = new JPanel();
            additionalControls.setVisible(false);
        }
        this.btnOK = Utils.createButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = NetModificationDialog.this.listNetNames.getSelectedIndices();
                int size = indices.length;
                NetModificationDialog.this.selectedNetworks = new CyNetwork[size];
                for (int i = 0; i < size; ++i) {
                    NetModificationDialog.this.selectedNetworks[i] = (CyNetwork)NetModificationDialog.this.networks.get(indices[i]);
                }
                NetModificationDialog.this.setVisible(false);
                NetModificationDialog.this.dispose();
            }
        }, null);
        this.btnCancel = Utils.createButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetModificationDialog.this.setVisible(false);
                NetModificationDialog.this.dispose();
            }
        }, null);
        Utils.equalizeSize(this.btnOK, this.btnCancel);
        this.btnOK.getAction().setEnabled(false);
        JPanel buttonPnl = LookAndFeelUtil.createOkCancelPanel((JButton)this.btnOK, (JButton)this.btnCancel);
        JPanel contentPane = new JPanel();
        GroupLayout layout = new GroupLayout(contentPane);
        contentPane.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(titleLbl).addComponent(networkListScr, -1, -1, Short.MAX_VALUE).addComponent(additionalControls).addComponent(warningLbl).addComponent(buttonPnl));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(titleLbl, -2, -1, -2).addComponent(networkListScr, -1, -1, Short.MAX_VALUE).addComponent(additionalControls, -1, -1, Short.MAX_VALUE).addComponent(warningLbl, -2, -1, -2).addComponent(buttonPnl, -2, -1, -2));
        this.setContentPane(contentPane);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.btnOK.getAction(), (Action)this.btnCancel.getAction());
        this.getRootPane().setDefaultButton(this.btnOK);
    }
}

