/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.analyzer.AnalyzerManager;
import org.cytoscape.analyzer.DirNetworkAnalyzer;
import org.cytoscape.analyzer.NetworkAnalyzer;
import org.cytoscape.analyzer.UndirNetworkAnalyzer;
import org.cytoscape.analyzer.util.CyNetworkUtils;
import org.cytoscape.analyzer.util.NetworkInspection;
import org.cytoscape.analyzer.util.NetworkInterpretation;
import org.cytoscape.analyzer.util.NetworkStatus;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.command.StringToModel;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.json.JSONResult;

public class AnalyzeNetworkTask
extends AbstractTask
implements TunableValidator,
ObservableTask {
    @Tunable(description="Network to analyze?", context="nogui", exampleStringValue="current", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.")
    public String network = null;
    @Tunable(description="Analyze as Directed Graph?")
    public Boolean directed = false;
    @Tunable(description="Analyze only selected nodes?", context="nogui")
    public Boolean selectedOnly = false;
    final CyServiceRegistrar registrar;
    final CySwingApplication desktop;
    final CyApplicationManager appMgr;
    private NetworkAnalyzer analyzer;
    final AnalyzerManager manager;
    final StringToModel stringToModel;
    final Collection<CyNetwork> networks;

    public AnalyzeNetworkTask(Collection<CyNetwork> networks, CyServiceRegistrar reg, CySwingApplication app, AnalyzerManager mgr) {
        this.networks = networks;
        this.desktop = app;
        this.registrar = reg;
        this.manager = mgr;
        this.appMgr = (CyApplicationManager)reg.getService(CyApplicationManager.class);
        this.stringToModel = (StringToModel)reg.getService(StringToModel.class);
        if (networks != null) {
            this.directed = this.anyDirected(networks);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        double processed = 0.0;
        Collection<CyNetwork> nets = this.networks;
        if (nets == null) {
            nets = new ArrayList<CyNetwork>();
            if (this.network == null) {
                nets.add(this.appMgr.getCurrentNetwork());
            } else {
                nets.add(this.stringToModel.getNetwork(this.network));
            }
        }
        double increment = 1.0 / (double)nets.size();
        taskMonitor.setProgress(processed);
        taskMonitor.setTitle("Analyzing Networks");
        for (CyNetwork network : nets) {
            taskMonitor.setStatusMessage("Analyzing Network: " + (String)network.getRow((CyIdentifiable)network).get("name", String.class));
            HashSet<CyNode> selectedNodes = new HashSet<CyNode>();
            Collection matched = this.selectedOnly != false ? network.getDefaultNodeTable().getMatchingRows("selected", (Object)true) : network.getDefaultNodeTable().getAllRows();
            for (CyRow row : matched) {
                selectedNodes.add(network.getNode(((Long)row.get("SUID", Long.class)).longValue()));
            }
            this.analyze(network, selectedNodes);
            taskMonitor.setProgress(processed += increment);
        }
    }

    private void analyze(CyNetwork network, Set<CyNode> nodes) {
        NetworkInspection status = CyNetworkUtils.inspectNetwork(network);
        NetworkInterpretation interpr = this.interpretNetwork(status);
        if (interpr == null && this.directed.booleanValue()) {
            throw new NullPointerException("Analyze as direct graph is not applicable. Try to analzye as undirected graph");
        }
        if (interpr == null) {
            throw new NullPointerException("NetworkInterpretation is null.");
        }
        if (nodes.size() < 4) {
            throw new IllegalArgumentException("Network too small: 4 node minimum.");
        }
        this.analyzer = this.directed != false ? new DirNetworkAnalyzer(network, nodes, interpr, this.desktop, this.manager) : new UndirNetworkAnalyzer(network, interpr, this.desktop, this.manager);
        this.analyzer.computeAll();
    }

    private final NetworkInterpretation interpretNetwork(NetworkInspection aInsp) {
        NetworkInterpretation[] interpretations;
        NetworkStatus status = NetworkStatus.getStatus(aInsp);
        for (NetworkInterpretation ni : interpretations = status.getInterpretations()) {
            if (this.directed.booleanValue() != ni.isDirected()) continue;
            return ni;
        }
        return null;
    }

    private Boolean anyDirected(Collection<CyNetwork> networks) {
        for (CyNetwork net : networks) {
            if (!this.isDirected(net)) continue;
            return true;
        }
        return false;
    }

    private boolean isDirected(CyNetwork net) {
        CyNetworkView view = ((CyApplicationManager)this.registrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        ArrowShape arrow = (ArrowShape)view.getVisualProperty(BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE);
        return arrow != null && arrow != ArrowShapeVisualProperty.NONE;
    }

    public <R> R getResults(Class<? extends R> type) {
        String response = this.analyzer.getStats().jsonOutput();
        if (type.equals(String.class)) {
            return (R)this.analyzer.getStats().toString();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> this.analyzer.getStats().jsonOutput();
            return (R)res;
        }
        return null;
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        return TunableValidator.ValidationState.OK;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }
}

