/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.cytoscape.analyzer.AnalyzerManager;
import org.cytoscape.analyzer.util.EasyGBC;
import org.cytoscape.analyzer.util.IconUtil;
import org.cytoscape.analyzer.util.Msgs;
import org.cytoscape.analyzer.util.NetworkStats;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;

public class ResultsPanel
extends JPanel
implements CytoPanelComponent2,
ActionListener,
SetCurrentNetworkListener {
    private static final long serialVersionUID = 1L;
    final AnalyzerManager manager;
    final CyApplicationManager appManager;
    private Icon icon;
    private JLabel networkName;
    private JLabel label;
    private JButton degreeHisto;
    private JButton betweenScatter;
    private JPanel mainPanel;
    private EasyGBC mainPanelGBC;
    private Font labelFont;
    private Font textFont;
    private CyNetwork network;
    final String HEADER_TITLE = "Summary Statistics";

    public ResultsPanel(AnalyzerManager manager) {
        this.manager = manager;
        this.appManager = manager.getService(CyApplicationManager.class);
        this.network = this.appManager.getCurrentNetwork();
        this.labelFont = new Font("SansSerif", 1, 10);
        this.textFont = new Font("SansSerif", 0, 10);
        this.createGraphButtons();
        this.setLayout(new FlowLayout());
        EasyGBC c = new EasyGBC();
        c.insets(2, 5, 2, 5);
        String name = "Blank";
        if (this.network != null) {
            name = (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class);
        }
        this.networkName = new JLabel(name);
        this.networkName.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.networkName.setHorizontalAlignment(0);
        this.networkName.setFont(this.labelFont.deriveFont(12.0f));
        this.add((Component)this.networkName, c.down().anchor("west").expandHoriz());
        this.mainPanel = new JPanel(new FlowLayout());
        this.mainPanelGBC = new EasyGBC();
        JScrollPane scrollPane = new JScrollPane(this.mainPanel, 20, 31);
        scrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, UIManager.getColor("Separator.foreground")));
        scrollPane.setBackground(this.getBackground());
        this.add((Component)scrollPane, c.insets(5, 5, 0, 5).down().anchor("west").expandBoth());
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.label.setBackground(this.getBackground());
        this.mainPanel.add((Component)this.label, this.mainPanelGBC.anchor("west").expandHoriz());
        JLabel info1 = new JLabel("- Node specific statistics are found in the Node Table");
        info1.setVisible(true);
        info1.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{info1});
        this.add((Component)info1, c.down().anchor("west").expandHoriz());
        JLabel info2 = new JLabel("- Edge Betweenness is added to the Edge Table");
        info2.setVisible(true);
        info2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{info2});
        this.add((Component)info2, c.down().anchor("west").expandHoriz());
        JPanel buttonBox = new JPanel();
        buttonBox.setLayout(new BoxLayout(buttonBox, 3));
        this.degreeHisto.setAlignmentX(0.5f);
        this.betweenScatter.setAlignmentX(0.5f);
        buttonBox.add(this.degreeHisto);
        buttonBox.add(this.betweenScatter);
        this.add((Component)buttonBox, c.down().expandHoriz());
        this.revalidate();
        this.repaint();
    }

    public String getIdentifier() {
        return "org.cytoscape.analyzer.ResultsPanel";
    }

    public void handleEvent(SetCurrentNetworkEvent scne) {
        this.network = scne.getNetwork();
        NetworkStats st = null;
        String stats = "No Network Selected";
        this.updateHeader(st);
        this.enableButtons(this.network != null);
        if (this.network != null) {
            if (this.network.getNodeCount() < 1 || this.network.getEdgeCount() < 1) {
                stats = "Empty Network";
                this.enableButtons(false);
            } else {
                CyTable hiddenTable = this.network.getTable(CyNetwork.class, "HIDDEN");
                stats = (String)hiddenTable.getRow((Object)this.network.getSUID()).get("statistics", String.class);
                st = this.parseJson(stats);
            }
            if (st == null && stats == null) {
                stats = "<html><body><p style='text-align:center'>Tools &rarr; Analyze Network<br/>to calculate statistics</p></body></html>";
            }
        }
        if (st == null) {
            this.setResultString(stats);
        } else {
            this.setResults(st);
        }
    }

    public void enableButtons(boolean b) {
        this.degreeHisto.setEnabled(b);
        this.betweenScatter.setEnabled(b);
    }

    private NetworkStats parseJson(String stats) {
        if (stats == null || !stats.startsWith("{")) {
            return null;
        }
        NetworkStats st = new NetworkStats(stats);
        return st;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.EAST;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new TextIcon("a", IconUtil.getIconFont(15.0f), 16, 16);
        }
        return this.icon;
    }

    public String getTitle() {
        return "Analyzer";
    }

    private void updateHeader(NetworkStats stats) {
        String name = stats != null ? (String)stats.get("networkTitle") : (this.network != null ? (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class) : "No Network Selected");
        this.networkName.setText(name);
    }

    private void createGraphButtons() {
        this.degreeHisto = new JButton("Node Degree Distribution");
        this.betweenScatter = new JButton("Betweenness by Degree");
        this.enableButtons(false);
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.degreeHisto, this.betweenScatter});
        this.degreeHisto.setFont(this.labelFont);
        this.betweenScatter.setFont(this.labelFont);
        this.degreeHisto.addActionListener(evt -> this.manager.makeDegreeHisto());
        this.betweenScatter.addActionListener(evt -> this.manager.makeBetweenScatter());
    }

    private String addLine(String key, Object val) {
        String strVal = null;
        if (val instanceof String) {
            strVal = (String)val;
        } else if (val instanceof Double) {
            strVal = String.format("%8.3f", val);
        } else if (val instanceof Integer) {
            strVal = String.format("%3d", val);
        }
        String keyLabel = key + ": " + strVal + "  \n";
        return keyLabel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command;
        switch (command = event.getActionCommand()) {
            default: 
        }
    }

    public void setResults(NetworkStats stats) {
        String[] keys;
        this.updateHeader(stats);
        this.mainPanel.removeAll();
        this.mainPanelGBC.reset();
        JPanel statsPanel = new JPanel(new FlowLayout());
        StringBuilder allStatsBuilder = new StringBuilder("Summary Statistics  \n");
        for (String key : keys = stats.getKeys()) {
            Object val = stats.get(key);
            String s = Msgs.get(key);
            if (val == null || key.equals("networkTitle")) continue;
            allStatsBuilder.append(this.addLine(s, val));
        }
        this.mainPanel.add((Component)statsPanel, this.mainPanelGBC.insets(10, 5, 5, 5).anchor("northwest").expandHoriz());
        String allStats = allStatsBuilder.toString();
        JTextArea allStatsLabel = new JTextArea(allStats);
        allStatsLabel.setFont(this.labelFont);
        allStatsLabel.setEditable(false);
        statsPanel.add(allStatsLabel);
        this.mainPanel.add((Component)new JLabel(), this.mainPanelGBC.anchor("west").expandBoth());
        this.enableButtons(true);
        this.revalidate();
        this.repaint();
    }

    public void setResultString(String out) {
        this.mainPanel.removeAll();
        this.mainPanelGBC.reset();
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.label.setBackground(this.getBackground());
        this.label.setText(out);
        this.label.setOpaque(true);
        this.mainPanel.add((Component)this.label, this.mainPanelGBC.anchor("west").expandBoth());
        this.revalidate();
        this.repaint();
    }
}

