/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.analyzer.AnalyzerManager;
import org.cytoscape.analyzer.ConnComponentAnalyzer;
import org.cytoscape.analyzer.NetworkAnalyzer;
import org.cytoscape.analyzer.util.AttributeSetup;
import org.cytoscape.analyzer.util.ConnectedComponentInfo;
import org.cytoscape.analyzer.util.CyNetworkUtils;
import org.cytoscape.analyzer.util.DegreeDistribution;
import org.cytoscape.analyzer.util.LogBinDistribution;
import org.cytoscape.analyzer.util.LongHistogram;
import org.cytoscape.analyzer.util.Msgs;
import org.cytoscape.analyzer.util.MutInteger;
import org.cytoscape.analyzer.util.NetworkInterpretation;
import org.cytoscape.analyzer.util.NodeBetweenInfo;
import org.cytoscape.analyzer.util.PathLengthData;
import org.cytoscape.analyzer.util.Points2D;
import org.cytoscape.analyzer.util.SumCountPair;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;

public class DirNetworkAnalyzer
extends NetworkAnalyzer {
    private int diameter;
    private int radius;
    private long[] sPathLengths;
    private int nodeCount;
    private boolean useNodeAttributes;
    private boolean useEdgeAttributes;
    private int roundingDigits;
    private int numberOfIsolatedNodes;
    private int numberOfSelfLoops;
    private int multiEdgePartners;
    private boolean computeNB;
    private Map<CyNode, NodeBetweenInfo> nodeBetweenness;
    private Map<CyEdge, Double> edgeBetweenness;
    private Map<CyNode, Long> stress;
    DegreeDistribution inDegreeDist;
    DegreeDistribution outDegreeDist;
    SumCountPair neighborsAccum;
    HashMap<Integer, SumCountPair> ioNCps;
    HashMap<Integer, SumCountPair> inNCps;
    HashMap<Integer, SumCountPair> outNCps;
    HashMap<Integer, SumCountPair> CCps;
    ArrayList<Point2D.Double> closenessCent;
    ArrayList<Point2D.Double> nodeBetweennessArray;
    Map<CyNode, Double> aplMap;
    LogBinDistribution stressDist;
    long outNeighbors;
    double[] nodeBetweennessLean;
    double[] edgeBetweennessLean;
    long[] stressLean;

    @Override
    public boolean isDirected() {
        return true;
    }

    public DirNetworkAnalyzer(CyNetwork aNetwork, Set<CyNode> aNodeSet, NetworkInterpretation aInterpr, CySwingApplication app, AnalyzerManager mgr) {
        super(aNetwork, aInterpr, app, mgr);
        this.nodeCount = this.stats.getInt("nodeCount");
        this.sPathLengths = new long[this.nodeCount];
        this.useNodeAttributes = true;
        this.useEdgeAttributes = true;
        this.roundingDigits = 8;
        this.numberOfIsolatedNodes = 0;
        this.numberOfSelfLoops = 0;
        this.multiEdgePartners = 0;
        this.nodeBetweenness = new WeakHashMap<CyNode, NodeBetweenInfo>();
        this.edgeBetweenness = new WeakHashMap<CyEdge, Double>();
        this.stress = new HashMap<CyNode, Long>();
        this.computeNB = true;
        AttributeSetup.createDirectedNodeAttributes(aNetwork.getTable(CyNode.class, "LOCAL_ATTRS"));
        AttributeSetup.createEdgeBetweennessAttribute(aNetwork.getTable(CyEdge.class, "LOCAL_ATTRS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeAll() {
        long time = System.currentTimeMillis();
        this.analysisStarting();
        this.inDegreeDist = new DegreeDistribution(this.nodeCount);
        this.outDegreeDist = new DegreeDistribution(this.nodeCount);
        this.neighborsAccum = null;
        this.ioNCps = new HashMap();
        this.inNCps = new HashMap();
        this.outNCps = new HashMap();
        this.CCps = new HashMap();
        this.closenessCent = new ArrayList(this.nodeCount);
        this.nodeBetweennessArray = new ArrayList(this.nodeCount);
        this.aplMap = new HashMap<CyNode, Double>();
        this.stressDist = new LogBinDistribution();
        this.outNeighbors = 0L;
        this.diameter = 0;
        this.radius = Integer.MAX_VALUE;
        ConnComponentAnalyzer analyzer = new ConnComponentAnalyzer(this, this.network);
        List<ConnectedComponentInfo> components = analyzer.findComponents();
        int connectedComponentsCount = components.size();
        ConnectedComponentInfo largestComponent = analyzer.findLargestComponent();
        for (ConnectedComponentInfo aCompInfo : components) {
            int numEdges;
            Set<CyNode> connNodes = analyzer.getNodesOf(aCompInfo);
            HashSet<CyEdge> connEdges = new HashSet<CyEdge>();
            int numNodes = connNodes.size();
            int[] edgeOffsets = new int[numNodes + 1];
            int[] outEdgeOffsets = new int[numNodes + 1];
            int[] inEdgeOffsets = new int[numNodes + 1];
            int[] inoutEdgeOffsets = new int[numNodes + 1];
            HashMap<CyNode, Integer> node2Int = new HashMap<CyNode, Integer>();
            int numEdgesLocal = 0;
            int numOutEdgesLocal = 0;
            int numInEdgesLocal = 0;
            int numInoutEdgesLocal = 0;
            HashMap<Long, Integer> edgeHash2Int = new HashMap<Long, Integer>();
            int e = 0;
            for (CyNode node2 : connNodes) {
                edgeOffsets[node2Int.size()] = numEdgesLocal;
                outEdgeOffsets[node2Int.size()] = numOutEdgesLocal;
                inEdgeOffsets[node2Int.size()] = numInEdgesLocal;
                inoutEdgeOffsets[node2Int.size()] = numInoutEdgesLocal;
                node2Int.put(node2, node2Int.size());
                numEdgesLocal += this.getNeighbors(node2).size();
                numOutEdgesLocal += this.getOutNeighbors(node2).size();
                numInEdgesLocal += this.getInNeighbors(node2).size();
                numInoutEdgesLocal += this.getOutNeighbors(node2).size() + this.getInNeighbors(node2).size();
            }
            for (CyNode node : connNodes) {
                for (CyEdge edge : this.getOutEdges(node)) {
                    int targetID;
                    connEdges.add(edge);
                    int sourceID = (Integer)node2Int.get(edge.getSource());
                    long edgeHash = DirNetworkAnalyzer.computeEdgeHash(sourceID, targetID = ((Integer)node2Int.get(edge.getTarget())).intValue());
                    if (edgeHash2Int.containsKey(edgeHash)) continue;
                    edgeHash2Int.put(edgeHash, e++);
                }
            }
            edgeOffsets[numNodes] = numEdges = numEdgesLocal;
            outEdgeOffsets[numNodes] = numOutEdgesLocal;
            inEdgeOffsets[numNodes] = numInEdgesLocal;
            inoutEdgeOffsets[numNodes] = numInoutEdgesLocal;
            int[] edges = new int[numEdges];
            int[] outEdges = new int[numOutEdgesLocal];
            int[] inEdges = new int[numInEdgesLocal];
            int[] inoutEdges = new int[numInoutEdgesLocal];
            int[] inoutEdgeIDs = new int[numInoutEdgesLocal];
            boolean[] inoutIsOutEdge = new boolean[numInoutEdgesLocal];
            for (CyNode cyNode : connNodes) {
                int edgeID;
                long edgeHash;
                int nodeID = (Integer)node2Int.get(cyNode);
                int offset = edgeOffsets[nodeID];
                for (CyNode cyNode2 : this.getNeighbors(cyNode)) {
                    edges[offset++] = (Integer)node2Int.get(cyNode2);
                }
                offset = outEdgeOffsets[nodeID];
                int inoutOffset = inoutEdgeOffsets[nodeID];
                for (CyNode outNeighbor : this.getOutNeighbors(cyNode)) {
                    int outNeighborID = (Integer)node2Int.get(outNeighbor);
                    edgeHash = DirNetworkAnalyzer.computeEdgeHash(nodeID, outNeighborID);
                    inoutEdgeIDs[inoutOffset] = edgeID = ((Integer)edgeHash2Int.get(edgeHash)).intValue();
                    inoutEdges[inoutOffset] = outNeighborID;
                    inoutIsOutEdge[inoutOffset++] = true;
                    outEdges[offset++] = outNeighborID;
                }
                offset = inEdgeOffsets[nodeID];
                for (CyNode inNeighbor : this.getInNeighbors(cyNode)) {
                    int inNeighborID = (Integer)node2Int.get(inNeighbor);
                    edgeHash = DirNetworkAnalyzer.computeEdgeHash(inNeighborID, nodeID);
                    inoutEdgeIDs[inoutOffset] = edgeID = ((Integer)edgeHash2Int.get(edgeHash)).intValue();
                    inoutEdges[inoutOffset] = inNeighborID;
                    inoutIsOutEdge[inoutOffset++] = false;
                    inEdges[offset++] = inNeighborID;
                }
            }
            this.nodeBetweennessLean = new double[numNodes];
            this.edgeBetweennessLean = new double[connEdges.size()];
            this.stressLean = new long[numNodes];
            LinkedList<CyNode> nodesLeft = new LinkedList<CyNode>();
            for (CyNode node4 : connNodes) {
                nodesLeft.add(node4);
            }
            Object var30_36 = null;
            int localDiameter = 0;
            int localRadius = Integer.MAX_VALUE;
            long[] localSPathLengths = new long[this.sPathLengths.length];
            double[] dArray = new double[this.nodeBetweennessLean.length];
            double[] localEdgeBetweenness = new double[this.edgeBetweennessLean.length];
            long[] localStress = new long[this.stressLean.length];
            while (nodesLeft.size() > 0) {
                int i;
                CyNode cyNode = (CyNode)nodesLeft.remove();
                ++this.progress;
                if (cyNode == null) continue;
                int nodeID = (Integer)node2Int.get(cyNode);
                List<CyEdge> inCyEdges = this.getInEdges(cyNode);
                List<CyEdge> outCyEdges = this.getOutEdges(cyNode);
                CyRow nodeRow = this.network.getRow((CyIdentifiable)cyNode);
                int firstEdge = edgeOffsets[nodeID];
                int lastEdge = edgeOffsets[nodeID + 1];
                int outFirstEdge = outEdgeOffsets[nodeID];
                int outLastEdge = outEdgeOffsets[nodeID + 1];
                int inFirstEdge = inEdgeOffsets[nodeID];
                int inLastEdge = inEdgeOffsets[nodeID + 1];
                DegreeDistribution degreeDistribution = this.inDegreeDist;
                synchronized (degreeDistribution) {
                    this.inDegreeDist.addObservation(inCyEdges.size());
                    this.outDegreeDist.addObservation(outCyEdges.size());
                }
                int neighborCount = lastEdge - firstEdge;
                int outNeighborCount = outLastEdge - outFirstEdge;
                int inNeighborCount = inLastEdge - inFirstEdge;
                int[] neighborsArray = new int[lastEdge - firstEdge];
                for (int ei = firstEdge; ei < lastEdge; ++ei) {
                    neighborsArray[ei - firstEdge] = edges[ei];
                }
                int[] outNeighborsArray = new int[outLastEdge - outFirstEdge];
                for (int ei = outFirstEdge; ei < outLastEdge; ++ei) {
                    outNeighborsArray[ei - outFirstEdge] = outEdges[ei];
                }
                int[] inNeighborsArray = new int[inLastEdge - inFirstEdge];
                for (int ei = inFirstEdge; ei < inLastEdge; ++ei) {
                    inNeighborsArray[ei - inFirstEdge] = inEdges[ei];
                }
                int selfloops = 0;
                for (int j = 0; j < inCyEdges.size(); ++j) {
                    CyEdge e2 = inCyEdges.get(j);
                    if (e2.getSource() != cyNode) continue;
                    ++selfloops;
                }
                int partnerOfMultiEdgeNodePairs = 0;
                for (MutInteger freq : CyNetworkUtils.getNeighborMap(this.network, cyNode).values()) {
                    if (freq.value <= 1) continue;
                    ++partnerOfMultiEdgeNodePairs;
                }
                if (this.neighborsAccum == null) {
                    this.neighborsAccum = new SumCountPair(neighborCount);
                } else {
                    this.neighborsAccum.add(neighborCount);
                }
                if (neighborCount == 0) {
                    ++this.numberOfIsolatedNodes;
                }
                this.numberOfSelfLoops += selfloops;
                this.multiEdgePartners += partnerOfMultiEdgeNodePairs;
                if (this.useNodeAttributes) {
                    nodeRow.set(Msgs.getAttr("cco"), (Object)0.0);
                    nodeRow.set(Msgs.getAttr("din"), (Object)inCyEdges.size());
                    nodeRow.set(Msgs.getAttr("dou"), (Object)outCyEdges.size());
                    nodeRow.set(Msgs.getAttr("dal"), (Object)(inCyEdges.size() + outCyEdges.size()));
                    nodeRow.set(Msgs.getAttr("isn"), (Object)(neighborCount == 0 ? 1 : 0));
                    nodeRow.set(Msgs.getAttr("slo"), (Object)selfloops);
                    nodeRow.set(Msgs.getAttr("pmn"), (Object)partnerOfMultiEdgeNodePairs);
                }
                if (neighborCount > 1) {
                    double nodeCCp = DirNetworkAnalyzer.computeCC(neighborsArray, numNodes, outEdges, outEdgeOffsets);
                    this.accumulate((Map<Integer, SumCountPair>)this.CCps, neighborCount, nodeCCp);
                    if (this.useNodeAttributes) {
                        nodeRow.set(Msgs.getAttr("cco"), (Object)nodeCCp);
                    }
                } else if (this.useNodeAttributes) {
                    nodeRow.set(Msgs.getAttr("cco"), (Object)0.0);
                }
                double nco = this.averageNeighbors(neighborsArray, edgeOffsets);
                if (neighborCount > 0) {
                    this.accumulate((Map<Integer, SumCountPair>)this.ioNCps, neighborCount, nco);
                }
                if (outNeighborCount > 0) {
                    double outNC = this.averageNeighbors(outNeighborsArray, outEdgeOffsets);
                    this.outNeighbors += (long)outNeighborCount;
                    this.accumulate((Map<Integer, SumCountPair>)this.outNCps, outNeighborCount, outNC);
                }
                if (inNeighborCount > 0) {
                    double inNC = this.averageNeighbors(inNeighborsArray, inEdgeOffsets);
                    this.accumulate((Map<Integer, SumCountPair>)this.inNCps, inNeighborCount, inNC);
                }
                if (this.useNodeAttributes) {
                    nodeRow.set(Msgs.getAttr("nco"), (Object)nco);
                }
                PathLengthData pathLengths = this.computeSP(nodeID, numNodes, outEdges, outEdgeOffsets, localSPathLengths);
                int eccentricity = pathLengths.getMaxLength();
                localDiameter = Math.max(localDiameter, eccentricity);
                if (0 < eccentricity) {
                    localRadius = Math.min(localRadius, eccentricity);
                }
                double apl = pathLengths.getCount() > 0 ? pathLengths.getAverageLength() : 0.0;
                Map<CyNode, Double> map = this.aplMap;
                synchronized (map) {
                    this.aplMap.put(cyNode, apl);
                }
                double closeness = apl > 0.0 ? 1.0 / apl : 0.0;
                ArrayList<Point2D.Double> arrayList = this.closenessCent;
                synchronized (arrayList) {
                    this.closenessCent.add(new Point2D.Double(neighborCount, closeness));
                }
                if (this.useNodeAttributes) {
                    nodeRow.set(Msgs.getAttr("spl"), (Object)eccentricity);
                    nodeRow.set(Msgs.getAttr("apl"), (Object)apl);
                    nodeRow.set(Msgs.getAttr("clc"), (Object)closeness);
                }
                if (this.computeNB) {
                    DirNetworkAnalyzer.computeNBandEB(nodeID, numNodes, inoutEdges, inoutEdgeOffsets, inoutEdgeIDs, inEdgeOffsets, dArray, localStress, localEdgeBetweenness);
                }
                if (this.cancelled) break;
                this.diameter = Math.max(this.diameter, localDiameter);
                this.radius = Math.min(this.radius, localRadius);
                for (i = 0; i < localSPathLengths.length; ++i) {
                    int n = i;
                    this.sPathLengths[n] = this.sPathLengths[n] + localSPathLengths[i];
                }
                for (i = 0; i < dArray.length; ++i) {
                    int n = i;
                    this.nodeBetweennessLean[n] = this.nodeBetweennessLean[n] + dArray[i];
                }
                for (i = 0; i < localEdgeBetweenness.length; ++i) {
                    int n = i;
                    this.edgeBetweennessLean[n] = this.edgeBetweennessLean[n] + localEdgeBetweenness[i];
                }
                for (i = 0; i < localStress.length; ++i) {
                    int n = i;
                    this.stressLean[n] = this.stressLean[n] + localStress[i];
                }
                if (this.cancelled) {
                    this.analysisFinished();
                    return;
                }
                for (CyNode n : connNodes) {
                    int id = (Integer)node2Int.get(n);
                    CyRow row = this.network.getRow((CyIdentifiable)n);
                    double nNormFactor = DirNetworkAnalyzer.computeNormFactor(numNodes);
                    double nb = this.nodeBetweennessLean[id] * nNormFactor;
                    if (Double.isNaN(nb)) {
                        nb = 0.0;
                    }
                    int connectivity = this.getNeighbors(n).size();
                    this.nodeBetweennessArray.add(new Point2D.Double(connectivity, nb));
                    long nodeStress = this.stressLean[id];
                    this.stressDist.addObservation(nodeStress);
                    if (!this.useNodeAttributes) continue;
                    row.set(Msgs.getAttr("nbt"), (Object)nb);
                    row.set(Msgs.getAttr("stress"), (Object)nodeStress);
                }
                if (!this.useEdgeAttributes) continue;
                for (CyEdge edge : connEdges) {
                    int sourceID = (Integer)node2Int.get(edge.getSource());
                    int targetID = (Integer)node2Int.get(edge.getTarget());
                    long edgeHash = DirNetworkAnalyzer.computeEdgeHash(sourceID, targetID);
                    double eb = Double.NaN;
                    if (edgeHash2Int.containsKey(edgeHash)) {
                        eb = this.edgeBetweennessLean[(Integer)edgeHash2Int.get(edgeHash)];
                    }
                    if (Double.isNaN(eb)) {
                        eb = 0.0;
                    }
                    this.network.getRow((CyIdentifiable)edge).set(Msgs.getAttr("ebt"), (Object)eb);
                }
            }
            this.stats.set("inDegreeDist", this.inDegreeDist.createHistogram());
            this.stats.set("outDegreeDist", this.outDegreeDist.createHistogram());
            if (this.CCps.size() > 0) {
                Point2D.Double[] averages = new Point2D.Double[this.CCps.size()];
                double cc = this.accumulateCCs(this.CCps, averages) / (double)this.nodeCount;
                this.stats.set("cc", cc);
                if (averages.length > 1) {
                    this.stats.set("cksDist", new Points2D(averages));
                }
            }
            long connPairs = 0L;
            long totalPathLength = 0L;
            for (int i = 1; i <= this.diameter; ++i) {
                connPairs += this.sPathLengths[i];
                totalPathLength += (long)i * this.sPathLengths[i];
            }
            this.stats.set("connPairs", connPairs);
            if (this.diameter > 0) {
                this.stats.set("diameter", this.diameter);
                this.stats.set("radius", this.radius);
                this.stats.set("avSpl", (double)totalPathLength / (double)connPairs);
                if (this.diameter > 1) {
                    this.stats.set("splDist", new LongHistogram(this.sPathLengths, 1, this.diameter));
                }
            }
            if (this.neighborsAccum != null) {
                this.stats.set("avNeighbors", this.neighborsAccum.getAverage());
            }
            this.stats.set("density", (double)this.outNeighbors / (double)(this.nodeCount * (this.nodeCount - 1)));
            this.stats.set("ncc", connectedComponentsCount);
            this.stats.set("usn", this.numberOfIsolatedNodes);
            this.stats.set("nsl", this.numberOfSelfLoops);
            this.stats.set("mnp", this.multiEdgePartners / 2);
            if (this.inNCps.size() > 1) {
                this.stats.set("inNeighborConn", this.getAverages(this.inNCps));
            }
            if (this.outNCps.size() > 1) {
                this.stats.set("outNeighborConn", this.getAverages(this.outNCps));
            }
            if (this.ioNCps.size() > 1) {
                this.stats.set("allNeighborConn", this.getAverages(this.ioNCps));
            }
            if (this.closenessCent.size() > 1) {
                this.stats.set("closenessCent", new Points2D(this.closenessCent));
            }
            if (this.nodeBetweennessArray.size() > 0) {
                this.stats.set("nodeBetween", new Points2D(this.nodeBetweennessArray));
            }
            this.stats.set("stressDist", this.stressDist.createPoints2D());
            this.analysisFinished();
            time = System.currentTimeMillis() - time;
            this.stats.set("time", (double)time / 1000.0);
            this.progress = this.nodeCount;
            this.doOutput();
        }
    }

    private double getAverages(HashMap<Integer, SumCountPair> inNCps2) {
        ArrayList list = new ArrayList();
        double total = 0.0;
        for (int i : inNCps2.keySet()) {
            SumCountPair pair = inNCps2.get(i);
            total += pair.getAverage();
        }
        return total / (double)inNCps2.size();
    }

    private List<CyEdge> getInEdges(CyNode aNode) {
        return this.network.getAdjacentEdgeList(aNode, CyEdge.Type.INCOMING);
    }

    private List<CyEdge> getOutEdges(CyNode aNode) {
        return this.network.getAdjacentEdgeList(aNode, CyEdge.Type.OUTGOING);
    }

    private Set<CyNode> getNeighbors(CyNode aNode, List<CyEdge> aInEdges, List<CyEdge> aOutEdges) {
        HashSet<CyNode> neighborSet = new HashSet<CyNode>();
        for (CyEdge e : aInEdges) {
            CyNode sourceNode = e.getSource();
            if (sourceNode == aNode) continue;
            neighborSet.add(sourceNode);
        }
        for (CyEdge e : aOutEdges) {
            CyNode targetNode = e.getTarget();
            if (targetNode == aNode) continue;
            neighborSet.add(targetNode);
        }
        return neighborSet;
    }

    private Set<CyNode> getNeighbors(CyNode aNode) {
        return this.getNeighbors(aNode, this.getInEdges(aNode), this.getOutEdges(aNode));
    }

    private Set<CyNode> getOutNeighbors(CyNode aNode) {
        return CyNetworkUtils.getNeighbors(this.network, aNode, this.getOutEdges(aNode));
    }

    private Set<CyNode> getInNeighbors(CyNode aNode) {
        return CyNetworkUtils.getNeighbors(this.network, aNode, this.getInEdges(aNode));
    }

    private PathLengthData computeSP(int node, int numNodes, int[] edges, int[] edgeOffsets, long[] outSPathLengths) {
        boolean[] visited = new boolean[numNodes];
        visited[node] = true;
        int[] frontier = new int[numNodes];
        int[] nextFrontier = new int[numNodes];
        frontier[0] = node;
        int frontierSize = 1;
        int length = 1;
        PathLengthData result = new PathLengthData();
        while (frontierSize > 0) {
            int nextFrontierSize = 0;
            for (int fi = 0; fi < frontierSize; ++fi) {
                int n = frontier[fi];
                int firstNeighbor = edgeOffsets[n];
                int lastNeighbor = edgeOffsets[n + 1];
                for (int ni = firstNeighbor; ni < lastNeighbor; ++ni) {
                    int neighbor = edges[ni];
                    if (visited[neighbor]) continue;
                    visited[neighbor] = true;
                    nextFrontier[nextFrontierSize++] = neighbor;
                }
            }
            for (int nfi = 0; nfi < nextFrontierSize; ++nfi) {
                frontier[nfi] = nextFrontier[nfi];
                result.addSPL(length);
            }
            int n = length++;
            outSPathLengths[n] = outSPathLengths[n] + (long)nextFrontierSize;
            frontierSize = nextFrontierSize;
        }
        return result;
    }

    private double averageNeighbors(int[] nodes, int[] edgeOffsets) {
        int neighbors = 0;
        for (int node : nodes) {
            neighbors += edgeOffsets[node + 1] - edgeOffsets[node];
        }
        return (double)neighbors / (double)nodes.length;
    }

    public static double computeCC(int[] neighbors, int numNodes, int[] edges, int[] edgeOffsets) {
        boolean[] isNeighbor = new boolean[numNodes];
        for (int neighbor : neighbors) {
            isNeighbor[neighbor] = true;
        }
        int edgeCount = 0;
        for (int neighbor : neighbors) {
            int firstEdge = edgeOffsets[neighbor];
            int lastEdge = edgeOffsets[neighbor + 1];
            for (int ei = firstEdge; ei < lastEdge; ++ei) {
                if (!isNeighbor[edges[ei]]) continue;
                ++edgeCount;
            }
        }
        long neighborsCount = neighbors.length;
        return (double)edgeCount / (double)(neighborsCount * (neighborsCount - 1L));
    }

    public static void computeNBandEB(int source, int numNodes, int[] edges, int[] edgeOffsets, int[] edgeIDs, int[] inEdgeOffsets, double[] returnNodeBetweenness, long[] returnStress, double[] returnEdgeBetweenness) {
        int[] Q = new int[numNodes];
        Q[0] = source;
        int Qlow = 0;
        int Qhigh = 1;
        int[] P = new int[edges.length];
        int[] Pedge = new int[edges.length];
        int[] Pcount = new int[numNodes];
        int[] Dedge = new int[edges.length];
        int[] Dcount = new int[numNodes];
        int[] sigma = new int[numNodes];
        sigma[source] = 1;
        int[] d = new int[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            d[i] = -1;
        }
        d[source] = 0;
        double[] delta = new double[numNodes];
        long[] stressDependency = new long[numNodes];
        double[] edgeDependency = new double[edges.length];
        while (Qlow < Qhigh) {
            int node = Q[Qlow++];
            int firstEdge = edgeOffsets[node];
            int lastEdge = edgeOffsets[node + 1];
            int inFirstEdge = inEdgeOffsets[node];
            int inLastEdge = inEdgeOffsets[node + 1];
            int numInEdges = inLastEdge - inFirstEdge;
            lastEdge -= numInEdges;
            int dnodeplus = d[node] + 1;
            int sigmanode = sigma[node];
            for (int ei = firstEdge; ei < lastEdge; ++ei) {
                int neighbor = edges[ei];
                if (d[neighbor] < 0) {
                    Q[Qhigh++] = neighbor;
                    d[neighbor] = dnodeplus;
                }
                if (d[neighbor] != dnodeplus) continue;
                int n = neighbor;
                sigma[n] = sigma[n] + sigmanode;
                int pi = edgeOffsets[neighbor] + Pcount[neighbor];
                P[pi] = node;
                Pedge[pi] = edgeIDs[ei];
                int n2 = neighbor;
                Pcount[n2] = Pcount[n2] + 1;
                int di = edgeOffsets[node] + Dcount[node];
                Dedge[di] = edgeIDs[ei];
                int n3 = node;
                Dcount[n3] = Dcount[n3] + 1;
            }
        }
        while (Qhigh > 0) {
            int w = Q[--Qhigh];
            int firstP = edgeOffsets[w];
            int lastP = firstP + Pcount[w];
            double sigmaw = 1.0 / (double)sigma[w];
            double deltaw = delta[w];
            long stressw = stressDependency[w];
            double Dbetweenness = 0.0;
            int firstD = edgeOffsets[w];
            int lastD = firstD + Dcount[w];
            boolean isLeaf = lastD - firstD == 0;
            for (int di = firstD; di < lastD; ++di) {
                Dbetweenness += edgeDependency[Dedge[di]];
            }
            for (int pi = firstP; pi < lastP; ++pi) {
                int v = P[pi];
                double sigmavw = (double)sigma[v] * sigmaw;
                int n = v;
                delta[n] = delta[n] + sigmavw * (1.0 + deltaw);
                int n4 = v;
                stressDependency[n4] = stressDependency[n4] + (1L + stressw);
                double edgeBetweenness = 0.0;
                int edgeID = Pedge[pi];
                edgeBetweenness = isLeaf ? sigmavw : (1.0 + Dbetweenness) * sigmavw;
                edgeDependency[edgeID] = edgeBetweenness;
                int n5 = edgeID;
                returnEdgeBetweenness[n5] = returnEdgeBetweenness[n5] + edgeBetweenness;
            }
            if (w == source) continue;
            int n = w;
            returnNodeBetweenness[n] = returnNodeBetweenness[n] + deltaw;
            int n6 = w;
            returnStress[n6] = returnStress[n6] + (long)sigma[w] * stressw;
        }
    }

    private double[] computePageRank(int numNodes, int[] edges, int[] edgeOffsets, double d, double epsilon) {
        double[] rank = new double[numNodes];
        double[] oldRank = new double[numNodes];
        double startRank = 1.0 / (double)numNodes;
        for (int i = 0; i < numNodes; ++i) {
            rank[i] = startRank;
        }
        double updateConstant = (1.0 - d) / (double)numNodes;
        double[] invDegree = new double[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            invDegree[i] = 1.0 / (double)(edgeOffsets[i + 1] - edgeOffsets[i]);
        }
        double diff = epsilon * 2.0;
        while (diff > epsilon) {
            int i;
            System.arraycopy(rank, 0, oldRank, 0, numNodes);
            for (i = 0; i < numNodes; ++i) {
                int firstEdge = edgeOffsets[i];
                int lastEdge = edgeOffsets[i + 1];
                double nodeRank = 0.0;
                for (int e = firstEdge; e < lastEdge; ++e) {
                    int neighbor = edges[e];
                    nodeRank += oldRank[neighbor] * invDegree[neighbor];
                }
                rank[i] = updateConstant + d * nodeRank;
            }
            diff = 0.0;
            for (i = 0; i < numNodes; ++i) {
                diff += Math.abs(rank[i] - oldRank[i]);
            }
        }
        return rank;
    }

    public static long computeEdgeHash(int source, int target) {
        return ((long)source << 32) + (long)target;
    }

    public static double computeNormFactor(int count) {
        return count > 2 ? 1.0 / (double)((count - 1) * (count - 2)) : 1.0;
    }
}

