/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.session.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyNetworkNamingImpl
implements CyNetworkNaming {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String DEF_NETWORK_NAME_PREFIX = "Network";
    private static final int MAX_TITLE_LENGH = 200;
    private final CyServiceRegistrar serviceRegistrar;

    public CyNetworkNamingImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public String getSuggestedSubnetworkTitle(CyNetwork parentNetwork) {
        String parentName = (String)parentNetwork.getRow((CyIdentifiable)parentNetwork).get("name", String.class);
        Pattern p = Pattern.compile(".*\\((\\d*)\\)$");
        Matcher m = p.matcher(parentName);
        int start = 0;
        if (m.matches()) {
            parentName = parentName.substring(0, m.start(1) - 1);
            start = Integer.decode(m.group(1));
        }
        if (parentName.length() > 200) {
            parentName = parentName.substring(0, 200);
        }
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        int i = start;
        String nameCandidate;
        while (CyNetworkNamingImpl.isNetworkTitleTaken(nameCandidate = parentName + "(" + (i + 1) + ")", netManager)) {
            ++i;
        }
        return nameCandidate;
    }

    public String getSuggestedNetworkTitle(String desiredTitle) {
        CyNetworkManager netManager;
        if (desiredTitle == null || desiredTitle.isBlank()) {
            desiredTitle = DEF_NETWORK_NAME_PREFIX;
            logger.warn("getSuggestedNetworkTitle: desiredTitle was '" + desiredTitle + "'");
        }
        if (!CyNetworkNamingImpl.isNetworkTitleTaken(desiredTitle, netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class))) {
            return desiredTitle;
        }
        Pattern p = Pattern.compile(".*_(\\d*)$");
        Matcher m = p.matcher(desiredTitle);
        int start = 0;
        if (m.matches()) {
            desiredTitle = desiredTitle.substring(0, m.start(1) - 1);
            String gr = m.group(1);
            int n = start = gr.isEmpty() ? 1 : Integer.decode(gr) + 1;
        }
        if (desiredTitle.length() > 200) {
            desiredTitle = desiredTitle.substring(0, 200);
        }
        int i = start;
        String titleCandidate;
        while (CyNetworkNamingImpl.isNetworkTitleTaken(titleCandidate = desiredTitle + (String)(i == 0 ? "" : "_" + i), netManager)) {
            ++i;
        }
        return titleCandidate;
    }

    private static boolean isNetworkTitleTaken(String titleCandidate, CyNetworkManager netManager) {
        for (CyNetwork existingNetwork : netManager.getNetworkSet()) {
            String name = (String)existingNetwork.getRow((CyIdentifiable)existingNetwork).get("name", String.class);
            if (name != null) {
                if (!name.equals(titleCandidate)) continue;
                return true;
            }
            logger.error("isNetworkTitleTaken: CyNetwork " + existingNetwork.getSUID() + " 'name' is NULL.");
        }
        return false;
    }
}

