/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.internal.color.AbstractDivergingPalette;

public class BuiltinDivergentPaletteProvider
implements PaletteProvider {
    Map<String, Palette> palettesMap = new HashMap<String, Palette>();

    public BuiltinDivergentPaletteProvider() {
        for (DivPalette dp : DivPalette.values()) {
            this.palettesMap.put(dp.getDescription(), new DivergentPalette(this, dp));
        }
    }

    public String getProviderName() {
        return "Built-in";
    }

    public List<PaletteType> getPaletteTypes() {
        return Collections.singletonList(BrewerType.DIVERGING);
    }

    public List<String> listPaletteNames(PaletteType type, boolean colorBlindSafe) {
        ArrayList<String> paletteNames = new ArrayList<String>();
        if (type.equals(BrewerType.DIVERGING)) {
            return new ArrayList<String>(this.palettesMap.keySet());
        }
        return paletteNames;
    }

    public List<Object> listPaletteIdentifiers(PaletteType type, boolean colorBlindSafe) {
        return this.listPaletteNames(type, colorBlindSafe);
    }

    public Palette getPalette(String paletteName) {
        return this.getPalette(paletteName, 3);
    }

    public Palette getPalette(String paletteName, int size) {
        if (this.palettesMap.containsKey(paletteName)) {
            return this.palettesMap.get(paletteName);
        }
        return null;
    }

    public Palette getPalette(Object paletteIdentifier) {
        return this.getPalette((String)paletteIdentifier);
    }

    public Palette getPalette(Object paletteIdentifier, int size) {
        return this.getPalette((String)paletteIdentifier, size);
    }

    static enum DivPalette {
        YlBlRd("Yellow-Black-Red", true, new Color[]{Color.RED, Color.BLACK, Color.YELLOW}),
        YlWhRd("Yellow-White-Red", true, new Color[]{Color.RED, Color.WHITE, Color.YELLOW}),
        CyBlYl("Cyan-Black-Yellow", true, new Color[]{Color.YELLOW, Color.BLACK, Color.CYAN}),
        CyWhYl("Cyan-White-Yellow", true, new Color[]{Color.YELLOW, Color.WHITE, Color.CYAN}),
        BlBlYl("Blue-Black-Yellow", true, new Color[]{Color.YELLOW, Color.BLACK, Color.BLUE}),
        BlWhYl("Blue-White-Yellow", true, new Color[]{Color.YELLOW, Color.WHITE, Color.BLUE}),
        BlBlRd("Blue-Black-Red", true, new Color[]{Color.RED, Color.BLACK, Color.BLUE}),
        BlGnYl("Blue-Green-Yellow", true, new Color[]{Color.YELLOW, Color.GREEN, Color.BLUE}),
        YlBlPl("Purple-Black-Yellow", true, new Color[]{Color.YELLOW, Color.BLACK, Color.MAGENTA}),
        GnBlPl("Green-Black-Purple", true, new Color[]{Color.MAGENTA, Color.BLACK, Color.GREEN}),
        GnWhPl("Green-White-Purple", true, new Color[]{Color.MAGENTA, Color.WHITE, Color.GREEN}),
        YlBlBl("Blue-Black-Yellow", true, new Color[]{Color.YELLOW, Color.BLACK, Color.BLUE}),
        OrWhBl("Blue-White-Orange", true, new Color[]{Color.ORANGE, Color.WHITE, Color.BLUE}),
        OrBlBl("Blue-Black-Orange", true, new Color[]{Color.ORANGE, Color.BLACK, Color.BLUE});

        String paletteDescription;
        boolean colorBlindSafe;
        Color[] colors;

        private DivPalette(String paletteDescription, boolean colorBlindSafe, Color[] colors) {
            this.paletteDescription = paletteDescription;
            this.colorBlindSafe = colorBlindSafe;
            this.colors = colors;
        }

        public String getDescription() {
            return this.paletteDescription;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public boolean isColorBlindSafe() {
            return this.colorBlindSafe;
        }
    }

    class DivergentPalette
    extends AbstractDivergingPalette {
        DivergentPalette(PaletteProvider provider, DivPalette dp) {
            super(provider, dp.getDescription(), dp.getColors(), dp.isColorBlindSafe());
        }
    }
}

