/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;

public abstract class AbstractPalette
implements Palette {
    protected PaletteProvider provider;
    protected String name;
    protected int size;
    protected PaletteType type;
    protected boolean colorBlindSafe;
    protected boolean reversed;

    AbstractPalette(PaletteProvider provider, String name, int size, PaletteType type, boolean cbs) {
        this.provider = provider;
        this.name = name;
        this.size = size;
        this.type = type;
        this.colorBlindSafe = cbs;
    }

    public abstract boolean isReversable();

    public boolean isReversed() {
        return this.reversed;
    }

    public void reverse(boolean reverse) {
        this.reversed = reverse;
    }

    public String getName() {
        if (this.isReversable() && this.reversed) {
            return this.name + " (R)";
        }
        return this.name;
    }

    public Object getIdentifier() {
        return this.name;
    }

    public PaletteType getType() {
        return this.type;
    }

    public boolean isColorBlindSafe() {
        return this.colorBlindSafe;
    }

    public int size() {
        return this.size;
    }

    public PaletteProvider getPaletteProvider() {
        return this.provider;
    }

    public abstract Color[] getColors();

    public abstract Color[] getColors(int var1);

    protected Color[] reverseColors(Color[] colors) {
        int n = colors.length;
        for (int i = 0; i < n / 2; ++i) {
            Color t = colors[i];
            colors[i] = colors[n - i - 1];
            colors[n - i - 1] = t;
        }
        return colors;
    }
}

