/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.linkout.internal;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.cytoscape.application.swing.CyMenuItem;
import org.cytoscape.linkout.internal.LinkoutTask;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

class DynamicSupport {
    private static final String EXTERNAL_LINK_ATTR = "Linkout.ExternalLinks";
    private final SynchronousTaskManager synTaskManager;
    private Map<String, String> menuTitleURLMap = new HashMap<String, String>();
    private CyIdentifiable[] tableEntries;
    protected final OpenBrowser browser;

    public DynamicSupport(OpenBrowser browser, SynchronousTaskManager synTaskManager) {
        this.browser = browser;
        this.synTaskManager = synTaskManager;
    }

    protected synchronized void setURLs(CyNetwork network, CyIdentifiable ... entries) {
        this.menuTitleURLMap.clear();
        if (entries == null || network == null) {
            this.menuTitleURLMap.clear();
            return;
        }
        for (CyIdentifiable entry : this.tableEntries = entries) {
            this.generateExternalLinks(network.getRow(entry), this.menuTitleURLMap);
        }
    }

    private void generateExternalLinks(CyRow row, Map<String, String> urlMap) {
        CyColumn column = row.getTable().getColumn(EXTERNAL_LINK_ATTR);
        if (column != null) {
            Class attrType = column.getType();
            if (attrType == String.class) {
                String linkAttr = (String)row.get(EXTERNAL_LINK_ATTR, String.class);
                this.addExternalLink(linkAttr, urlMap);
            } else if (attrType == List.class) {
                List attrList = row.getList(EXTERNAL_LINK_ATTR, String.class);
                for (String linkAttr : attrList) {
                    this.addExternalLink(linkAttr, urlMap);
                }
            }
        }
    }

    private void addExternalLink(String linkAttr, Map<String, String> urlMap) {
        if (linkAttr == null) {
            System.out.println("link attr is null");
            return;
        }
        String[] pair = linkAttr.split("=", 2);
        if (pair.length != 2) {
            System.out.println("Didn't tokenize on equals" + linkAttr);
            return;
        }
        if (!pair[1].startsWith("http")) {
            System.out.println("not a url: " + pair[1]);
            return;
        }
        urlMap.put(this.removeMarker(pair[0]), pair[1]);
    }

    private String removeMarker(String s) {
        if (s.startsWith("nodelinkouturl.")) {
            return s.substring("nodelinkouturl.".length());
        }
        if (s.startsWith("edgelinkouturl.")) {
            return s.substring("edgelinkouturl.".length());
        }
        return s;
    }

    public void createSubMenus(CyMenuItem menuItem, final CyNetwork network, CyIdentifiable ... entries) {
        this.setURLs(network, entries);
        for (final String menuTitle : this.menuTitleURLMap.keySet()) {
            JMenuItem subMenu = new JMenuItem(menuTitle);
            subMenu.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    String url = "none found";
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        url = DynamicSupport.this.menuTitleURLMap.get(menuTitle);
                    }
                    DynamicSupport.this.synTaskManager.execute(new TaskIterator(new Task[]{new LinkoutTask(url, DynamicSupport.this.browser, network, DynamicSupport.this.tableEntries)}));
                }
            });
            menuItem.getMenuItem().add(subMenu);
        }
    }
}

