/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal.mappings;

import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.mappings.AbstractVisualMappingFunction;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.view.vizmap.mappings.ValueTranslator;

public class PassthroughMappingImpl<K, V>
extends AbstractVisualMappingFunction<K, V>
implements PassthroughMapping<K, V> {
    private final ValueTranslator<K, V> translator;

    public PassthroughMappingImpl(String columnName, Class<K> columnType, VisualProperty<V> vp, ValueTranslator<K, V> translator, CyEventHelper eventHelper) {
        super(columnName, columnType, vp, eventHelper);
        this.translator = translator;
    }

    public V getMappedValue(CyRow row) {
        if (row == null || !row.isSet(this.columnName)) {
            return null;
        }
        Object tableValue = null;
        CyColumn column = row.getTable().getColumn(this.columnName);
        if (column != null) {
            Class columnClass = column.getType();
            try {
                tableValue = row.get(this.columnName, columnClass);
            }
            catch (ClassCastException cce) {
                return null;
            }
            Object value = this.translator.translate(tableValue);
            if (value instanceof String) {
                try {
                    value = this.vp.parseSerializableString((String)value);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (value != null) {
                try {
                    return (V)value;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String toString() {
        return "Passthrough Mapping";
    }
}

