/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal.mappings;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangeRecord;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedEvent;
import org.cytoscape.view.vizmap.internal.mappings.interpolators.FlatInterpolator;
import org.cytoscape.view.vizmap.internal.mappings.interpolators.Interpolator;
import org.cytoscape.view.vizmap.internal.mappings.interpolators.LinearNumberToColorInterpolator;
import org.cytoscape.view.vizmap.internal.mappings.interpolators.LinearNumberToNumberInterpolator;
import org.cytoscape.view.vizmap.mappings.AbstractVisualMappingFunction;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;

public class ContinuousMappingImpl<K, V>
extends AbstractVisualMappingFunction<K, V>
implements ContinuousMapping<K, V> {
    private Interpolator<K, V> interpolator;
    private List<ContinuousMappingPoint<K, V>> points;
    private final Object lock = new Object();

    public ContinuousMappingImpl(String attrName, Class<K> attrType, VisualProperty<V> vp, CyEventHelper eventHelper) {
        super(attrName, attrType, vp, eventHelper);
        if (!Number.class.isAssignableFrom(attrType)) {
            throw new IllegalArgumentException("Column type should be Number.");
        }
        this.points = new ArrayList<ContinuousMappingPoint<K, V>>();
        this.interpolator = vp.getRange().getType() == Color.class || vp.getRange().getType() == Paint.class ? new LinearNumberToColorInterpolator() : (Number.class.isAssignableFrom(vp.getRange().getType()) ? new LinearNumberToNumberInterpolator() : new FlatInterpolator<K, V>());
    }

    public List<ContinuousMappingPoint<K, V>> getAllPoints() {
        return Collections.unmodifiableList(this.points);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(K value, BoundaryRangeValues<V> brv) {
        Object object = this.lock;
        synchronized (object) {
            this.points.add(new ContinuousMappingPoint(value, brv, (ContinuousMapping)this, this.eventHelper));
        }
        this.eventHelper.addEventPayload((Object)this, (Object)new VisualMappingFunctionChangeRecord(), VisualMappingFunctionChangedEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePoint(int index) {
        Object object = this.lock;
        synchronized (object) {
            this.points.remove(index);
        }
        this.eventHelper.addEventPayload((Object)this, (Object)new VisualMappingFunctionChangeRecord(), VisualMappingFunctionChangedEvent.class);
    }

    public int getPointCount() {
        return this.points.size();
    }

    public ContinuousMappingPoint<K, V> getPoint(int index) {
        if (this.points.isEmpty()) {
            return null;
        }
        if (this.points.size() > index) {
            return this.points.get(index);
        }
        throw new IllegalArgumentException("Invalid Index: " + index + ".  There are " + this.points.size() + " points.");
    }

    public V getMappedValue(CyRow row) {
        V value = null;
        if (row != null && row.isSet(this.columnName)) {
            try {
                Object attrValue = row.get(this.columnName, this.columnType);
                value = this.getRangeValue(attrValue);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return value;
    }

    private V getRangeValue(K domainValue) {
        if (this.points.isEmpty() || domainValue == null || domainValue instanceof Number && Double.isNaN(((Number)domainValue).doubleValue())) {
            return null;
        }
        ContinuousMappingPoint<K, V> firstPoint = this.points.get(0);
        Object minDomain = firstPoint.getValue();
        int firstCmp = this.compareValues(domainValue, minDomain);
        if (firstCmp <= 0) {
            BoundaryRangeValues bv = firstPoint.getRange();
            if (firstCmp < 0) {
                return (V)bv.lesserValue;
            }
            return (V)bv.equalValue;
        }
        ContinuousMappingPoint<K, V> lastPoint = this.points.get(this.points.size() - 1);
        Object maxDomain = lastPoint.getValue();
        if (this.compareValues(domainValue, maxDomain) > 0) {
            BoundaryRangeValues bv = lastPoint.getRange();
            return (V)bv.greaterValue;
        }
        if (this.interpolator == null) {
            return null;
        }
        int index = 0;
        for (index = 0; index < this.points.size(); ++index) {
            ContinuousMappingPoint<K, V> currentPoint = this.points.get(index);
            Object currentValue = currentPoint.getValue();
            int cmpValue = this.compareValues(domainValue, currentValue);
            if (cmpValue == 0) {
                BoundaryRangeValues bv = currentPoint.getRange();
                return (V)bv.equalValue;
            }
            if (cmpValue < 0) break;
        }
        return this.getRangeValue(index, domainValue);
    }

    private V getRangeValue(int index, K domainValue) {
        ContinuousMappingPoint<K, V> lowerBound = this.points.get(index - 1);
        Object lowerDomain = lowerBound.getValue();
        BoundaryRangeValues lv = lowerBound.getRange();
        Object lowerRange = lv.greaterValue;
        ContinuousMappingPoint<K, V> upperBound = this.points.get(index);
        Object upperDomain = upperBound.getValue();
        BoundaryRangeValues gv = upperBound.getRange();
        Object upperRange = gv.lesserValue;
        Object value = this.interpolator.getRangeValue(lowerDomain, lowerRange, upperDomain, upperRange, domainValue);
        if (value instanceof Number) {
            Class type = this.vp.getRange().getType();
            if (type == Long.class) {
                if (!(value instanceof Long)) {
                    value = Math.round(((Number)value).doubleValue());
                }
            } else if (type == Integer.class) {
                if (!(value instanceof Integer)) {
                    value = (int)Math.round(((Number)value).doubleValue());
                }
            } else if (type == Short.class) {
                if (!(value instanceof Short)) {
                    value = (short)Math.round(((Number)value).doubleValue());
                }
            } else if (type == Byte.class) {
                if (!(value instanceof Byte)) {
                    value = (byte)Math.round(((Number)value).doubleValue());
                }
            } else if (type == Double.class) {
                if (!(value instanceof Double)) {
                    value = ((Number)value).doubleValue();
                }
            } else if (type == Float.class && !(value instanceof Float)) {
                value = Float.valueOf(((Number)value).floatValue());
            }
        }
        return (V)value;
    }

    private int compareValues(K probe, K target) {
        double d2;
        Number n1 = (Number)probe;
        Number n2 = (Number)target;
        double d1 = n1 != null ? n1.doubleValue() : Double.NEGATIVE_INFINITY;
        double d = d2 = n2 != null ? n2.doubleValue() : Double.NEGATIVE_INFINITY;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Continuous Mapping";
    }
}

