/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualPropertyDependencyFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedEvent;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedListener;
import org.cytoscape.view.vizmap.events.VisualPropertyDependencyChangedEvent;
import org.cytoscape.view.vizmap.events.VisualPropertyDependencyChangedListener;
import org.cytoscape.view.vizmap.events.VisualStyleChangeRecord;
import org.cytoscape.view.vizmap.events.VisualStyleChangedEvent;
import org.cytoscape.view.vizmap.internal.AbstractApplyHandler;
import org.cytoscape.view.vizmap.internal.ApplyToColumnHandler;
import org.cytoscape.view.vizmap.internal.ApplyToEdgeHandler;
import org.cytoscape.view.vizmap.internal.ApplyToNetworkHandler;
import org.cytoscape.view.vizmap.internal.ApplyToNodeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualStyleImpl
implements VisualStyle,
VisualMappingFunctionChangedListener,
VisualPropertyDependencyChangedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String DEFAULT_TITLE = "?";
    private final Map<VisualProperty<?>, VisualMappingFunction<?, ?>> mappings = new HashMap();
    private final Map<VisualProperty<?>, Object> styleDefaults = new HashMap();
    private final ApplyToNetworkHandler applyToNetworkHandler;
    private final ApplyToNodeHandler applyToNodeHandler;
    private final ApplyToEdgeHandler applyToEdgeHandler;
    private final ApplyToColumnHandler applyToColumnHandler;
    private String title;
    private final CyEventHelper eventHelper;
    private final Set<VisualPropertyDependency<?>> dependencies = new HashSet();
    private final Object lock = new Object();

    public VisualStyleImpl(String title, CyServiceRegistrar registrar) {
        this.title = title == null ? DEFAULT_TITLE : title;
        this.eventHelper = (CyEventHelper)registrar.getService(CyEventHelper.class);
        this.applyToNetworkHandler = new ApplyToNetworkHandler(this, registrar);
        this.applyToNodeHandler = new ApplyToNodeHandler(this, registrar);
        this.applyToEdgeHandler = new ApplyToEdgeHandler(this, registrar);
        this.applyToColumnHandler = new ApplyToColumnHandler(this, registrar);
        registrar.registerServiceListener((Object)this, "registerDependencyFactory", "unregisterDependencyFactory", VisualPropertyDependencyFactory.class);
        registrar.registerService((Object)this, VisualMappingFunctionChangedListener.class, new Properties());
        registrar.registerService((Object)this, VisualPropertyDependencyChangedListener.class, new Properties());
    }

    private void setUpdateDependencyMaps() {
        this.applyToNetworkHandler.setUpdateDependencyMaps();
        this.applyToNodeHandler.setUpdateDependencyMaps();
        this.applyToEdgeHandler.setUpdateDependencyMaps();
    }

    private void fireVisualStyleChange() {
        this.setUpdateDependencyMaps();
        this.eventHelper.addEventPayload((Object)this, (Object)new VisualStyleChangeRecord(), VisualStyleChangedEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisualMappingFunction(VisualMappingFunction<?, ?> mapping) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            VisualMappingFunction<?, ?> oldMapping = this.mappings.get(mapping.getVisualProperty());
            changed = !mapping.equals(oldMapping);
        }
        if (changed) {
            this.eventHelper.flushPayloadEvents();
            object = this.lock;
            synchronized (object) {
                this.mappings.put(mapping.getVisualProperty(), mapping);
            }
            this.fireVisualStyleChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> VisualMappingFunction<?, V> getVisualMappingFunction(VisualProperty<V> t) {
        Object object = this.lock;
        synchronized (object) {
            return this.mappings.get(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisualMappingFunction(VisualProperty<?> t) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            VisualMappingFunction<?, ?> oldMapping = this.mappings.remove(t);
            changed = oldMapping != null;
        }
        if (changed) {
            this.fireVisualStyleChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V getDefaultValue(VisualProperty<V> vp) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.styleDefaults.get(vp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, S extends V> void setDefaultValue(VisualProperty<V> vp, S value) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            boolean containsKey = this.styleDefaults.containsKey(vp);
            Object oldValue = this.styleDefaults.put(vp, value);
            changed = !containsKey || value == null && oldValue != null || value != null && !value.equals(oldValue);
        }
        if (changed) {
            this.fireVisualStyleChange();
        }
    }

    public void apply(CyNetworkView networkView) {
        this.eventHelper.flushPayloadEvents();
        this.applyToNetworkHandler.apply((CyRow)null, (View<CyNetwork>)networkView);
    }

    public void apply(View<CyColumn> columnView) {
        this.eventHelper.flushPayloadEvents();
        this.applyToColumnHandler.apply((CyRow)null, columnView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(CyRow row, View<? extends CyIdentifiable> view) {
        if (view == null) {
            logger.warn("Tried to apply Visual Style to null view");
            return;
        }
        AbstractApplyHandler handler = null;
        Object object = this.lock;
        synchronized (object) {
            Class<?> viewClass = ((CyIdentifiable)view.getModel()).getClass();
            if (CyNetwork.class.isAssignableFrom(viewClass)) {
                handler = this.applyToNetworkHandler;
            } else if (CyNode.class.isAssignableFrom(viewClass)) {
                handler = this.applyToNodeHandler;
            } else if (CyEdge.class.isAssignableFrom(viewClass)) {
                handler = this.applyToEdgeHandler;
            } else if (CyColumn.class.isAssignableFrom(viewClass)) {
                handler = this.applyToColumnHandler;
            }
        }
        if (handler == null) {
            throw new IllegalArgumentException("This view type is not supported: " + view.getClass());
        }
        handler.apply(row, view);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VisualMappingFunction<?, ?>> getAllVisualMappingFunctions() {
        Object object = this.lock;
        synchronized (object) {
            return this.mappings.values();
        }
    }

    Map<VisualProperty<?>, Object> getStyleDefaults() {
        return this.styleDefaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<VisualProperty<?>, Object> getAllDefaultValues() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap(this.styleDefaults);
        }
    }

    public Set<VisualPropertyDependency<?>> getAllVisualPropertyDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisualPropertyDependency(VisualPropertyDependency<?> dependency) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            changed = this.dependencies.add(dependency);
        }
        if (changed) {
            dependency.setEventHelper(this.eventHelper);
            this.fireVisualStyleChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisualPropertyDependency(VisualPropertyDependency<?> dependency) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            changed = this.dependencies.remove(dependency);
        }
        if (changed) {
            this.fireVisualStyleChange();
        }
    }

    public void registerDependencyFactory(VisualPropertyDependencyFactory<?> dependencyFactory, Map<?, ?> props) {
        if (dependencyFactory != null) {
            this.addVisualPropertyDependency(dependencyFactory.createVisualPropertyDependency());
        }
    }

    public void unregisterDependencyFactory(VisualPropertyDependencyFactory<?> dependencyFactory, Map<?, ?> props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(VisualMappingFunctionChangedEvent e) {
        VisualMappingFunction mapping = (VisualMappingFunction)e.getSource();
        boolean hasMapping = false;
        Object object = this.lock;
        synchronized (object) {
            hasMapping = mapping == this.mappings.get(mapping.getVisualProperty());
        }
        if (hasMapping) {
            this.fireVisualStyleChange();
        }
    }

    public void handleEvent(VisualPropertyDependencyChangedEvent e) {
        VisualPropertyDependency dep = (VisualPropertyDependency)e.getSource();
        if (this.dependencies.contains(dep)) {
            this.fireVisualStyleChange();
        }
    }
}

