/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.internal.VisualStyleImpl;
import org.cytoscape.view.vizmap.internal.mappings.ContinuousMappingImpl;
import org.cytoscape.view.vizmap.internal.mappings.DiscreteMappingImpl;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualStyleFactoryImpl
implements VisualStyleFactory {
    private final CyServiceRegistrar serviceRegistrar;
    private final VisualMappingFunctionFactory passThroughFactory;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public VisualStyleFactoryImpl(CyServiceRegistrar serviceRegistrar, VisualMappingFunctionFactory passThroughFactory) {
        this.serviceRegistrar = serviceRegistrar;
        this.passThroughFactory = passThroughFactory;
    }

    public VisualStyle createVisualStyle(VisualStyle original) {
        VisualStyleImpl copy = new VisualStyleImpl(original.getTitle(), this.serviceRegistrar);
        this.copyDefaultValues(original, copy);
        this.copyMappingFunctions(original, copy);
        this.copyDependencies(original, copy);
        return copy;
    }

    public VisualStyle createVisualStyle(String title) {
        return new VisualStyleImpl(title, this.serviceRegistrar);
    }

    private <V, S extends V> void copyDefaultValues(VisualStyle original, VisualStyle copy) {
        Map defaultValues = original.getAllDefaultValues();
        for (Map.Entry entry : defaultValues.entrySet()) {
            VisualProperty vp = (VisualProperty)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            copy.setDefaultValue(vp, value);
        }
    }

    private void copyMappingFunctions(VisualStyle original, VisualStyle copy) {
        Collection allMapping = original.getAllVisualMappingFunctions();
        for (VisualMappingFunction mapping : allMapping) {
            VisualMappingFunction copyMapping = null;
            if (mapping instanceof PassthroughMapping) {
                copyMapping = this.createPassthrough((PassthroughMapping)mapping);
            } else if (mapping instanceof ContinuousMapping) {
                copyMapping = this.createContinuous((ContinuousMapping)mapping);
            } else if (mapping instanceof DiscreteMapping) {
                copyMapping = this.createDiscrete((DiscreteMapping)mapping);
            }
            if (copyMapping == null) continue;
            copy.addVisualMappingFunction(copyMapping);
        }
    }

    private void copyDependencies(VisualStyle original, VisualStyle copy) {
        Set allDep1 = original.getAllVisualPropertyDependencies();
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        VisualLexicon lexicon = appMgr.getCurrentNetworkViewRenderer().getRenderingEngineFactory("").getVisualLexicon();
        Set allDep2 = copy.getAllVisualPropertyDependencies();
        HashMap<String, VisualPropertyDependency> depMap = new HashMap<String, VisualPropertyDependency>();
        for (VisualPropertyDependency dep : allDep2) {
            depMap.put(dep.getIdString(), dep);
        }
        for (VisualPropertyDependency dep1 : allDep1) {
            try {
                VisualPropertyDependency dep2 = (VisualPropertyDependency)depMap.get(dep1.getIdString());
                if (dep2 == null) {
                    dep2 = new VisualPropertyDependency(dep1.getIdString(), dep1.getDisplayName(), dep1.getVisualProperties(), lexicon);
                    dep2.setDependency(dep1.isDependencyEnabled());
                    copy.addVisualPropertyDependency(dep2);
                    continue;
                }
                dep2.setDependency(dep1.isDependencyEnabled());
            }
            catch (Exception e) {
                logger.warn("Cannot copy VisualPropertyDependency " + dep1.getIdString(), (Throwable)e);
            }
        }
    }

    private <K, V> VisualMappingFunction<K, V> createPassthrough(PassthroughMapping<K, V> originalMapping) {
        String attrName = originalMapping.getMappingColumnName();
        Class colType = originalMapping.getMappingColumnType();
        PassthroughMapping copyMapping = (PassthroughMapping)this.passThroughFactory.createVisualMappingFunction(attrName, colType, originalMapping.getVisualProperty());
        return copyMapping;
    }

    private <K, V> VisualMappingFunction<K, V> createContinuous(ContinuousMapping<K, V> originalMapping) {
        String attrName = originalMapping.getMappingColumnName();
        Class colType = originalMapping.getMappingColumnType();
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        ContinuousMappingImpl copyMapping = new ContinuousMappingImpl(attrName, colType, originalMapping.getVisualProperty(), eventHelper);
        List points = originalMapping.getAllPoints();
        for (ContinuousMappingPoint point : points) {
            copyMapping.addPoint(point.getValue(), new BoundaryRangeValues(point.getRange()));
        }
        return copyMapping;
    }

    private <K, V> VisualMappingFunction<K, V> createDiscrete(DiscreteMapping<K, V> originalMapping) {
        String attrName = originalMapping.getMappingColumnName();
        Class colType = originalMapping.getMappingColumnType();
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        DiscreteMappingImpl copyMapping = new DiscreteMappingImpl(attrName, colType, originalMapping.getVisualProperty(), eventHelper);
        copyMapping.putAll(originalMapping.getAll());
        return copyMapping;
    }
}

