/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.awt.Font;
import java.awt.Paint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.StyleAssociation;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.events.table.ColumnAssociatedVisualStyleSetEvent;
import org.cytoscape.view.vizmap.events.table.ColumnVisualStyleSetEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableVisualMappingManagerImpl
implements TableVisualMappingManager,
TableViewAboutToBeDestroyedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String DEFAULT_STYLE_NAME = "default";
    private final CyServiceRegistrar registrar;
    private final Object lock = new Object();
    private final Map<View<CyColumn>, VisualStyle> column2VisualStyleMap = new WeakHashMap<View<CyColumn>, VisualStyle>();
    private final Map<VisualStyle, Map<String, VisualStyle>> associatedNodeStyles = new WeakHashMap<VisualStyle, Map<String, VisualStyle>>();
    private final Map<VisualStyle, Map<String, VisualStyle>> associatedEdgeStyles = new WeakHashMap<VisualStyle, Map<String, VisualStyle>>();
    private final VisualStyle defaultStyle;

    public TableVisualMappingManagerImpl(VisualStyleFactory factory, CyServiceRegistrar serviceRegistrar) {
        this.registrar = Objects.requireNonNull(serviceRegistrar, "'serviceRegistrar' cannot be null");
        this.defaultStyle = TableVisualMappingManagerImpl.buildGlobalDefaultStyle(factory);
    }

    private static VisualStyle buildGlobalDefaultStyle(VisualStyleFactory factory) {
        VisualStyle defStyle = factory.createVisualStyle(DEFAULT_STYLE_NAME);
        defStyle.setDefaultValue(BasicTableVisualLexicon.CELL_BACKGROUND_PAINT, (Object)((Paint)BasicTableVisualLexicon.CELL_BACKGROUND_PAINT.getDefault()));
        defStyle.setDefaultValue(BasicTableVisualLexicon.CELL_FONT_FACE, (Object)((Font)BasicTableVisualLexicon.CELL_FONT_FACE.getDefault()));
        defStyle.setDefaultValue(BasicTableVisualLexicon.CELL_FONT_SIZE, (Object)((Integer)BasicTableVisualLexicon.CELL_FONT_SIZE.getDefault()));
        defStyle.setDefaultValue(BasicTableVisualLexicon.CELL_TEXT_COLOR, (Object)((Paint)BasicTableVisualLexicon.CELL_TEXT_COLOR.getDefault()));
        defStyle.setDefaultValue(BasicTableVisualLexicon.CELL_TOOLTIP, (Object)((String)BasicTableVisualLexicon.CELL_TOOLTIP.getDefault()));
        return defStyle;
    }

    public VisualStyle getDefaultVisualStyle() {
        return this.defaultStyle;
    }

    public void handleEvent(TableViewAboutToBeDestroyedEvent e) {
        CyTableView tableView = e.getTableView();
        for (View colView : tableView.getColumnViews()) {
            this.clearStyle((View<CyColumn>)colView);
        }
    }

    private NetworkStyleAndTableType getNetworkStyleAndTableType(View<CyColumn> colView) {
        VisualMappingManager visualMappingManager = (VisualMappingManager)this.registrar.getService(VisualMappingManager.class);
        CyNetworkViewManager networkViewManager = (CyNetworkViewManager)this.registrar.getService(CyNetworkViewManager.class);
        CyNetworkTableManager networkTableManager = (CyNetworkTableManager)this.registrar.getService(CyNetworkTableManager.class);
        CyTable table = ((CyColumn)colView.getModel()).getTable();
        String namespace = networkTableManager.getTableNamespace(table);
        CyNetwork network = networkTableManager.getNetworkForTable(table);
        Class tableType = networkTableManager.getTableType(table);
        if (network != null && namespace == "USER" && (tableType == CyNode.class || tableType == CyEdge.class)) {
            Collection netViews = networkViewManager.getNetworkViews(network);
            if (tableType != null && netViews != null && !netViews.isEmpty()) {
                int netViewCount = netViews.size();
                Iterator iter = netViews.iterator();
                VisualStyle firstStyle = visualMappingManager.getVisualStyle((CyNetworkView)iter.next());
                if (netViewCount > 1) {
                    while (iter.hasNext()) {
                        VisualStyle nextStyle = visualMappingManager.getVisualStyle((CyNetworkView)iter.next());
                        if (firstStyle.equals(nextStyle)) continue;
                        return null;
                    }
                }
                return new NetworkStyleAndTableType(firstStyle, tableType);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualStyle getVisualStyle(View<CyColumn> colView) {
        if (colView == null) {
            logger.warn("Attempting to get the visual style for a null column view.");
            return null;
        }
        NetworkStyleAndTableType nsatt = this.getNetworkStyleAndTableType(colView);
        if (nsatt != null) {
            VisualStyle networkStyle = nsatt.networkStyle();
            Class<? extends CyIdentifiable> tableType = nsatt.tableType();
            String colName = ((CyColumn)colView.getModel()).getName();
            return this.getAssociatedColumnVisualStyle(networkStyle, tableType, colName);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.column2VisualStyleMap.get(colView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisualStyle(View<CyColumn> colView, VisualStyle columnStyle) {
        Objects.requireNonNull(colView, "Column view is null.");
        NetworkStyleAndTableType nsatt = this.getNetworkStyleAndTableType(colView);
        if (nsatt != null) {
            VisualStyle networkStyle = nsatt.networkStyle();
            Class<? extends CyIdentifiable> tableType = nsatt.tableType();
            String colName = ((CyColumn)colView.getModel()).getName();
            this.setAssociatedVisualStyle(networkStyle, tableType, colName, columnStyle);
            return;
        }
        boolean changed = false;
        Object tableType = this.lock;
        synchronized (tableType) {
            VisualStyle previousStyle;
            changed = columnStyle == null ? this.column2VisualStyleMap.remove(colView) != null : !columnStyle.equals(previousStyle = this.column2VisualStyleMap.put(colView, columnStyle));
        }
        if (changed) {
            CyEventHelper eventHelper = (CyEventHelper)this.registrar.getService(CyEventHelper.class);
            eventHelper.fireEvent((CyEvent)new ColumnVisualStyleSetEvent((TableVisualMappingManager)this, columnStyle, colView));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStyle(View<CyColumn> colView) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            changed = this.column2VisualStyleMap.remove(colView) != null;
        }
        if (changed) {
            CyEventHelper eventHelper = (CyEventHelper)this.registrar.getService(CyEventHelper.class);
            eventHelper.fireEvent((CyEvent)new ColumnVisualStyleSetEvent((TableVisualMappingManager)this, null, colView));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VisualStyle> getAllVisualStyles() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<VisualStyle>(this.column2VisualStyleMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<View<CyColumn>, VisualStyle> getAllVisualStylesMap() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<View<CyColumn>, VisualStyle>(this.column2VisualStyleMap);
        }
    }

    public Set<VisualLexicon> getAllVisualLexicon() {
        LinkedHashSet<VisualLexicon> set = new LinkedHashSet<VisualLexicon>();
        CyApplicationManager appManager = (CyApplicationManager)this.registrar.getService(CyApplicationManager.class);
        for (TableViewRenderer renderer : appManager.getTableViewRendererSet()) {
            VisualLexicon lexicon;
            RenderingEngineFactory factory = renderer.getRenderingEngineFactory("");
            if (factory == null || (lexicon = factory.getVisualLexicon()) == null) continue;
            set.add(lexicon);
        }
        return set;
    }

    private Map<VisualStyle, Map<String, VisualStyle>> getAssociatedStyleMap(Class<? extends CyIdentifiable> tableType) {
        if (tableType == CyNode.class) {
            return this.associatedNodeStyles;
        }
        if (tableType == CyEdge.class) {
            return this.associatedEdgeStyles;
        }
        throw new IllegalArgumentException("tableType is not a supported type, got: " + tableType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAssociatedVisualStyle(VisualStyle networkVisualStyle, Class<? extends CyIdentifiable> tableType, String colName, VisualStyle columnVisualStyle) {
        Objects.requireNonNull(networkVisualStyle, "networkVisualStyle is null");
        Objects.requireNonNull(tableType, "tableType is null");
        Objects.requireNonNull(colName, "colName is null");
        Map<VisualStyle, Map<String, VisualStyle>> styleMap = this.getAssociatedStyleMap(tableType);
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            VisualStyle previousStyle;
            Map networkAssociatedStyles = styleMap.computeIfAbsent(networkVisualStyle, k -> new HashMap());
            changed = columnVisualStyle == null ? networkAssociatedStyles.remove(colName) != null : !columnVisualStyle.equals(previousStyle = networkAssociatedStyles.put(colName, columnVisualStyle));
        }
        if (changed) {
            CyEventHelper eventHelper = (CyEventHelper)this.registrar.getService(CyEventHelper.class);
            StyleAssociation association = new StyleAssociation(networkVisualStyle, tableType, colName, columnVisualStyle);
            eventHelper.fireEvent((CyEvent)new ColumnAssociatedVisualStyleSetEvent((TableVisualMappingManager)this, association));
        }
    }

    public Map<String, VisualStyle> getAssociatedColumnVisualStyles(VisualStyle networkVisualStyle, Class<? extends CyIdentifiable> tableType) {
        Map<VisualStyle, Map<String, VisualStyle>> styleMap = this.getAssociatedStyleMap(tableType);
        Map<String, VisualStyle> associatedStyles = styleMap.get(networkVisualStyle);
        if (associatedStyles == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(associatedStyles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VisualStyle> getAssociatedNetworkVisualStyles(VisualStyle columnVisualStyle) {
        HashSet<VisualStyle> networkStyles = new HashSet<VisualStyle>();
        Object object = this.lock;
        synchronized (object) {
            for (Map<VisualStyle, Map<String, VisualStyle>> styleMap : List.of(this.associatedNodeStyles, this.associatedEdgeStyles)) {
                for (Map.Entry<VisualStyle, Map<String, VisualStyle>> entry : styleMap.entrySet()) {
                    VisualStyle netStyle = entry.getKey();
                    Map<String, VisualStyle> colStyles = entry.getValue();
                    if (!colStyles.values().contains(columnVisualStyle)) continue;
                    networkStyles.add(netStyle);
                }
            }
        }
        return networkStyles;
    }

    public Set<StyleAssociation> getAssociations(VisualStyle columnVisualStyle) {
        Objects.requireNonNull(columnVisualStyle);
        return this.getStyleAssociations(columnVisualStyle);
    }

    public Set<StyleAssociation> getAllStyleAssociations() {
        return this.getStyleAssociations(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<StyleAssociation> getStyleAssociations(VisualStyle columnVisualStyle) {
        HashSet<StyleAssociation> associations = new HashSet<StyleAssociation>();
        Object object = this.lock;
        synchronized (object) {
            for (Class<CyEdge> tableType : List.of(CyNode.class, CyEdge.class)) {
                Map<VisualStyle, Map<String, VisualStyle>> networkMap = this.getAssociatedStyleMap(tableType);
                for (Map.Entry<VisualStyle, Map<String, VisualStyle>> netEntry : networkMap.entrySet()) {
                    VisualStyle netStyle = netEntry.getKey();
                    Map<String, VisualStyle> colStyles = netEntry.getValue();
                    for (Map.Entry<String, VisualStyle> colEntry : colStyles.entrySet()) {
                        String colName = colEntry.getKey();
                        VisualStyle colStyle = colEntry.getValue();
                        if (columnVisualStyle != null && !colStyle.equals(columnVisualStyle)) continue;
                        associations.add(new StyleAssociation(netStyle, tableType, colName, colStyle));
                    }
                }
            }
        }
        return associations;
    }

    private record NetworkStyleAndTableType(VisualStyle networkStyle, Class<? extends CyIdentifiable> tableType) {
    }
}

