/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.ui.debug;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.cytoscape.search.internal.progress.ProgressMonitor;
import org.cytoscape.search.internal.progress.ProgressViewer;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class ProgressPanel
extends JPanel
implements ProgressViewer {
    private static final Object[] HEADER_NAMES = new Object[]{"Network", "Progress"};
    private final boolean popup;
    private JButton clearButton;
    private JTable table;
    private JScrollPane tableScrollPane;
    private List<ProgressPopupMonitor> progressInfo = new ArrayList<ProgressPopupMonitor>();

    public ProgressPanel(boolean popup) {
        this.popup = popup;
        this.initComponents();
    }

    @Override
    public ProgressMonitor addProgress(String name) {
        ProgressPopupMonitor pm = new ProgressPopupMonitor(name);
        this.progressInfo.add(pm);
        this.updateTable();
        return pm;
    }

    public void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        JLabel title = new JLabel("Network Indexing Status");
        if (this.popup) {
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{title});
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(title, -1, -1, Short.MAX_VALUE).addComponent(this.getTableScrollPane(), 300, 300, 300));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(title, -2, -1, -2).addComponent(this.getTableScrollPane(), 100, 100, 100));
        } else {
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(title, -1, -1, Short.MAX_VALUE).addComponent(this.getTableScrollPane(), 300, 300, Short.MAX_VALUE).addComponent(this.getClearButton()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(title, -2, -1, -2).addComponent(this.getTableScrollPane(), 300, -2, Short.MAX_VALUE).addComponent(this.getClearButton()));
        }
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton("Clear");
            this.clearButton.addActionListener(e -> {
                this.progressInfo.clear();
                this.updateTable();
            });
        }
        return this.clearButton;
    }

    private JTable getTable() {
        if (this.table == null) {
            DefaultTableModel tableModel = new DefaultTableModel(HEADER_NAMES, 0);
            this.table = new JTable(tableModel);
            this.table.setTableHeader(null);
            this.table.setShowGrid(false);
            this.table.setRowSelectionAllowed(false);
            if (this.popup) {
                JTextField tmpField = new JTextField();
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{tmpField});
                this.table.setRowHeight(Math.max(this.table.getRowHeight(), tmpField.getPreferredSize().height - 4));
                this.table.setIntercellSpacing(new Dimension(0, 1));
            }
        }
        return this.table;
    }

    private JScrollPane getTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane();
            this.tableScrollPane.setViewportView(this.getTable());
            Color bg = UIManager.getColor("Table.background");
            this.tableScrollPane.setBackground(bg);
            this.tableScrollPane.getViewport().setBackground(bg);
        }
        return this.tableScrollPane;
    }

    private void updateTable() {
        Object[][] data = new Object[this.progressInfo.size()][2];
        int i = 0;
        for (ProgressPopupMonitor pm : this.progressInfo) {
            data[i][0] = pm.name;
            data[i][1] = pm;
            ++i;
        }
        DefaultTableModel model = new DefaultTableModel(data, HEADER_NAMES){

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }
        };
        this.getTable().setModel(model);
        TableColumnModel colModel = this.getTable().getColumnModel();
        colModel.getColumn(1).setMaxWidth(40);
        colModel.getColumn(0).setResizable(false);
        colModel.getColumn(1).setResizable(false);
    }

    private class ProgressPopupMonitor
    implements ProgressMonitor {
        private final String name;
        private double progess;

        public ProgressPopupMonitor(String name) {
            this.name = name;
        }

        @Override
        public void addProgress(double progress) {
            this.progess = Math.max(0.0, Math.min(1.0, this.progess + progress));
            ((DefaultTableModel)ProgressPanel.this.getTable().getModel()).fireTableDataChanged();
        }

        @Override
        public void done() {
            if (ProgressPanel.this.popup) {
                ProgressPanel.this.progressInfo.remove(this);
                ProgressPanel.this.updateTable();
            }
        }

        public String toString() {
            return String.format("%.0f%%", this.progess * 100.0);
        }
    }
}

