/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.cytoscape.search.internal.search.SearchResults;
import org.cytoscape.search.internal.search.SearchTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public abstract class SearchBox
extends JPanel {
    private CyServiceRegistrar registrar;
    private JTextField searchTextField;
    private static final String TOOLTIP_TEXT = "<html>\nExample Search Queries:<br>\n<br>\n<table>\n<tr><td><b>YL</b></td><td>Search all text columns for the exact word \"YL\"</td></tr>\n<tr><td><b>YL*</b></td><td>Search all text columns for words that start with \"YL\"</td></tr>\n<tr><td><b>name:YL</b></td><td>Search the \"name\" column for \"YL\"</td></tr>\n<tr><td><b>GO\\:1232</b></td><td>Escape special characters and spaces with a backslash</td></tr>\n<tr><td><b>pvalue:0.1</b></td><td>Numeric searches must include the column name</td></tr>\n<tr><td><b>pvalue:[0.2 TO 0.4]</b></td><td>Search the \"pvalue\" column for values between 0.2 and 0.4 inclusive</td></tr>\n</table>\n<br>\nSee the Cytoscape Manual for more examples.\n</html>";

    public abstract SearchTask getSearchTask(String var1);

    public SearchBox(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.initComponents();
    }

    protected CyServiceRegistrar getServiceRegistrar() {
        return this.registrar;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getSearchTextField(), 120, 240, 300));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getSearchTextField(), -2, -1, -2));
    }

    private JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            final String defText = "Enter search term...";
            final Font defFont = UIManager.getFont("TextField.font") != null ? UIManager.getFont("TextField.font").deriveFont(LookAndFeelUtil.getSmallFontSize()) : null;
            this.searchTextField = new JTextField();
            this.searchTextField.putClientProperty("JTextField.variant", "search");
            this.searchTextField.setToolTipText(TOOLTIP_TEXT);
            this.searchTextField.setName("tfSearchText");
            this.searchTextField.addMouseListener(new DismissDelayMouseAdapter((int)TimeUnit.MINUTES.toMillis(5L)));
            if (!LookAndFeelUtil.isAquaLAF()) {
                this.searchTextField.setText(defText);
                if (defFont != null) {
                    this.searchTextField.setFont(defFont);
                }
            }
            this.searchTextField.addActionListener(evt -> this.doSearching());
            this.searchTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (SearchBox.this.searchTextField.getText().equals(defText)) {
                        SearchBox.this.searchTextField.setText("");
                        SearchBox.this.searchTextField.setFont(UIManager.getFont("TextField.font"));
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!LookAndFeelUtil.isAquaLAF() && SearchBox.this.searchTextField.getText().trim().isEmpty()) {
                        SearchBox.this.searchTextField.setText(defText);
                        if (defFont != null) {
                            SearchBox.this.searchTextField.setFont(defFont);
                        }
                    }
                }
            });
            this.setKeyBindings(this.searchTextField);
        }
        return this.searchTextField;
    }

    private void doSearching() {
        String queryStr = this.searchTextField.getText().trim();
        if (queryStr.length() == 0) {
            return;
        }
        final SearchTask searchTask = this.getSearchTask(queryStr);
        DialogTaskManager taskMgr = (DialogTaskManager)this.registrar.getService(DialogTaskManager.class);
        taskMgr.execute(new TaskIterator(new Task[]{searchTask}), new TaskObserver(){

            public void allFinished(FinishStatus status) {
                if (status.getType() == FinishStatus.Type.SUCCEEDED) {
                    SearchResults results = searchTask.getResults(SearchResults.class);
                    if (results == null) {
                        return;
                    }
                    String message = searchTask.getResults(String.class);
                    SearchBox.this.showPopup(message, results.isError());
                }
            }

            public void taskFinished(ObservableTask task) {
            }
        });
    }

    private void setKeyBindings(JComponent comp) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "FOCUS");
        actionMap.put("FOCUS", new KeyAction("FOCUS"));
    }

    protected void showPopup(String message, boolean error) {
        if (message == null) {
            return;
        }
        JLabel label = new JLabel();
        label.setText("   " + message + "   ");
        if (error) {
            label.setForeground(Color.RED);
        }
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{label});
        JPopupMenu popup = new JPopupMenu();
        popup.add(label);
        Timer timer = new Timer(3400, e -> popup.setVisible(false));
        timer.setRepeats(false);
        timer.start();
        popup.show(this.searchTextField, 0, this.searchTextField.getHeight());
    }

    private class DismissDelayMouseAdapter
    extends MouseAdapter {
        final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        final int dismissDelayMinutes;

        public DismissDelayMouseAdapter(int milliseconds) {
            this.dismissDelayMinutes = milliseconds;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
        }
    }

    private class KeyAction
    extends AbstractAction {
        static final String FOCUS = "FOCUS";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(FOCUS) && SearchBox.this.searchTextField.isVisible()) {
                SearchBox.this.searchTextField.requestFocusInWindow();
                SearchBox.this.searchTextField.selectAll();
            }
        }
    }
}

