/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.ui;

import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.search.internal.index.SearchManager;
import org.cytoscape.search.internal.search.NetworkTableSearchTask;
import org.cytoscape.search.internal.search.SearchTask;
import org.cytoscape.search.internal.ui.SearchBox;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTableSearchBox
extends SearchBox {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyServiceRegistrar registrar;
    private final SearchManager searchManager;

    public NetworkTableSearchBox(CyServiceRegistrar registrar, SearchManager searchManager) {
        super(registrar);
        this.registrar = registrar;
        this.searchManager = searchManager;
    }

    @Override
    public SearchTask getSearchTask(String queryString) {
        CyApplicationManager appManager = (CyApplicationManager)this.registrar.getService(CyApplicationManager.class);
        CyNetworkTableManager networkTableManager = (CyNetworkTableManager)this.registrar.getService(CyNetworkTableManager.class);
        CyTable currentTable = appManager.getCurrentTable();
        if (currentTable == null) {
            logger.error("Could not find table for search");
            return null;
        }
        CyNetwork network = networkTableManager.getNetworkForTable(currentTable);
        if (network == null) {
            logger.error("Could not find network for table to search");
            return null;
        }
        return new NetworkTableSearchTask(this.searchManager, queryString, network, currentTable);
    }
}

