/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.search.internal.index.SearchManager;
import org.cytoscape.search.internal.ui.NetworkTableSearchBox;
import org.cytoscape.service.util.CyServiceRegistrar;

public class NetworkTableSearchAction
extends AbstractCyAction {
    private static String TITLE = "Search Table...";
    private final CyServiceRegistrar registrar;
    private final SearchManager searchManager;
    private NetworkTableSearchBox searchBox;

    public NetworkTableSearchAction(CyServiceRegistrar registrar, SearchManager searchManager, Icon icon, float toolbarGravity) {
        super(TITLE);
        this.registrar = registrar;
        this.searchManager = searchManager;
        this.putValue("ShortDescription", TITLE);
        this.putValue("SwingLargeIconKey", icon);
        this.setIsInNodeTableToolBar(true);
        this.setIsInEdgeTableToolBar(true);
        this.setIsInNetworkTableToolBar(false);
        this.setIsInUnassignedTableToolBar(false);
        this.setToolbarGravity(toolbarGravity);
        this.insertSeparatorAfter();
    }

    public void actionPerformed(ActionEvent evt) {
        Object object = evt.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            this.showSearchPopup(component);
        }
    }

    private NetworkTableSearchBox getSearchBox() {
        if (this.searchBox == null) {
            this.searchBox = new NetworkTableSearchBox(this.registrar, this.searchManager);
        }
        return this.searchBox;
    }

    private void showSearchPopup(Component invoker) {
        NetworkTableSearchBox searchBox = this.getSearchBox();
        JPopupMenu popup = new JPopupMenu();
        popup.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
        popup.add(searchBox);
        popup.pack();
        popup.show(invoker, 0, invoker.getHeight());
    }
}

