/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.search;

import org.cytoscape.model.CyTable;
import org.cytoscape.search.internal.index.SearchManager;
import org.cytoscape.search.internal.search.SearchResults;
import org.cytoscape.search.internal.search.SearchTask;
import org.cytoscape.search.internal.search.TableRowSelectorTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class TableSearchTask
extends SearchTask {
    private final CyServiceRegistrar registrar;
    private final CyTable table;

    public TableSearchTask(CyServiceRegistrar registrar, SearchManager searchManager, String queryString, CyTable table) {
        super(searchManager, queryString, table);
        this.table = table;
        this.registrar = registrar;
    }

    @Override
    public void run(TaskMonitor tm) {
        SearchResults results = super.runQuery(tm);
        this.insertTasksAfterCurrentTask(new Task[]{new TableRowSelectorTask(this.registrar, this.table, results)});
    }

    @Override
    public <R> R getResults(Class<? extends R> type) {
        if (String.class.equals(type)) {
            SearchResults results = super.getResults(SearchResults.class);
            return type.cast(this.getPopupMessage(results));
        }
        return super.getResults(type);
    }

    private String getPopupMessage(SearchResults results) {
        if (results.isError() || results.getErrorMessage() != null) {
            return results.getErrorMessage();
        }
        int hitCount = results.getHitCount(this.table);
        if (hitCount == 1) {
            return "Selected 1 row";
        }
        return "Selected " + hitCount + " rows";
    }
}

